package com.sonicsw.mf.common.runtime;

/**
 * Defines a standard set of logging severity levels. It is intended as a way
 * of partially replicating what is comming in the java.util.logging package
 * in JDK 1.4.
 * <p>
 * It is intended for use when logging messages through a component context,
 * registering a component error condition through the component context, etc.
 */
public final class Level
{
    /** UNKNOWN is an undefined level and should not be generally used, */
    public static final int UNKNOWN = 0;

    /** SEVERE is a message/notification level indicating a serious failure. */
    public static final int SEVERE = 1;

    /** WARNING is a message/notification level indicating a potential problem. */
    public static final int WARNING = 2;

    /** INFO is a message/notification level for informational messages. */
    public static final int INFO = 3;

    /** CONFIG is a message/notification level for static configuration messages. */
    public static final int CONFIG = 4;

    /** FINE is a message level providing tracing information. */
    public static final int FINE = 5;

    /** FINER indicates a fairly detailed tracing message. */
    public static final int FINER = 6;

    /** FINEST indicates a highly detailed tracing message. */
    public static final int FINEST = 7;

    /**
     * TRACE is the same value as FINEST. It is reserved for tracing information
     * generated for debugging.
     */
    public static final int TRACE = 7;

    /** Textual representations of levels. */
    public static final String[] LEVEL_TEXT =
        new String[] { "no error", "severe", "warning", "info", "config", "trace", "trace", "trace" };
}
