package com.sonicsw.mf.common.runtime;

import com.sonicsw.mf.common.MFException;

/**
 * Thrown by an IStateController when it has determined that it will never be able to
 * perform a requested state change without manual corrective action. The same excpetion
 * will be propagated by an IStateManager.
 *
 * @see com.sonicsw.mf.common.runtime.IStateController#changeState()
 * @see com.sonicsw.mf.common.runtime.IStateManager#requestStateChange(short, short, Object)
 */
public class NonRecoverableStateChangeException
extends MFException
{
    public NonRecoverableStateChangeException(String message) { super(message); }
}