package com.sonicsw.mf.common.runtime;

import com.sonicsw.mf.common.MFException;

/**
 * Thrown by an IStateController when it has determined that it cannot perform the requested
 * state change without backing out the requested state change and re-evaluating whether the
 * requested state change is still required. The same excpetion will be propagated by an
 * IStateManager.
 * <p>
 * Not all state change implementations will support recovery.
 *
 * @see com.sonicsw.mf.common.runtime.IStateController#changeState()
 * @see com.sonicsw.mf.common.runtime.IStateManager#requestStateChange(short, short, Object)
 */
public class RecoverableStateChangeException
extends MFException
{
    public RecoverableStateChangeException(String message) { super(message); }
}
