package com.sonicsw.mf.common.runtime.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentIdentity;

public final class ComponentIdentity
extends ContainerIdentity
implements IComponentIdentity, Serializable
{
    private static final long serialVersionUID = 5163047150767243748L;
    private static final short m_serialVersion = 0;

    private String m_componentName;

    public ComponentIdentity(CanonicalName canonicalName, IElementIdentity configID)
    {
        super(canonicalName, configID);
        m_componentName = canonicalName.getComponentName();
    }

    @Override
    public String getCanonicalName() { return super.getCanonicalName() + DELIMITED_ID_PREFIX + m_componentName; }

    @Override
    public String getComponentName() { return m_componentName; }

    @Override
    public String toString() { return getCanonicalName(); }

    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof IComponentIdentity))
        {
            return false;
        }
        return toString().equals(object.toString()) && getConfigIdentity().equals(((IComponentIdentity)object).getConfigIdentity());
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(toString(), getConfigIdentity());
    }

    @Override
    public int compareTo(Object object)
    throws ClassCastException
    {
        return toString().compareTo(((IComponentIdentity)object).toString());
    }

    //
    // Serialization
    //

    private void writeObject(ObjectOutputStream stream)
    throws IOException
    {
        // we know how many fields we will write
        stream.writeInt(2);

        // MFNotification specific fields

        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(m_serialVersion));

        stream.writeUTF("componentName");
        stream.writeObject(m_componentName);
    }

    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
    {
        // read the number of items and stuff them in a hash map
        int numValues = stream.readInt();
        HashMap map = new HashMap(numValues);
        for (int i = 0; i < numValues; i++)
        {
            map.put(stream.readUTF(), stream.readObject());
        }

        // now map them back into the local variables based on the version
        // Note: As a general rule need to catch exceptions and either do something to set a default
        //       value or ignore

        switch(((Short)map.get("serialVersion")).shortValue())
        {
            // case olderVersion<n> ...
            // case olderVersion<n> ...
            default: // the current version or newer versions
            {
                try { m_componentName = (String)map.get("componentName"); } catch(Exception e) {}
                break;
            }
        }
    }
}
