package com.sonicsw.mf.common.runtime.impl;

public class FileDescriptor implements com.sonicsw.mf.common.runtime.IFileDescriptor, java.io.Serializable
{
    private static final long serialVersionUID = 0L;

    private String m_name;
    private String m_parent;
    private String m_path;
    private boolean m_isAbsolute;
    private String m_absolutePath;
    private boolean m_canRead;
    private boolean m_canWrite;
    private boolean m_isDirectory;
    private boolean m_isFile;
    private boolean m_isHidden;
    private long m_lastModified;
    private long m_length;

    public FileDescriptor(java.io.File file)
    {
        m_name = file.getName();
        m_parent = file.getParent();
        m_path = file.getPath();
        m_isAbsolute = file.isAbsolute();
        m_absolutePath = file.getAbsolutePath();
        m_canRead = file.canRead();
        m_canWrite = file.canWrite();
        m_isDirectory = file.isDirectory();
        m_isFile = file.isFile();
        m_isHidden = file.isHidden();
        m_lastModified = file.lastModified();
        m_length = file.length();
    }

    public void setName(String name) { m_name = name; }
    public void setParent(String parent) { m_parent = parent; }
    public void setPath(String path) { m_path = path; }
    public void setIsAbsolute(boolean isAbsolute) { m_isAbsolute = isAbsolute; }
    public void setAbsolutePath(String absolutePath) { m_absolutePath = absolutePath; }
    public void setCanRead(boolean canRead) { m_canRead = canRead; }
    public void setCanWrite(boolean canWrite) { m_canWrite = canWrite; }
    public void setIsDirectory(boolean isDirectory) {; }
    public void setIsFile(boolean isFile) { m_isFile = isFile; }
    public void setIsHidden(boolean isHidden) { m_isHidden = isHidden; }
    public void setLastModified(long lastModified) { m_lastModified = lastModified; }
    public void setLength(long length) { m_length = length; }

    @Override
    public String getName() { return m_name; }
    @Override
    public String getParent() { return m_parent; }
    @Override
    public String getPath() { return m_path; }
    @Override
    public boolean isAbsolute() { return m_isAbsolute; }
    @Override
    public String getAbsolutePath() { return m_absolutePath; }
    @Override
    public boolean canRead() { return m_canRead; }
    @Override
    public boolean canWrite() { return m_canWrite; }
    @Override
    public boolean isDirectory() { return m_isDirectory; }
    @Override
    public boolean isFile() { return m_isFile; }
    @Override
    public boolean isHidden() { return m_isHidden; }
    @Override
    public long lastModified() { return m_lastModified; }
    @Override
    public long length() { return m_length; }

}