package com.sonicsw.mf.common.runtime.impl;

import java.io.Serializable;
import java.util.Vector;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.runtime.IMonitoredMetrics;

public class MonitoredMetrics
implements IMonitoredMetrics, Serializable
{
    private Vector m_metrics = new Vector();  // we don't want to force callers to check for "null", so create a non-null object even if there are no retrieved metrics...
    private long m_latestTimestamp;
    private boolean m_moreDataToRetrieve = false;

    private static final IHistoricalMetric[] EMPTY_METRIC_ARRAY = new IHistoricalMetric[0];

    @Override
    public IHistoricalMetric[] getMetrics()
    {
        IHistoricalMetric[] metrics = (IHistoricalMetric[]) m_metrics.toArray(EMPTY_METRIC_ARRAY);

        return metrics;
    }

    @Override
    public long getLatestTimestamp()
    {
        return m_latestTimestamp;
    }

    @Override
    public boolean hasMoreDataToRetrieve()
    {
        return m_moreDataToRetrieve;
    }

    public void addMetric(IHistoricalMetric metric)
    {
        if ((metric != null) && (!m_metrics.contains(metric)))
        {
            m_metrics.add(metric);
        }
    }

    public void setLatestTimestamp(long timestamp)
    {
        m_latestTimestamp = timestamp;
    }

    public void setMoreDataToRetrieve(boolean moreData)
    {
        m_moreDataToRetrieve = moreData;
    }
}