package com.sonicsw.mf.common.runtime.impl;

import java.io.Serializable;
import java.util.Vector;

import com.sonicsw.mf.common.runtime.IMonitoredNotifications;
import com.sonicsw.mf.common.runtime.INotification;

public class MonitoredNotifications
implements IMonitoredNotifications, Serializable
{
    private Vector m_notifications = new Vector();  // we don't want to force callers to check for "null", so create a non-null object even if there are no retrieved notifications...
    private long m_latestTimestamp;
    private boolean m_moreDataToRetrieve = false;

    private static final INotification[] EMPTY_NOTIFICATION_ARRAY = new INotification[0];

    @Override
    public INotification[] getNotifications()
    {
        INotification[] notifications = (INotification[]) m_notifications.toArray(EMPTY_NOTIFICATION_ARRAY);

        return notifications;
    }

    @Override
    public long getLatestTimestamp()
    {
        return m_latestTimestamp;
    }

    @Override
    public boolean hasMoreDataToRetrieve()
    {
        return m_moreDataToRetrieve;
    }

    public void addNotification(INotification notification)
    {
        if ((notification != null) && (!m_notifications.contains(notification)))
        {
            m_notifications.add(notification);
        }
    }

    public void setLatestTimestamp(long timestamp)
    {
        m_latestTimestamp = timestamp;
    }

    public void setMoreDataToRetrieve(boolean moreData)
    {
        m_moreDataToRetrieve = moreData;
    }
}