package com.sonicsw.mf.common.runtime.impl;

import java.io.Serializable;

import com.sonicsw.mf.common.runtime.IRemoteCallResult;


public class RemoteCallResult implements IRemoteCallResult, Serializable
{
    private static final long serialVersionUID = 0L;

    protected boolean m_successful;
    protected String m_output;

    public RemoteCallResult(boolean successful, String output)
    {
        m_successful = successful;
        m_output = output;
    }

    @Override
    public boolean isSuccessful()
    {
        return m_successful;
    }

    @Override
    public String getOutput()
    {
        return m_output;
    }

    @Override
    public String toString()
    {
        return "isSuccessful " + m_successful + " getOutput " + m_output;
    }
}