package com.sonicsw.mf.common.runtime.impl;

import java.io.Serializable;

import com.sonicsw.mf.common.runtime.IRemoteExecResult;


public final class RemoteExecResult extends RemoteCallResult implements IRemoteExecResult, Serializable
{
    private static final long serialVersionUID = 0L;

    private int m_exitCode;
    private byte[] m_stdOutput;
    private byte[] m_stdError;

    public RemoteExecResult(boolean successful, String stackTrace, int exitCode, byte[] processStdOutput, byte[] processStdError)
    {
        super(successful, stackTrace);
        m_stdOutput = processStdOutput;
        m_stdError = processStdError;
    }

    @Override
    public int getExitCode()
    {
        return m_exitCode;
    }

    @Override
    public byte[] getProcessStdOutput()
    {
        return m_stdOutput;
    }

    @Override
    public byte[] getProcessStdError()
    {
        return m_stdError;
    }

    @Override
    public String toString()
    {
        return super.toString() + " getExitCode " + m_exitCode + " getProcessStdOutput length " +  (m_stdOutput != null ? m_stdOutput.length : 0) + " getProcessStdError length " + +  (m_stdError != null ? m_stdError.length : 0);
    }

}