package com.sonicsw.mf.common.security;

/**
 * This interface describes the bits used to define management "configure" permissions.
 * 
 * @see IManagementPermission#setPermissions(int)
 * @see IConfigureScopeBits
 * @see IManagePermissionBits
 */
public interface IConfigurePermissionBits
{
    /** Permission bit to allow reading of a configuration or file or listing of a folder. */
    public static final int ALLOW_READ = 1;

    /** Permission bit to deny reading of a configuration or listing of a folder. */
    public static final int DENY_READ = ALLOW_READ << 1;

    /** Permission bit to allow updating of a configuration or file. */
    public static final int ALLOW_WRITE = DENY_READ << 1;

    /** Permission bit to deny updating of a configuration or file. */
    public static final int DENY_WRITE = ALLOW_WRITE << 1;

    /** Permission bit to allow delete of a folder, configuration or file. */
    public static final int ALLOW_DELETE = DENY_WRITE << 1;

    /** Permission bit to deny delete of a folder, configuration or file. */
    public static final int DENY_DELETE = ALLOW_DELETE << 1;

    /** Permission bit to allow setting management permissions on a configuration entity. */
    public static final int ALLOW_SET_PERMISSIONS = DENY_DELETE << 1;

    /** Permission bit to deny setting management permissions on a configuration entity. */
    public static final int DENY_SET_PERMISSIONS = ALLOW_SET_PERMISSIONS << 1;
}
