package com.sonicsw.mf.common.security;

/**
 * This interface describes the bits used to define management "configure" scopes.
 * 
 * @see IManagementPermission#setScope(int)
 * @see IConfigurePermissionBits
 * @see IManageScopeBits
 */
public interface IConfigureScopeBits
{
    /** Scope bit to include this folder. */
    public static final int THIS_FOLDER_SCOPE = 1;

    /** Scope bit to recursively include all subfolders. */
    public static final int ALL_FOLDERS_SCOPE = THIS_FOLDER_SCOPE << 1;

    /** Scope bit to include this configuration or file. */
    public static final int THIS_CONFIGURATION_OR_FILE_SCOPE = ALL_FOLDERS_SCOPE << 1;

    /** Scope bit to include all configurations or files. */
    public static final int ALL_CONFIGURATIONS_AND_FILES_SCOPE = THIS_CONFIGURATION_OR_FILE_SCOPE << 1;
}
