package com.sonicsw.mf.common.security;

/**
 * This interface describes the bits used to define management "manage" permissions.
 * 
 * @see IManagementPermission#setPermissions(int)
 * @see IManageScopeBits
 * @see IConfigurePermissionBits
 */
public interface IManagePermissionBits
{
    /** Permission bit to allow life cycle type operations to be executed (e.g. stop, start, shutdown, etc.). */
    public static final int ALLOW_LIFE_CYCLE_CONTROL = 1;

    /** Permission bit to deny life cycle type operations from being executed (e.g. stop, start, shutdown, etc.). */
    public static final int DENY_LIFE_CYCLE_CONTROL = ALLOW_LIFE_CYCLE_CONTROL << 1;

    /** Permission bit to allow operations associated with metrics exposed by containers/components. */
    public static final int ALLOW_ENABLE_DISABLE_METRICS = DENY_LIFE_CYCLE_CONTROL << 1;

    /** Permission bit to deny operations associated with metrics exposed by containers/components. */
    public static final int DENY_ENABLE_DISABLE_METRICS = ALLOW_ENABLE_DISABLE_METRICS << 1;

    /** Permission bit to allow JMX notification listeners to be added to a container/component. */
    public static final int ALLOW_NOTIFICATION_SUBSCRIPTION = DENY_ENABLE_DISABLE_METRICS << 1;

    /** Permission bit to deny JMX notification listeners from being added to a container/component. */
    public static final int DENY_NOTIFICATION_SUBSCRIPTION = ALLOW_NOTIFICATION_SUBSCRIPTION << 1;

    /** Permission bit to allow runtime attributes to be set on a container/component. */
    public static final int ALLOW_SET_ATTRIBUTES = DENY_NOTIFICATION_SUBSCRIPTION << 1;

    /** Permission bit to deny runtime attributes from being set on a container/component. */
    public static final int DENY_SET_ATTRIBUTES = ALLOW_SET_ATTRIBUTES << 1;

    /** Permission bit to allow other JMX operations with an "impact" of <a href="../../../../../javax/management/MBeanOperationInfo.html#ACTION">ACTION</a> or
     *  <a href="../../../../../javax/management/MBeanOperationInfo.html#ACTION_INFO">ACTION_INFO</a> to be executed. */
    public static final int ALLOW_PERFORM_ACTIONS = DENY_SET_ATTRIBUTES << 1;

    /** Permission bit to deny other JMX operations with an "impact" of <a href="../../../../../javax/management/MBeanOperationInfo.html#ACTION">ACTION</a> or
     *  <a href="../../../../../javax/management/MBeanOperationInfo.html#ACTION_INFO">ACTION_INFO</a> from being executed. */
    public static final int DENY_PERFORM_ACTIONS = ALLOW_PERFORM_ACTIONS << 1;

    /** Permission bit to allow other JMX operations with an "impact" of <a href="../../../../../javax/management/MBeanOperationInfo.html#INFO">INFO</a> or
     *  <a href="../../../../../javax/management/MBeanOperationInfo.html#UNKNOWN">UNKNOWN</a> to be executed. */
    public static final int ALLOW_GET_INFORMATION = DENY_PERFORM_ACTIONS << 1;

    /** Permission bit to deny other JMX operations with an "impact" of <a href="../../../../../javax/management/MBeanOperationInfo.html#INFO">INFO</a> or
     *  <a href="../../../../../javax/management/MBeanOperationInfo.html#UNKNOWN">UNKNOWN</a> from being executed. */
    public static final int DENY_GET_INFORMATION = ALLOW_GET_INFORMATION << 1;
}
