package com.sonicsw.mf.common.security;

/**
 * This interface describes the bits used to define management "manage" scopes.
 * 
 * @see IManagementPermission#setScope(int)
 * @see IManagePermissionBits
 * @see IConfigureScopeBits
 */
public interface IManageScopeBits
{
    /** Scope bit to recursively include all subfolders. */
    public static final int ALL_FOLDERS_SCOPE = 1;

    /** Scope bit to include this container. */
    public static final int THIS_CONTAINER_SCOPE = ALL_FOLDERS_SCOPE << 1;

    /** Scope bit to include all containers. */
    public static final int ALL_CONTAINERS_SCOPE = THIS_CONTAINER_SCOPE << 1;

    /** Scope bit to include this component. */
    public static final int THIS_COMPONENT_SCOPE = ALL_CONTAINERS_SCOPE << 1;

    /** Scope bit to include all components. */
    public static final int ALL_COMPONENTS_SCOPE = THIS_COMPONENT_SCOPE << 1;
}
