package com.sonicsw.mf.common.security;

/**
 * This interface defines the API of a management permission object.
 * 
 * @see ManagementPermissionFactory
 * @see IManagementSecurityConfigurator
 * @see IConfigurePermissionBits
 * @see IManagePermissionBits
 * @see IConfigureScopeBits
 * @see IManageScopeBits
 */
public interface IManagementPermission
{
    /** Constant for the IManagementPermission.SUPER_USER_NAME super-user identity. */
    public static final String SUPER_USER_NAME = "Administrator";

    /** Constant for the "configure" management permission type. */
    public static final String CONFIGURE_TYPE = "configure";

    /** Constant for the "manage" management permission type. */
    public static final String MANAGE_TYPE = "manage";
    
    /** Constant for an unknown principal type. */
    public static final short UNKNOWN_PRINCIPAL_TYPE = 0;

    /** Constant for a user principal type. */
    public static final short USER_PRINCIPAL_TYPE = 1;

    /** Constant for a group principal type. */
    public static final short GROUP_PRINCIPAL_TYPE = 2;
    
    /**
     * Gets the principal to which the management permission applies.
     *
     * @return The principal name.
     *
     * @see #getPrincipalType()
     */
    public String getPrincipal();
    
    /**
     * Gets the principal type to which the management permission applies.
     *
     * @return The principal type.
     *
     * @see #getPrincipal()
     * @see #USER_PRINCIPAL_TYPE
     * @see #GROUP_PRINCIPAL_TYPE
     */
    public short getPrincipalType();

    /**
     * Gets the scope to which the management permission applies.
     *
     * @see #setScope(int)
     * @see IConfigureScopeBits
     * @see IManageScopeBits
     */
    public int getScope();

    /**
     * Sets the scope to which the management permission applies.
     *
     * @param scope The sum of the scope bits to which the management permission applies.
     *
     * @see #getScope()
     * @see IConfigureScopeBits
     * @see IManageScopeBits
     */
    public void setScope(int scope);

    /**
     * Gets the permissions to be applied.
     *
     * @see #setPermissions(int)
     * @see IConfigurePermissionBits
     * @see IManagePermissionBits
     */
    public int getPermissions();

    /**
     * Sets the permissions to be applied.
     *
     * @param permissions The sum of the permission bits to be applied.
     *
     * @see #getPermissions()
     * @see IConfigurePermissionBits
     * @see IManagePermissionBits
     */
    public void setPermissions(int permissions);
}
