package com.sonicsw.mf.common.security;

import com.sonicsw.mf.common.MFException;

/**
 * Checked management exception.
 * <p>
 * Indicates that a given IManagementPermission was invalid the reason for which is contained in the
 * exception message.
 *
 * @see IManagementSecurityConfigurator
 */
public class InvalidManagementPermissionException
extends MFException
{
    private static final long serialVersionUID = 0L;

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #setLinkedException}.
     *
     * @param message The textural details of why the management permission was invalid.
     */
    public InvalidManagementPermissionException(String message)
    {
        super(message);
    }
}
