package com.sonicsw.mf.common.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

/**
 * Unchecked management exception.
 * <p>
 * Indicates that a caller attempted to directly or indirectly perform some action
 * on a container or component but did not have permission to perform that action.
 */
public class ManagePermissionDeniedException
extends ManagementPermissionDeniedException
{
    private static final long serialVersionUID = 0L;
    private static final short m_serialVersion = 0;

    private String m_target;
    private int m_requiredPermission;
    
    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #setLinkedException}.
     *
     * @param message The textural details of why the permission was denied.
     * @param target The target component to which the permission was denied.
     * @param requiredPermission The permission that was denied.
     * 
     * @see IManagePermissionBits
     */
    public ManagePermissionDeniedException(String message, String target, int requiredPermission)
    {
        super(message);
        m_target = target;
        m_requiredPermission = requiredPermission;
    }
    
    /**
     * Gets the target component to which the permission was denied.
     */
    public String getTarget()
    {
        return m_target;
    }

    /**
     * Gets the permission that was denied.
     * 
     * @see IManagePermissionBits
     */
    public int getRequiredPermission()
    {
        return m_requiredPermission;
    }
    
    private void writeObject(ObjectOutputStream stream)
    throws IOException
    {
        // we know how many fields we will write
        stream.writeInt(3);

        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(m_serialVersion));

        stream.writeUTF("target");
        stream.writeObject(m_target);

        stream.writeUTF("requiredPermission");
        stream.writeObject(new Integer(m_requiredPermission));
    }

    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
    {
        // read the number of items and stuff them in a hash map
        int numValues = stream.readInt();
        HashMap map = new HashMap(numValues);
        for (int i = 0; i < numValues; i++)
        {
            map.put(stream.readUTF(), stream.readObject());
        }

        // now map them back into the local variables based on the version
        // Note: As a general rule need to catch exceptions and either do something to set a default
        //       value or ignore

        switch(((Short)map.get("serialVersion")).shortValue())
        {
            // case olderVersion<n> ...
            // case olderVersion<n> ...
            default: // the current version or newer versions
            {
                // MFRuntimeException fields
                try { m_target = (String)map.get("target"); } catch(Exception e) {}
                try { m_requiredPermission = ((Integer)map.get("requiredPermission")).intValue(); } catch(Exception e) {}
                break;
            }
        }
    }
}
