package com.sonicsw.mf.common.security;

import com.sonicsw.mf.common.security.impl.ManagementPermission;

/**
 * This factory is used to create <a href="IManagementPermission.html">IManagementPermission</a> instances.
 * 
 * @see IManagementPermission
 * @see IManagementSecurityConfigurator
 * @see IConfigurePermissionBits
 * @see IManagePermissionBits
 * @see IConfigureScopeBits
 * @see IManageScopeBits
 */
public class ManagementPermissionFactory
{
    /**
     * Creates a management permission object to define a new management permission.
     *
     * @param principal
     *        The user or group to which the permission will apply.
     * @param principalType
     *        Whether the given principal is a user (<a href="IManagementPermission.html#USER_PRINCIPAL_TYPE">USER_PRINCIPAL_TYPE</a>)
     *        or a group (<a href="IManagementPermission.html#GROUP_PRINCIPAL_TYPE">GROUP_PRINCIPAL_TYPE</a>).
     *
     * @see IManagementSecurityConfigurator#setManagementPermissions(java.lang.String[], java.lang.String, com.sonicsw.mf.common.security.IManagementPermission[][])
     */
    public IManagementPermission createManagementPermission(String principal, short principalType)
    {
        return new ManagementPermission(principal, principalType);
    }

    /**
     * Creates a management permission object to define a new management permission.
     *
     * @param principal
     *        The user or group to which the permission will apply.
     * @param principalType
     *        Whether the given principal is a user (<a href="IManagementPermission.html#USER_PRINCIPAL_TYPE">USER_PRINCIPAL_TYPE</a>)
     *        or a group (<a href="IManagementPermission.html#GROUP_PRINCIPAL_TYPE">GROUP_PRINCIPAL_TYPE</a>).
     * @param scope
     *        The sum of the scope bits to which the permission should apply.
     * @param permissions
     *        The sum of the permission bits to which the permission should apply.
     *
     * @see IManagementSecurityConfigurator#setManagementPermissions(java.lang.String[], java.lang.String, com.sonicsw.mf.common.security.IManagementPermission[][])
     * @see IConfigurePermissionBits
     * @see IManagePermissionBits
     * @see IConfigureScopeBits
     * @see IManageScopeBits
     */
    public IManagementPermission createManagementPermission(String principal, short principalType, int scope, int permissions)
    {
        return new ManagementPermission(principal, principalType, scope, permissions);
    }
}
