package com.sonicsw.mf.common.url;

import java.net.MalformedURLException;


/** Taken from progress.message.zclient.BrokerURL
  */
  
public final class BrokerURL
{
    //  this class has the following attributes and constants:
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL = "ssl";
    private static final String SSL_IAIK = "ssl.iaik";
    private static final String LOCALHOST = "localhost";
    private static final int PORT_DEFAULT = 2506;
    
    private String m_brokerURL;
    private String m_brokerHostName = LOCALHOST;
    private String m_brokerProtocol = TCP;
    private int m_brokerPort;
    private boolean m_allowsEmptyHostname = false;

    /** construct the class 
      *
      * @param brokerURL the URL (in the form [protocol://]hostname[:port]) 
      * of the message broker to which connection are made.
      * the constructor parse the URL and sets all the attributes
      *
      * @throws MalformedURLException if brokerURL is not valid
      *
      **/
      
    public BrokerURL(String brokerURL)
    throws MalformedURLException
    {
        parseURL(brokerURL);
    }
    
    public BrokerURL(String brokerURL, boolean allowsEmptyHostname)
    throws MalformedURLException
    {
        m_allowsEmptyHostname = allowsEmptyHostname;
        parseURL(brokerURL);
    }

    // simple accessors
    public String getBrokerURL() { return m_brokerURL; }
    public String getBrokerHostName() { return m_brokerHostName; }
    public String getBrokerProtocol() { return m_brokerProtocol; }
    public int getBrokerPort() { return m_brokerPort; }
        
    // parse the brokerURL string, extract brokerProtocol, brokerHostName, brokerPort.
    // If the brokerURL string starts with "http", "ssl" or "ssl.iaik"
    // set m_brokerProtocol accordingly.
    // If the brokerURL string contains ":", extract brokerPort and set it.
    
    private void parseURL (String brokerURL) throws MalformedURLException
    {        
        if (brokerURL == null || brokerURL.equals(""))
        {
            if (m_allowsEmptyHostname)
             {
                m_brokerHostName = null;  // don't keep it set to "localhost"
            }
         
            return;
        }
            
        brokerURL = brokerURL.trim();
        
        String host;
        m_brokerURL = brokerURL;
        // URL string may start with "tcp"
        if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase(TCP+"://"))
        {
            m_brokerProtocol = TCP;
            // Remove the "tcp://" from the front of the string.
            host = brokerURL.substring(6);
        }
        // Should we use HTTP tunneling?
        else if (brokerURL.length() >= 7 && brokerURL.substring(0, 7).equalsIgnoreCase(HTTP+"://"))
        {
            m_brokerProtocol = HTTP;
            host = brokerURL.substring(7);
        }
        else if (brokerURL.length() >= 8 && brokerURL.substring(0, 8).equalsIgnoreCase(HTTPS+"://"))
        {
            m_brokerProtocol = HTTPS;
            host = brokerURL.substring(8);
        }
        // Should we use ssl?
        else if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase(SSL+"://"))
        {
            m_brokerProtocol = SSL;
            host = brokerURL.substring(6);
        }
        else if (brokerURL.length() >= 11 && brokerURL.substring(0, 11).equalsIgnoreCase(SSL_IAIK+"://"))
        {
            m_brokerProtocol = SSL;
            host = brokerURL.substring(11);
        }
        else
        {
            host = brokerURL;
        }

        
        try {
            // IPV6 
            // Instead of writing our own code that can parse both IPV4 and IPV6
            // host names (since the host name can be the IPV6 formatted ip address),
            // use the existing java.net.URL class to parse it for us.  The code above
            // stripped the protocol off, so prepend the host name with "http://" so the
            // URL class can use its default URL handlers and we don't have to worry 
            // about writing and registering our own.  Since we don't want to actually
            // do the URL.openConnection(), and we already have the correct protocol
            // all we want the URL ctor to do is parse the host and port number for us.
            java.net.URL url = new java.net.URL("http://" + host);
            m_brokerHostName = url.getHost();
            m_brokerPort = url.getPort();
            
            if ((m_brokerHostName == null || m_brokerHostName.length() == 0) && !m_allowsEmptyHostname)
            {
                throw new MalformedURLException("Missing hostname");
            }

            // port defaults to 2506 if unset
            if (m_brokerPort == -1)
            {
                m_brokerPort = PORT_DEFAULT;
            }

        } catch (MalformedURLException e){
            MalformedURLException ex = new MalformedURLException(host + " (broker url: " + brokerURL + ")");
            ex.initCause(e);
            throw ex;
        }
        return;
    }
}
