package com.sonicsw.mf.common.url;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import com.sonicsw.mf.common.IDirectoryAdminService;

public class SonicRNStreamHandler extends URLStreamHandler 
{  
    private IDirectoryAdminService m_ds;
    private boolean m_local = true;
	
	public SonicRNStreamHandler(IDirectoryAdminService ds, boolean local)
	{
	    m_ds = ds;
	    m_local = true;
	}	
	
	@Override
    protected URLConnection openConnection(URL url)
    throws IOException
    {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection
    {
        private Connection(URL url)
        {
            super(url);
        }

        @Override
        public void connect() throws IOException { }
        
        @Override
        public Object getContent() throws IOException
        {
        	try
        	{
                SonicRNURL sonicrnURL = new SonicRNURL(super.url);
                return m_local ? sonicrnURL.resolveURL(m_ds) : "";
        	}
        	catch (Exception dirE)
        	{
        	    IOException ioE = new IOException("Unable to resolve " + url);
        	    ioE.initCause(dirE);
        		throw ioE;
        	}
        }

        @Override
        public String getContentType()
        {
            return "application/octet-stream";
        }
        
        // override the default of URLConnection to use the cached jar files. The class
        // sun.net.www.protocol.jar.JarFileFactory keeps a cache of jar files which gets
        // used from under the URLClassLoaders if the connections don't turn caching off.
        @Override
        public boolean getUseCaches()
        {
            return false;
        }
    }
    
    // In a jvm, once one instance of this handler is created by URL.getURLStreamHandler, 
    // it seems the instance is cached and we cannot replace it from the factory. Because SDM
    // open and closes containerless instances of the DS in one jvm while creating the
    // domain manager during a cleanDomain, we must refresh the instance of the DS that
    // the handler is using, or we get "The Directory Service is closed" exception
    public void setDirectoryService(IDirectoryAdminService ds)
    {
        m_ds = ds;
    }

}
