package com.sonicsw.mf.common.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.ILogger;

public class MFLogger
{
    private Logger m_logger;
    
    public MFLogger(IComponentContext context, String loggerName)
    {
        // Create Logger
        m_logger = Logger.getLogger(loggerName);
        m_logger.setLevel(Level.FINEST);
        m_logger.setUseParentHandlers(false); // prevent from writing to e.g. default console logger
        
        Handler mfLogHandler = new MFLogHandler(context);
        m_logger.addHandler(mfLogHandler);
    }
    
    public MFLogger(ILogger logger, String loggerName)
    {
        // Create Logger
        m_logger = Logger.getLogger(loggerName);

        m_logger.setLevel(Level.FINEST);
        m_logger.setUseParentHandlers(false); // prevent from writing to e.g. default console logger
        
        Handler mfLogHandler = new MFLogHandler(logger);
        m_logger.addHandler(mfLogHandler);
    }
    
    private static class MFLogHandler extends Handler
    {
        IComponentContext context;
        ILogger logger;
        
        private MFLogHandler(IComponentContext context)
        {
            this.context = context;
        }
        
        private MFLogHandler(ILogger logger)
        {
            this.logger = logger;
        }

        @Override
        public void publish(LogRecord record)
        {
            int severity = getSeverity(record.getLevel());
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            
            if (throwable != null)
            {
                if (message == null || message.length() == 0)
                {
                    if (logger == null)
                    {
                        context.logMessage(throwable, severity);
                    }
                    else
                    {
                        logger.logMessage("", throwable, severity);
                    }
                }
                else
                {
                    if (logger == null)
                    {
                        context.logMessage(message, throwable, severity);
                    }
                    else
                    {
                        logger.logMessage(message, throwable, severity);
                    }
                }
            }
            else
            {
                if (logger == null)
                {
                    context.logMessage(message, severity);
                }
                else
                {
                    logger.logMessage(message, severity);
                }
            }
        }

        private int getSeverity(Level level)
        {
            if (level == Level.CONFIG)
            {
                return com.sonicsw.mf.common.runtime.Level.CONFIG;
            }
            if (level == Level.INFO)
            {
                return com.sonicsw.mf.common.runtime.Level.INFO;
            }
            if (level == Level.WARNING)
            {
                return com.sonicsw.mf.common.runtime.Level.WARNING;
            }
            if (level == Level.SEVERE)
            {
                return com.sonicsw.mf.common.runtime.Level.SEVERE;
            }
            return com.sonicsw.mf.common.runtime.Level.TRACE;
        }

        @Override
        public void flush() { }
        @Override
        public void close() throws SecurityException { }
    }
}