package com.sonicsw.mf.common.util;

import java.util.ArrayList;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.mgmtapi.config.constants.IDirectoryServiceConstants;


// Provides methods to store in the DS the list of Workbench monitored containers
public class MonitoredContainerList
{
    private static final String WORKBENCH_DIR = "/workbench";
    private static final String MONITORED_ELEMENT_PATH = WORKBENCH_DIR + "/" + "monitored_containers";
    private static final String CONTAINER_LIST_ATT = "CONTAINER_LIST";


    public static void setMonitoredContainerList(IDirectoryFileSystemService ds0, MonitoredContainer[] monitoredContainers) throws Exception
    {
    	IDirectoryAdminService ds = (IDirectoryAdminService)ds0;
    	 // take note of whether we are in an upgrade scenario
    	 boolean isUpgrade = false;
         String upgrade = System.getProperty("wb.upgrade");
         if (upgrade != null)
        {
            isUpgrade = (new Boolean(upgrade)).booleanValue();
        }
        if (isUpgrade)
        {
            ds.setElementReleaseVersion(MONITORED_ELEMENT_PATH, IDirectoryServiceConstants.DS_C_VERSION);
            // remove any MF containers that were not upgraded
            IDirElement monitored_list = ds.getElement(MONITORED_ELEMENT_PATH, true);
            if (monitored_list != null)// not sure this could ever happen, but check anyway
            {
                IAttributeSet listElementAtts = monitored_list.getAttributes();
                IAttributeList containersList = (IAttributeList)listElementAtts.getAttribute(CONTAINER_LIST_ATT);
                if (containersList != null)
                {
                    for (int position = containersList.getCount() - 1; position >= 0 ; position--)
                    {
                        IAttributeList container = (IAttributeList)containersList.getItem(position);
                        ArrayList containerItems = container.getItems();
                        Reference cRef = null;
                        if (containerItems.get(0) instanceof Reference)
                        {
                            cRef = (Reference)containerItems.get(0);
                        }
                        else
                        {
                            cRef = (Reference)containerItems.get(1);
                        }
                        // get the identity from the logical namespace. It will be
                        // in the logical form /Containers/XXXX
                        IElementIdentity mContainer = null;
                        try
                        {
                            mContainer = (IElementIdentity)ds0.getFSIdentity(cRef.getElementName());
                        }
                        catch (DirectoryServiceException dirE)
                        {
                            //There is a problem getting the element identity, for instance, the element doesn't exist
                                                       
                        }
                        if (mContainer == null || !mContainer.getReleaseVersion().equals(IDirectoryServiceConstants.DS_C_VERSION))
                        {
                            System.out.println("\tAddToDS: Removing container " + cRef.getElementName() + " from the monitored container list");
                            containersList.deleteAttributeItem(position);
                        }
                    }
                }
                ds.setElement(monitored_list.doneUpdate(), null);
            }
        }
         else
         {
             
             createWorkbenchDir(ds);
             ds.deleteElement(MONITORED_ELEMENT_PATH, null);

             IDirElement listElement =  ElementFactory.createElement(MONITORED_ELEMENT_PATH,
                                                                "monitored_list",
                                                                 IDirectoryServiceConstants.DS_C_VERSION);
             IAttributeSet listElementAtts = listElement.getAttributes();
             IAttributeList list = listElementAtts.createAttributeList(CONTAINER_LIST_ATT);
             for (int i = 0; i < monitoredContainers.length; i++)
             {
                 IAttributeList dsMonitoredContainer = list.addNewAttributeListItem();
                 dsMonitoredContainer.addReferenceItem(new Reference(monitoredContainers[i].getContainerLogicalPath()));
                 dsMonitoredContainer.addBooleanItem(new Boolean(monitoredContainers[i].isAutoLaunch()));
             }
             ds.setElement(listElement.doneUpdate(), null);
         }
    }

    public static MonitoredContainer[] getMonitoredContainerList(IDirectoryFileSystemService ds0) throws Exception
    {
         IDirectoryAdminService ds = (IDirectoryAdminService)ds0;
         createWorkbenchDir(ds); // Create WORKBENCH_DIR if doesn't exist yet
         IDirElement listElement = ds.getElement(MONITORED_ELEMENT_PATH, false);
         if (listElement == null)
        {
            return new MonitoredContainer[0];
        }
         IAttributeSet listElementAtts = listElement.getAttributes();
         IAttributeList list = (IAttributeList)listElementAtts.getAttribute(CONTAINER_LIST_ATT);
         ArrayList resultList = new ArrayList();
         for (int i = 0; i < list.getCount(); i++)
         {
             IAttributeList dsMonitoredContainer = (IAttributeList)list.getItem(i);
             Reference ref = (Reference)dsMonitoredContainer.getItem(0);
             boolean autoLaunch =  ((Boolean)dsMonitoredContainer.getItem(1)).booleanValue();
             resultList.add (new MonitoredContainer(ref.getElementName(), autoLaunch));
         }

         return (MonitoredContainer[])resultList.toArray(new MonitoredContainer[resultList.size()]);
    }

    static void createWorkbenchDir(IDirectoryAdminService ds) throws Exception 
    {
        try
        {
            ds.listAll(WORKBENCH_DIR);
        }
        catch (DirectoryDoesNotExistException e)
        {
            ds.createDirectory(WORKBENCH_DIR);
        }
    }
}
