package com.sonicsw.mf.common.util;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameHelper
{
    public static final Pattern DOMAIN_NAME_REGEX_PATTERN = Pattern.compile("[\\w _-]+");
    public static final Pattern CONTAINER_NAME_REGEX_PATTERN = Pattern.compile("[\\w @_-]+");
    public static final Pattern COMPONENT_NAME_REGEX_PATTERN = Pattern.compile("[\\w _-]+");

    public static boolean isMFComponentName(ObjectName target)
    {
        StringTokenizer jmxDomain = new StringTokenizer(target.getDomain(), ".");
        if (jmxDomain.countTokens() != 2)
        {
            return false;
        }
        
        String mfDomain = jmxDomain.nextToken();
        if (mfDomain.length() == 0 || !DOMAIN_NAME_REGEX_PATTERN.matcher(mfDomain).matches())
        {
            return false;
        }
        
        String mfContainer = jmxDomain.nextToken();
        if (mfContainer.length() == 0 || !CONTAINER_NAME_REGEX_PATTERN.matcher(mfContainer).matches())
        {
            return false;
        }
        
        String id = target.getKeyProperty("ID");
        if (id == null || id.length() == 0 || !COMPONENT_NAME_REGEX_PATTERN.matcher(id).matches())
        {
            return false;
        }
        
        return true;
    }
    
    public static String getMFNamespace(ObjectName objectName)
    {
        // TODO: JSR255 namepaces? .. may need to extract in another way?
        
        if (!isMFComponentName(objectName))
        {
            return null;
        }
        
        return objectName.getDomain();
    }
    
    public static String getMFDomainName(ObjectName objectName)
    {
        if (!isMFComponentName(objectName))
        {
            return null;
        }
        
        StringTokenizer jmxDomain = new StringTokenizer(objectName.getDomain(), ".");
        return jmxDomain.nextToken();
    }
    
    public static String getMFContainerName(ObjectName objectName)
    {
        if (!isMFComponentName(objectName))
        {
            return null;
        }
        
        StringTokenizer jmxDomain = new StringTokenizer(objectName.getDomain(), ".");
        jmxDomain.nextToken();
        return jmxDomain.nextToken();
    }
    
    public static String getMFComponentName(ObjectName objectName)
    {
        if (!isMFComponentName(objectName))
        {
            return null;
        }
        
        return objectName.getKeyProperty("ID");
    }
    
    public static ObjectName translateGlobalObjectName(ObjectName objectName, String containerName)
    {
        if (!isMFComponentName(objectName))
        {
            return objectName;
        }
        
        if (getMFContainerName(objectName).equals(containerName))
        {
            return objectName;
        }
        
        // so if we get to here we've made best attempt to establish that the JMX object name is for a global MF
        // component .. so make the substitution
        try
        {
            objectName = new ObjectName(getMFDomainName(objectName) + '.' + containerName + ':' + objectName.getCanonicalKeyPropertyListString());
        }
        catch (MalformedObjectNameException e)
        {
            e.printStackTrace();
        }

        return objectName;
    }
}
