/*
 * Copyright (c) 1999-2011 Progress Software Corporation. All Rights Reserved.
 */

package com.sonicsw.mf.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import com.sonicsw.mf.common.dirconfig.IDirElement;
/**
 * Utility to serialize and zip DS Elements.
 */
public class ZipUtils
{
    private static final int DEFAULT_BUFFER_SIZE = 128;

    public static byte[] asZippedBytes(IDirElement[] elements) throws IOException
    {
        /**
         * The figure of 128 was arrived from the ratio of processes, endpoints, services etc before and
         * after compression during dev tests.
         */
        int expectedElementSize = DEFAULT_BUFFER_SIZE;
        return asZippedBytes(elements, expectedElementSize * elements.length);
    }

    public static byte[] asZippedBytes(Serializable  object) throws IOException
    {
        return asZippedBytes(object, DEFAULT_BUFFER_SIZE);
    }

    /**
     *
     * @param object the Serializable object
     * @param buffersize  the initial size of the byte array created.
     * @return the serialized object, compressed using gzip
     * @throws java.io.IOException
     */
    public static byte[] asZippedBytes(Serializable  object, int buffersize) throws IOException
    {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(Math.max(DEFAULT_BUFFER_SIZE, buffersize));
        GZIPOutputStream zipStream = null;
        ObjectOutputStream objectStream =null;
        try
        {
            zipStream = new GZIPOutputStream(byteStream);
            objectStream = new ObjectOutputStream(zipStream);
            objectStream.writeObject(object);
            zipStream.flush();
            zipStream.finish();
            return byteStream.toByteArray();
        }
        finally
        {
            if (zipStream != null) zipStream.close();
        }
    }

    public static IDirElement[] fromZippedBytes(byte[] bytes) throws IOException, ClassNotFoundException
    {
        ObjectInputStream objectStream = null;
        IDirElement[] allElements = null;
        try
        {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            GZIPInputStream zipStream = new GZIPInputStream(byteStream);
            objectStream = new ObjectInputStream(zipStream);
            allElements = (IDirElement[]) objectStream.readObject();
            return allElements;
        }
        finally
        {
            if (objectStream != null) objectStream.close();
        }
    }

}
