/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.view;

/**
 * The IDeltaView interface contains the modifications that were applied to this view. The typical application
 * will use this IDeltaView object together with the new version of the view or the old version of the view (or both) to
 * figure out the modification details. Note that the renaming of view elements is expressed as deletion followed by creation -
 * the fact that renaming occurred is lost.
 */
public interface IDeltaView
{

   /**
    * Returns the name list of deleted elements (folders and links).
    *
    * @return the name list of deleted elements.
    */
    public String[] getDeleteElements();

   /**
    * Returns the name list of new elements (folders and links).
    *
    * @return the name list of new elements.
    */
    public String[] getNewElements();

   /**
    * Returns the name list of elements (folders and links) with modified attributes.
    *
    * @return the name list of elements with modified attributes.
    */
    public String[] getAttributeModifiedElements();

    
}


