/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.view;
import java.util.HashMap;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.ReadOnlyException;

/**
 * An IFolder object is a view element which contains sub folders and link elements
 */
public interface ILink extends IViewElement
{
 /**
  * Returns the name of the linked object
  *
  * @return the name of the linked object
  */
  public String getLinkedObjectName();

 /**
  * Returns true if marked as complex (interpreted by the DS as a link to an entire DS subtree)
  *
  * @return true if marked as complex
  */
  public boolean isComplex();

 /**
  * Marks this link as complex (interpreted by the DS as a link to an entire DS subtree)
  */
  public void setComplex() throws AttributeSetTypeException, ReadOnlyException, ConfigException;

 /**
  * Sets the meta attributes of a complex configuration link.
  *
  * @param attributes the complex link attributes
  */
  public void setComplexAttributes(HashMap attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException;

 /**
  * Returns the meta attributes of a complex configuration link.
  *
  * @return the meta attributes of a complex configuration link
  */
  public HashMap getComplexAttributes();

}

