/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.view;
import java.util.HashMap;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;

// This object encapsulates: The view, the StorageToLogical map and the the hints
public interface ILogicalNameSpace
{
    public final static String NO_STORAGE_LABEL = "/NO_STORAGE:";
    public final static String DELETED_LABEL = "DELETED:";

    public final static int DOES_NOT_EXIST_TYPE = 0;
    public final static int FOLDER_TYPE = 1;
    public final static int COMPLEX_FOLDER_TYPE = 2;
    public final static int ELEMENT_TYPE = 3;

    public static final String FOLDER_NAME = "_FOLDER_NAME";
    public static final String IS_COMPLEX = "_IS_COMPLEX";
    public static final String ELEMENT_IDENTITY = "_ELEMENT_IDENTITY";

    void createFolder(String path) throws DirectoryServiceException;

    // Returns the storage name of the created element
    // If the hint suggests that a complex configuration is needed and non
    // was created yet then create one.
    String createElement(String path, String elementType) throws DirectoryServiceException;

    String logicalFromStorage(String path) throws DirectoryServiceException;

    String storageFromLogical(String path) throws DirectoryServiceException;

    void deleteElement(String path) throws DirectoryServiceException;
    void deleteElement(String path, boolean elementUnderComplexConfig) throws DirectoryServiceException;
    void deleteFolder(String path) throws  DirectoryServiceException;

    void rename(String oldPath, String newPath) throws DirectoryServiceException;

    public void subscribe(INamingListener listener) throws DirectoryServiceException;

    public int getNameSpaceType(String path);

    public void unsubscribe();

    public String[] list(String folderPath) throws DirectoryServiceException;

    public void defineFolderMetaAttribute(String attributeName) throws DirectoryServiceException;

    public void defineElementMetaAttribute(String attributeName) throws DirectoryServiceException;

    public String[] getDefinedFolderMetaAttributes();

    public String[] getDefinedElementMetaAttributes();

    public void setMetaAttributes(String element, HashMap newAttributes) throws DirectoryServiceException;

    public HashMap getMetaAttributes(String elementName) throws DirectoryServiceException;

    public String folderToDirectory (String logical) throws DirectoryServiceException;
}
