/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.view;
import java.util.HashMap;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.ReadOnlyException;


/**
 * Each view element has a flat set of attributes implemented by this interface.
 */
public interface IViewElementAttributes
{
 /**
  * Returns the value of this attribute.
  *
  * @param attributeName the name of the attribute
  *
  * @return the attribute's value
  *
  */
  public String getAttribute(String attributeName);

 /**
  * Sets a new String value for the given attribute
  *
  * @param attributeName the name of the attribute
  * @param value the new String value of the attribute
  *
  * @exception AttributeSetTypeException if the attribute name is not defined in this attribute set type
  * @exception ReadOnlyException if the set belongs to a read-only view element
  * @exception ConfigException if the attribute name is illegal (such as a null name)
  *
  */
  public void setAttribute(String attributeName, String value) throws ReadOnlyException, AttributeSetTypeException, ConfigException;

 /**
  * Resets attribute value to empty string 
  *
  * @param attributeName the name of the attribute
  *
  * @exception ConfigException if the attribute name is illegal (such as a null name)
  *
  */
  public void resetAttributeValue(String attributeName) throws ConfigException;

 /**
  * Returns references to all the {attribute,value} pairs in a HashMap object
  *
  * @return all the items in the set
  *
  */
  public HashMap getAttributes();
}
