package com.sonicsw.mf.common.view.impl;

import java.util.ArrayList;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.ViewException;

public final class DeltaView implements IDeltaView, java.io.Serializable
{
    private static final long serialVersionUID = 0L;
    private IBasicElement m_viewElement;

    private transient ArrayList m_deletedList;
    private transient ArrayList m_newList;
    private transient ArrayList m_modifiedAttributesList;


    public DeltaView(IBasicElement viewElement)
    {
        if (viewElement == null ||
           !viewElement.getIdentity().getName().equals(ViewConstants.VIEW_ELEMENT) ||
           !(viewElement instanceof IDeltaElement))
        {
            throw new IllegalStateException(ViewConstants.VIEW_ELEMENT + " delta element must be passed to the DeltaView constructor.");
        }
        this.m_viewElement =  viewElement;
    }

    public IBasicElement getElement()
    {
        return m_viewElement;
    }

    private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException
    {
       s.writeInt(ViewConstants.VERSION);
       s.writeObject(m_viewElement);
    }

    private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException, ViewException
    {
       int version = s.readInt();
       if (version != ViewConstants.VERSION)
     {
        throw new ViewException("Serialization version mismatch. Serialized object version: " + version +
                                     " class version: " + ViewConstants.VERSION); //Version mismatch error
    }
       m_viewElement = (IBasicElement)s.readObject();
    }

    @Override
    public String[] getDeleteElements()
    {
        if (m_deletedList == null)
        {
            analyzeDelta();
        }
        String[] result = new String[m_deletedList.size()];
        m_deletedList.toArray(result);
        return result;
    }

    @Override
    public String[] getNewElements()
    {
        if (m_deletedList == null)
        {
            analyzeDelta();
        }
        String[] result = new String[m_newList.size()];
        m_newList.toArray(result);
        return result;

    }

    @Override
    public String[] getAttributeModifiedElements()
    {
        if (m_deletedList == null)
        {
            analyzeDelta();
        }
        String[] result = new String[m_modifiedAttributesList.size()];
        m_modifiedAttributesList.toArray(result);
        return result;
    }

    private void analyzeDelta()
    {
        m_deletedList = new ArrayList();
        m_newList = new ArrayList();
        m_modifiedAttributesList = new ArrayList();

        IDeltaAttributeSet deltaAttributes = (IDeltaAttributeSet)((IDeltaElement)m_viewElement).getDeltaAttributes();
        Object modifiedRootFolder = null;
        try
        {
            modifiedRootFolder = deltaAttributes.getNewValue(ViewConstants.ROOT_FOLDER);
        }
        catch (NotModifiedAttException e)
        {
        }

        if (modifiedRootFolder == null)
        {
            return;
        }
        else if (modifiedRootFolder instanceof IAttributeSet)
        {
            m_newList.add("" + IMFDirectories.MF_DIR_SEPARATOR);
        }
        else
        {
            handleModifiedDelta("", (IDeltaAttributeSet)modifiedRootFolder);
        }

    }

    private void handleModifiedDelta(String pathName, IDeltaAttributeSet delta)
    {
        String[] deletedNames = delta.getDeletedAttributesNames();
        String[] newNames = delta.getNewAttributesNames();
        String[] modifiedNames = delta.getModifiedAttributesNames();

        for (int i = 0; i < deletedNames.length; i++)
        {
            m_deletedList.add(pathName + IMFDirectories.MF_DIR_SEPARATOR + deletedNames[i]);
        }

        for (int i = 0; i < newNames.length; i++)
        {
            m_newList.add(pathName + IMFDirectories.MF_DIR_SEPARATOR + newNames[i]);
        }

        for (int i = 0; i < modifiedNames.length; i++)
        {
             String childName = modifiedNames[i];
             String childPath = pathName + IMFDirectories.MF_DIR_SEPARATOR + childName;

             Object modifiedValue = null;
             try
             {
                 modifiedValue = delta.getNewValue(childName);
             }
             catch (NotModifiedAttException e)
             {
                  e.printStackTrace();
                  throw new IllegalStateException(e.toString());
             }

             if (childName.equals(ViewConstants.ATTRS_VALUES))
            {
                m_modifiedAttributesList.add((pathName.length() == 0) ? "" + IMFDirectories.MF_DIR_SEPARATOR : pathName);
            }
            else if (modifiedValue instanceof IDeltaAttributeSet)
            {
                handleModifiedDelta(childPath, (IDeltaAttributeSet)modifiedValue);
            }
            else if (modifiedValue instanceof IAttributeSet) // The attribute set was deleted and then recreated
             {
                 m_newList.add(childPath);
                 m_deletedList.add(childPath);
             }
            else
            {
                throw new IllegalStateException("Unrecognized modification in attribute \"" + childPath + "\".");
            }
        }
    }




} //end of class
