package com.sonicsw.mf.common.view.impl;

import java.util.HashMap;
import java.util.Iterator;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.IViewElementAttributes;


public class Link implements ILink
{
  private IAttributeSet m_attrSet = null;
  private IAttributeSetType m_attrLinkType = null;
  private String m_linkedObjectName = null;
  private ViewElementAttributes m_attributes = null;
  private String m_name = null;

  Link(IAttributeSet parent, IAttributeSetType attrSetType, String name, String linkedObjectName, boolean complex)
  throws AttributeSetTypeException, ReadOnlyException, ConfigException
  {
    m_name = name;
    m_attrSet = (IAttributeSet)parent.getAttribute(name.toLowerCase());
    if ((m_attrSet == null) && (System.getProperty("MQ_UPGRADE", "false").equals("true")))
    {
        m_attrSet = (IAttributeSet)parent.getAttribute(name);
    }
    if(m_attrSet == null)
    {
        m_attrSet = parent.createAttributeSet(name.toLowerCase());
        m_attrSet.createAttributeList(ViewConstants.ATTRS_VALUES);
        m_attrSet.setStringAttribute(ViewConstants.ATTR_LINKOBJECT, linkedObjectName);
        m_attrSet.setIntegerAttribute(ViewConstants.TYPE_ATTR, ViewConstants.LINK_TYPE);
        m_attrSet.setStringAttribute(ViewConstants.ORIGINAL_NAME, name);
        if (complex)
        {
            m_attrSet.setBooleanAttribute(ViewConstants.ATTR_COMPLEX_LINK, Boolean.TRUE);
        }
    }
    m_attrLinkType = attrSetType;
    m_linkedObjectName = linkedObjectName;
    setAttributes();
  }
  ////**Implementation of ILink
  /////////////////////////////////////

    /**
  * Returns the name of the linked object
  *
  * @return the name of the linked object
  */
  @Override
public String getLinkedObjectName()
  {
    return (String)m_attrSet.getAttribute(ViewConstants.ATTR_LINKOBJECT);
  }


  @Override
public void setComplex() throws AttributeSetTypeException, ReadOnlyException, ConfigException
  {
      m_attrSet.setBooleanAttribute(ViewConstants.ATTR_COMPLEX_LINK, Boolean.TRUE);
  }

  @Override
public void setComplexAttributes(HashMap attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException
  {
      IAttributeSet attSet = m_attrSet.createAttributeSet(ViewConstants.ATTR_COMPLEX_ATTRIBUTES);
      Iterator attIterator = attributes.keySet().iterator();
      while (attIterator.hasNext())
      {
          String key = (String)attIterator.next();
          Object valObject = attributes.get(key);
          if (!(valObject instanceof java.lang.String))
        {
            throw new AttributeSetTypeException("Meta attributes must be of type java.lang.String.");
        }
          String value = (String)valObject;
          attSet.setStringAttribute(key, value);
      }
  }

  @Override
public HashMap getComplexAttributes()
  {
      IAttributeSet set = (IAttributeSet)m_attrSet.getAttribute(ViewConstants.ATTR_COMPLEX_ATTRIBUTES);
      if (set == null)
    {
        return new HashMap();
    }
    else
    {
        return set.getAttributes();
    }
  }


  @Override
public boolean isComplex()
  {
      Boolean complex = (Boolean)m_attrSet.getAttribute(ViewConstants.ATTR_COMPLEX_LINK);
      if (complex != null && complex.booleanValue())
    {
        return true;
    }
    else
    {
        return false;
    }
  }

  ///**Implementation of IViewElement
  /////////////////////////////////////


 /**
  * Returns this element's attributes
  *
  * @return this element's attributes
  *
  */
  @Override
public IViewElementAttributes getAttributes()
  {
    return m_attributes;
  }

  @Override
public String getName()
  {
    return m_name;
  }
  //*** Helper methods ***
  ////////////////////////

  //Set Attributes for this Link
  private void setAttributes()
  {
    m_attributes = new ViewElementAttributes();
    m_attributes.setAttributeNamesList(m_attrLinkType.getAttributeNames());
    m_attributes.setAttributeValuesList((IAttributeList)m_attrSet.getAttribute(ViewConstants.ATTRS_VALUES));
  }
}//end of class

