package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.ILogicalNameSpace;


public class NameReplacer implements com.sonicsw.mf.common.config.impl.IReplaceRef
{
    private boolean m_fromLogical;
    ILogicalNameSpace m_nameSpace;

    NameReplacer(boolean fromLogical, ILogicalNameSpace nameSpace)
    {
        m_fromLogical = fromLogical;
        m_nameSpace = nameSpace;
    }

    @Override
    public Reference replace(Reference ref)
    {
        String replacedValue = null;
        try
        {
            if (m_fromLogical)
            {
                replacedValue = m_nameSpace.storageFromLogical(ref.getElementName());
            }
            else
            {
                String storageName = ref.getElementName();
                if (!storageName.startsWith(ILogicalNameSpace.NO_STORAGE_LABEL))
                {
                    replacedValue = m_nameSpace.logicalFromStorage(storageName);
                }
            }
        }
        catch (Exception e) {} 

        if (replacedValue == null)
        {
            if (m_fromLogical)
            {
                replacedValue = ILogicalNameSpace.NO_STORAGE_LABEL + ref.getElementName();
            }
            else
            {
                if (ref.getElementName().startsWith(ILogicalNameSpace.NO_STORAGE_LABEL))
                {
                    replacedValue = ref.getElementName();
                }
                else
                {
                    replacedValue = ILogicalNameSpace.DELETED_LABEL + ref.getElementName();
                }
            }
        }

        return new Reference(replacedValue);
    }

    @Override
    public String replace(String name) throws VersionOutofSyncException
    {
        try
        {
           String newName = null;
           if (m_fromLogical)
        {
            newName = m_nameSpace.storageFromLogical(name);
        }
        else
        {
            newName = m_nameSpace.logicalFromStorage(name);
        }

           if (newName == null)
        {
            throw new VersionOutofSyncException("Could not translate " + name);
        }
           return newName;
        }
        catch (Exception e)
        {
            throw new VersionOutofSyncException(e.getMessage());
        }
    }

}
