package com.sonicsw.mf.common.view.impl;

import java.util.ArrayList;

import com.sonicsw.mx.util.IEmptyArray;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ReadOnlyException;

final class ViewAttributesList implements IAttributeSetType
{
    IAttributeSet m_topAttributeList = null;
    String m_type = null;

   ViewAttributesList(IAttributeSet top, String nameType )
   {
        try{
            IAttributeList attrsList = (IAttributeList)top.getAttribute(nameType);
            if(attrsList == null) //first time
            {
              top.createAttributeList(nameType); //empty list
            }
            m_type = nameType;
            m_topAttributeList = top;
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
   }

    /**
  * Adds a new attribute name to the list of attributes.
  *
  * @param name the name of the new attribute
  *
  * @exception ReadOnlyException if an IAttributeSet object of this type was already created
  *
  */
  @Override
public void addAttributeName(String name) throws ReadOnlyException
  {
        if(isReadOnly())
        {
            throw new ReadOnlyException();
        }
        IAttributeList m_attrsList = (IAttributeList)m_topAttributeList.getAttribute(m_type);
        m_attrsList.addStringItem(name);
  }

 /**
  * Returns a list of all the attribute names defined for this IAttributeSetType object
  *
  * @return the list of attributes added through the addAttributeName method
  *
  */
  @Override
public String[] getAttributeNames()
  {
     IAttributeList m_attrsList = (IAttributeList)m_topAttributeList.getAttribute(m_type);
     ArrayList list = m_attrsList.getItems();
     int count = m_attrsList.getCount();
     if(count == 0)
    {
        return IEmptyArray.EMPTY_STRING_ARRAY;
    }
     ArrayList listOfNames = new ArrayList();

     for(int i = 0; i < count; i++)
     {
        if(list.get(i) instanceof String)//laminate Boolean Item
        {
            listOfNames.add(i, (String)list.get(i));
        }
     }
     return (String [])listOfNames.toArray(new String[listOfNames.size()]);
  }

  private boolean isReadOnly() throws ReadOnlyException//Boolean Item added to both lists on getRootFolder() call
  {
    IAttributeList m_attrsList = (IAttributeList)m_topAttributeList.getAttribute(m_type);
    int count = m_attrsList.getCount();
    if(count == 0)
    {
        return false;
    }
    if(m_attrsList.getItem(count -1) instanceof Boolean){
        m_attrsList.setNewBooleanItem(count - 1, new Boolean(true)); //always reset to true
        return true;
    }
    return false;
  }
  /*
  static void setReadOnly(boolean readOnly)
  {
     m_readOnly = readOnly;

  }
  */
  private int getPosition(String attributeName)
  {
    int pos = -1;
    IAttributeList m_attrsList = (IAttributeList)m_topAttributeList.getAttribute(m_type);
    ArrayList list = m_attrsList.getItems();
    for(int i=0; i < list.size(); i++)
    {
       if(attributeName.compareTo((String)list.get(i)) == 0)
    {
        pos=i;
    }
    }
    return pos;
  }

}//end of class
