package com.sonicsw.mf.common.view.impl;

import java.util.HashMap;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.view.IViewElementAttributes;

public class ViewElementAttributes implements IViewElementAttributes
{
  private String[] m_attrNames = null;
  private HashMap m_attributes = null; 
  private IAttributeList m_attrValues = null;
  
  ViewElementAttributes()
  {
    m_attributes = new HashMap();
  }
  
  /**
  * Returns the value of this attribute.
  *
  * @param attributeName the name of the attribute
  *
  * @return the attribute's value
  *
  */
  @Override
public String getAttribute(String attributeName)
  {
    return (String)m_attributes.get(attributeName);
  }

 /**
  * Sets a new String value for the given attribute
  *
  * @param attributeName the name of the attribute
  * @param value the new String value of the attribute
  *
  * @exception AttributeSetTypeException if the attribute name is not defined in this attribute set type
  * @exception ReadOnlyException if the set belongs to a read-only view element
  * @exception ConfigException if the attribute name is illegal (such as a null name)
  *
  */
  @Override
public void setAttribute(String attributeName, String value) throws ReadOnlyException, AttributeSetTypeException, ConfigException
  {
     int position = getPosition(attributeName);
     if(position == -1)
     {
        throw new AttributeSetTypeException("Attribute name is not defined");
     }
     m_attributes.put(attributeName, value);
     m_attrValues.setNewStringItem(position, value);
  }

 /**
  * Deletes a {attribute,value} pair. It is equivalent to setting the attribute to null.
  *
  * @param attributeName the name of the attribute
  *
  * @exception ReadOnlyException if the set belongs to a read-only view element
  * @exception ConfigException if the attribute name is illegal (such as a null name)
  *
  */
  @Override
public void resetAttributeValue(String attributeName) throws ConfigException
  {
     int position = getPosition(attributeName);
     if(position == -1)
    {
        throw new ConfigException("Attribute name is not defined");
    }
     m_attributes.put(attributeName, ""); 
     m_attrValues.setNewStringItem(position, "");
  }

 /**
  * Returns references to all the {attribute,value} pairs in a HashMap object
  *
  * @return all the items in the set
  *
  */
  @Override
public HashMap getAttributes()
  {
    return m_attributes;
  }
    
  //*** Helper functions
  /////////////////////////
  
  void setAttributeNamesList(String[] listNames)
  {
    m_attrNames = listNames;
  }
  
  void setAttributeValuesList(IAttributeList listValues)
  {
    m_attrValues = listValues;
    if(m_attrValues.getCount() == 0)
    {
        createEmptyListItems();
    }
    for(int i = 0; i < m_attrNames.length; i++)
    {
        m_attributes.put(m_attrNames[i], (String)m_attrValues.getItem(i));
    }
  }
  
  private int getPosition(String attributeName)
  {
    int pos = -1;
    for(int i=0; i < m_attrNames.length; i++)
    {
       if(attributeName.compareTo(m_attrNames[i]) == 0)
       {
          pos=i;
          break;
       }
    }
    return pos;
  }
  
  //Creates number of StringItems equal to m_attrNames.size()in AttributeList object(mapped to attribute values list)
  //where stored string object is empty string.
  //It will prevent IndexOutOfBoundsException, when we try to set attribute value.
  private void createEmptyListItems() 
  {
    try{
        for(int i = 0; i < m_attrNames.length; i++)
        {
            m_attrValues.addStringItem("");
        }
    }
    catch(ReadOnlyException ex){} //should not happen
  }
  
}//end of class
