/* CopyrightVersion 1.0
 *                                                                          
 * Change Log:
 *    Last Modified By: $Author: Irene $
 *    Last Modified On: $Date: 05/09/01 4:59p $
 */

package com.sonicsw.mf.common.xml;

    
/**
    Helper class used to encode bytes array into string on XML export ,
    and decode back to the bytes on XML import.
    The resulted string(for export) will be placed into attribute value
    of Attribute element, which is composed of the characters in the
*   ['A'..'P'] set. Each character corresponds to low/high 4 bits of a byte.
*/
    
public class ByteStringConverter{
    
    private final static char MIN_HEX_CHAR = 'A';
    private final static char MAX_HEX_CHAR = 'P';
   
    private final static int HEX_MASK = 0x0000000f; // mask is 00001111 in binary.
 
   
    /**
    * Returns an encoded string that represents the byte array of parameter
    * values for the method to be invoked.
    * @return  The encoded string that represents the byte array of parameter
    *          values for the method to be invoked. If there are no parameters,
    *          then an empty string is returned.
    */
   public static final String getStringFromBytes(byte[] bytes)
   {     
      int length = ((byte[])bytes).length;  
      if (length == 0)
    {
        return "";
    }

      // Number of characters is double the bytes array length because two
      // characters must be generated for each byte.
      int charsLength = length << 1;
      char[] chars = new char[charsLength];

      int byteIndex = 0;
      int charIndex = 0;

      do {
         byte b = bytes[byteIndex++];
         int lowFour = b & HEX_MASK;
         int hiFour = (b >> 4) & HEX_MASK;
         char loChar = (char)('A' + lowFour);
         char hiChar = (char)('A' + hiFour);

         chars[charIndex++] = hiChar;
         chars[charIndex++] = loChar;
      } while (byteIndex < length);

      return new String(chars);
   }
   
    /**
    * Returns an array of bytes decoded from the encodedStringargument.
    * 
    * @param   encodedString  string that will be decoded to generated the array
    *                         of bytes.
    * @return  The array of bytes generated by decoding the given
    *          encodedString argument. Returns null if string length is zero.     
    */
    
    public static final byte[] getBytesFromString(String encodedString)
    {
        int length = encodedString.length();
        if(length == 0)
        {
            return new byte[0];
        }
             
        char[] chars = encodedString.toCharArray();

        // Number of bytes will be half of the string length since a byte is
        // generated for every two characters.
        int bytesLength = chars.length >>> 1;
        byte[] bytes = new byte[bytesLength];

        int charIndex = 0;
        int byteIndex = 0;
        do {
            char hiChar = chars[charIndex++];
            char loChar = chars[charIndex++];
            int hiFour = hiChar - 'A';
            int loFour = loChar - 'A';
            bytes[byteIndex++] = (byte)((hiFour << 4) + loFour);
        } while (charIndex < chars.length);

        return bytes;
    }
    
    //Unit Test **
    /****************
    private static void main(String[] argv)
    {
        boolean booleanValue = true;
        byte byteValue = 123;
        char charValue = 'A';
        short shortValue = 12345;
        int intValue = 98765432;
        long longValue = 123456789123456L;
        float floatValue = 98.7654F;
        double doubleValue = 0.12345678901234;
        String stringValue = "Testing string";
        Object objectValue = new IOException();
        byte[] bytesData = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeBoolean(booleanValue);
            objectOutputStream.writeByte(byteValue);
            objectOutputStream.writeChar(charValue);
            objectOutputStream.writeShort(shortValue);
            objectOutputStream.writeInt(intValue);
            objectOutputStream.writeLong(longValue);
            objectOutputStream.writeFloat(floatValue);
            objectOutputStream.writeDouble(doubleValue);
            objectOutputStream.writeObject(stringValue);
            objectOutputStream.writeObject(objectValue);
            bytesData = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            //can be ignored
        }
        
        String encodedString = ByteStringConverter.getStringFromBytes(bytesData);
        
        byte[] bytesData1 = ByteStringConverter.getBytesFromString(encodedString);
        
        ByteArrayInputStream byteArray = new ByteArrayInputStream(bytesData1);
        try {
            objectInputStream = new ObjectInputStream(byteArray);
            boolean booleanValue1 = objectInputStream.readBoolean();
            if(booleanValue1 == booleanValue)
                System.out.println("BOOLEAN: " + booleanValue1); 
            byte byteValue1 = objectInputStream.readByte();
            if(byteValue1 == byteValue)
                System.out.println("BYTE: " + byteValue1); 
            char charValue1 = objectInputStream.readChar();
            if(charValue1 == charValue)
                System.out.println("CHAR: " + charValue1); 
            short shortValue1 = objectInputStream.readShort();
            if(shortValue1 == shortValue)
                System.out.println("SHORT: " + shortValue);
            int intValue1 = objectInputStream.readInt();
            if(intValue1 == intValue)
                System.out.println("INT: " + intValue1);
            long longValue1 = objectInputStream.readLong();
            if(longValue1 == longValue)
                System.out.println("LONG: " + longValue1);
            float floatValue1 = objectInputStream.readFloat();
            if(floatValue1 == floatValue)
                System.out.println("FLOAT: " + floatValue1);
            double doubleValue1 = objectInputStream.readDouble();
            if(doubleValue1 == doubleValue)
                System.out.println("DOUBLE: " + doubleValue1);
            String stringValue1 = (String)objectInputStream.readObject();
            if(stringValue1.equalsIgnoreCase(stringValue))
                System.out.println("STRING: " + stringValue1);
            Object objectValue1 = objectInputStream.readObject();
            System.out.println(objectValue);
            System.out.println(objectValue1);
         }
         catch (Exception e) {
            //throws: java.io.StreamCorruptedException
            //         java.io.IOException
         }

    }
    */
 }
