package com.sonicsw.mf.common.xml;

import java.util.HashMap;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class ElementListBuilder
{
	private IDirElement[] m_elements;
	XMLStringWriter m_xmlWriter = null;
	IDirectoryAdminService m_dirService;
	
	public ElementListBuilder(IDirElement[] elements)
	{
		m_elements = elements;
		m_xmlWriter = new XMLStringWriter();		
	}
	
	public void setDirectoryService(IDirectoryAdminService dirService)
    {
        m_dirService = dirService;
    }
	
	public void init() throws DirectoryServiceException
    {
        if(m_dirService == null)
        {
            return;
        }

        m_xmlWriter.setProcInstruction(XMLConstants.DEFAULT_XML_VERSION, XMLConstants.DEFAULT_XML_ENCODE);
        createDomainElement();
    }
	
	private void createDomainElement() throws DirectoryServiceException
    {
        HashMap attrPair = new HashMap();
        attrPair.put(XMLConstants.XMLNS_ATTR, XMLConstants.XMLNS_TARGET);
        attrPair.put(XMLConstants.XSI_ATTR, XMLConstants.XSI_TARGET);
        attrPair.put(XMLConstants.SCHEMALOCATION_ATTR, XMLConstants.XMLNS_TARGET + " " + XMLConstants.XSD_FILE);
        attrPair.put(XMLConstants.NAME_ATTR, m_dirService.getDomain());
        m_xmlWriter.startElement(XMLConstants.DOMAIN_ELEMENTNAME, attrPair, false);
        processElements();
        m_xmlWriter.endElement(XMLConstants.DOMAIN_ELEMENTNAME);
    }
	
	private void processElements() throws DirectoryServiceException
    {       
        if(m_elements != null && m_elements.length > 0)
        {
        	for (int i=0; i<m_elements.length; i++)
        	{
        		IDirElement el = m_elements[i];
        		ElementBuilder builder = new ElementBuilder(el, m_xmlWriter);
                builder.setDirectoryService(m_dirService);
                builder.init();
        	}
        }        
    }
	
	public String getXMLString()
    {
        return m_xmlWriter.getXMLString().toString();
    }
}
