/* CopyrightVersion 1.0
 *
 * Change Log:
 *    Last Modified By: $Author: Irene $
 *    Last Modified On: $Date: 03/25/02 12:08p $
 */

package com.sonicsw.mf.common.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;

/**
 * Validates XML data against specified xsd. Can be used with any JAXP compliant SAXParser.
 * 
 */

public class Validator
{
    XMLReader m_saxReader = null;

    SAXParserFactory m_factory = null;

    XMLDocumentHandler m_saxEventHandler = null;

    IDirectoryAdminService m_dirService = null;

    ErrorHandlerImpl errHandler = null;

    Object xmlData = null;

    HashMap m_features = new HashMap(0);

    boolean m_keepElements = false;

    public Validator(Object xmlData)
    {
        try
        {
            this.xmlData = xmlData;

            m_factory = SAXParserFactory.newInstance();
            m_factory.setFeature("http://xml.org/sax/features/namespaces", true); // always must be set
        }
        catch (Exception pce)
        {
            pce.printStackTrace(); // shoudn't happen
        }
    }

    private void setDefaultFeatures()
    throws SAXException
    {
        m_saxReader.setFeature("http://xml.org/sax/features/validation", false);
    }

    private void setSpecifiedFeatures()
    throws SAXException
    {
        String fileURL = System.getProperty("sonicsw.mf.parserProps");
        if (fileURL == null)
        {
            return;
        }
        try
        {
            File f = new File(fileURL);
            if (f.exists())
            {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                for (Enumeration e = props.propertyNames(); e.hasMoreElements();)
                {
                    String key = (String)e.nextElement();
                    String value = props.getProperty(key);
                    if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))
                    {
                        // parser features use
                                                                                            // boolean flag
                        m_saxReader.setFeature(key, (new Boolean(value)).booleanValue());
                    }
                    else
                    // xml parser generic properties only
                    {
                        m_saxReader.setProperty(key, value);
                    }
                }
            }
        }
        catch (Exception ex)
        {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    public void setKeepElements(boolean keep)
    {
        m_keepElements = keep;
    }

    public void resetXMLData(Object data)
    {
        this.xmlData = data;
    }

    public void setDirectoryService(IDirectoryAdminService dirService)
    {
        this.m_dirService = dirService;
    }

    public void createSAXParser()
    {
        try
        {
            SAXParser parser = m_factory.newSAXParser();
            ErrorHandlerImpl errHandler = new ErrorHandlerImpl();
            m_saxReader = parser.getXMLReader();
            m_saxReader.setErrorHandler(errHandler);

        }
        catch (SAXException se)
        {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce)
        {
            pce.printStackTrace();
        }

    }

    public void setContentHandler(String domainName)
    {
        m_saxEventHandler = new XMLDocumentHandler();
        m_saxEventHandler.setKeepElements(m_keepElements);
        m_saxReader.setContentHandler(m_saxEventHandler);
        try
        {
            m_saxReader.setProperty("http://xml.org/sax/properties/lexical-handler", m_saxEventHandler);
        }
        catch (SAXException ex)
        {
            if (ex instanceof SAXNotRecognizedException)
            {
                ex.printStackTrace();
            } 
        }
        m_saxEventHandler.setDirectoryService(m_dirService);
        m_saxEventHandler.setDomainName(domainName);
    }

    public XMLDocumentHandler getContentHandler()
    {
        return m_saxEventHandler;
    }

    // We don't validate anymore - see Sonic00028792 - therefore the validate flag is unused
    public void setValidation(boolean validateUnused)
    {
        try
        {
            setDefaultFeatures();
            setSpecifiedFeatures();
        }
        catch (SAXException ex)
        {
            //Ignore
        }

    }

    public void parseData()
    throws DirectoryServiceException, InvalidXMLException // throws Exception
    {
        try
        {

            if (xmlData instanceof String)
            {
                m_saxReader.parse((String)xmlData);
            }
            else
            // character stream
            {
                InputSource is = new InputSource((Reader)xmlData);
                m_saxReader.parse(is);
                ((Reader)xmlData).close(); // flush it out
            }
        }
        catch (SAXException ex)
        {
            String errorMsg = getErrorLocationString(ex) + ":" + ex.getMessage();
            throw new InvalidXMLException(errorMsg, ex);
        }
        catch (IOException io_ex)
        {
            throw new InvalidXMLException(io_ex.getMessage(), io_ex);
        }
    }

    /**
     * Returns a string of the error location(SAXParseException) in xml file. Location reported in the following format: <<line
     * number>:<column number>>
     */
    private String getErrorLocationString(SAXException ex)
    {
        String retValue = "";
        if (ex instanceof SAXParseException)
        {
            StringBuffer str = new StringBuffer();
            String systemId = ((SAXParseException)ex).getSystemId();
            if (systemId != null)
            {
                int index = systemId.lastIndexOf('/');
                if (index != -1)
                {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append("Line#:");
            str.append(((SAXParseException)ex).getLineNumber());
            str.append(" Column#:");
            str.append(((SAXParseException)ex).getColumnNumber());
            retValue = str.toString();
        }
        return retValue;
    }

} // class Validator
