/* CopyrightVersion 1.0
 *
 * Change Log:
 *    Last Modified By: $Author: Irene $
 *    Last Modified On: $Date: 05/07/01 3:59p $
 */

package com.sonicsw.mf.common.xml;

import java.util.HashMap;
import java.util.Iterator;

/**
    Helper class used to write and format XML string.
*/

public class XMLStringWriter
{
    private static final String NEWLINE = System.getProperty("line.separator");

    int m_tabCounter = 0;
    StringBuffer m_strBuffer = null;
    static String TAB = "  ";

    public XMLStringWriter()
    {
        m_strBuffer = new StringBuffer();
    }

    protected StringBuffer getXMLString()
    {
        return m_strBuffer;
    }

    protected void setTabCounter()
    {
        m_tabCounter ++;
    }

    protected void resetTabCounter()
    {
        m_tabCounter--;
    }

    protected void setProcInstruction(String version, String encode)
    {
         m_strBuffer.append("<?xml version=");
         m_strBuffer.append("\"" + version + "\"");
         m_strBuffer.append(" encoding=\"" + encode + "\"?>");
    }


    protected void startElement(String elementName, HashMap attrPair, boolean emptyElement)
    {
        m_strBuffer.append(NEWLINE);
        addTabs();
        m_strBuffer.append("<" + elementName);
        if(attrPair == null) //no attributes
        {
            if(!emptyElement)
            {
                m_strBuffer.append(">");
            }
        }
        else
        {
            Iterator i = attrPair.keySet().iterator();
            while(i.hasNext())
            {
                  String name = (String)i.next();
                  m_strBuffer.append(" ");
                  m_strBuffer.append(name + "=" + "\"" + attrPair.get(name) + "\"");
            }

            if(!emptyElement)
            {
                m_strBuffer.append(">");
            }
        }
    }

    protected void endElement(String elementName)
    {
        if(elementName == null) //means EMPTY element
        {
            m_strBuffer.append(" />");
        }
        else{
            m_strBuffer.append(NEWLINE);
            addTabs();
            m_strBuffer.append("</" + elementName + ">");
        }
    }

    protected boolean isMarkup(String value)
    {
        boolean flag = false;
        if(value.indexOf("<") != -1 || value.indexOf("&") != -1 )
        {
            flag = true;
        }
        else{
            if(value.indexOf("\'") != -1 || value.indexOf("\"") != -1 )
            {
                flag = true;
            }
        }
        return flag;
    }

    protected void createCDATA(String value)
    {
        m_strBuffer.append(XMLConstants.START_CDATA);
        String tmp = replaceAll(value, XMLConstants.START_CDATA, XMLConstants.MF_START_CDATA);
        String data = replaceAll(tmp, XMLConstants.END_CDATA, XMLConstants.MF_END_CDATA);
        m_strBuffer.append(data);
        m_strBuffer.append(XMLConstants.END_CDATA);
    }


    //helper methods

    private void addTabs()
    {
        for (int i = 0; i < m_tabCounter; i++)
         {
            m_strBuffer.append(TAB); //using two spaces
        }
    }

  static String replaceAll(String src, String oldString, String newString)
  {
      StringBuffer result = new StringBuffer(oldString.length());

      int index = 0;
      while (index < src.length())
      {
          int replacePosition = src.indexOf(oldString, index);
          if (replacePosition == -1)
          {
              String nextChunk = src.substring(index);
              result.append(nextChunk);
              index += nextChunk.length();
          }
          else
          {
              String nextChunk = src.substring(index, replacePosition);
              result.append(nextChunk);
              result.append(newString);
              index = replacePosition + oldString.length();
          }
      }

      return result.toString();
  }


}//end of class
