package com.sonicsw.mf.eclipse;


/**
 * Object for describing the characteristics of linked resources that are stored
 * in the project description.
 */
public class LinkDescription {
	private String name;
	private String localLocation;
	private int type;

	public static final int FOLDER_TYPE = 0x2;
	
	public LinkDescription(String name, int type, String localLocation) {
		this.name = name;
		this.type = type;
		this.localLocation = localLocation;
	}

	public LinkDescription()
	{
		this.type = -1;
		this.name = "";
		this.localLocation = "";
	}
	@Override
    public boolean equals(Object o) {
		if (o == null || this.getClass() != o.getClass())
        {
            return false;
        }
		LinkDescription other = (LinkDescription) o;
		return localLocation.equals(other.localLocation) && type == other.type;
	}

	public String getLocation() {
		return localLocation;
	}

	public String getName() {
		return name;
	}

	public int getType() {
		return type;
	}

	@Override
    public int hashCode() {
		return type + localLocation.hashCode();
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setType(int type) {
		this.type = type;
	}

	public void setLocation(String location) {
		this.localLocation = location;
	}
}

