package com.sonicsw.mf.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;


/**
 * <p>Title: </p>
 * <p>Description: Copied from org.eclipse.core.internal.localstore.SafeChunkyInputStream version 3.1.0.
 * Incorporates org.eclipse.core.internal.localstore.ILocalStoreContstants into this class</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class SafeChunkyInputStream extends InputStream {
	protected static final int BUFFER_SIZE = 8192;
	protected byte[] buffer;
	protected int bufferLength = 0;
	protected byte[] chunk;
	protected int chunkLength = 0;
	protected boolean endOfFile = false;
	protected InputStream input;
	protected int nextByteInBuffer = 0;
	protected int nextByteInChunk = 0;
        // from org.eclipse.core.internal.localstore.ILocalStoreConstants
        private final static int SIZE_LASTMODIFIED = 8;
	private static final int SIZE_COUNTER = 1;
	private static final int SIZE_KEY_SUFFIX = SIZE_LASTMODIFIED + SIZE_COUNTER;

	/** constants for safe chunky streams */ // constants originally from org.eclipse.core.internal.localstore.ILocalStoreConstants

	// 40b18b8123bc00141a2596e7a393be1e
	private static final byte[] BEGIN_CHUNK = {64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};

	// c058fbf323bc00141a51f38c7bbb77c6
	private static final byte[] END_CHUNK = {-64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};

	/** chunk delimiter size */
	// BEGIN_CHUNK and END_CHUNK must have the same length
	private static final int CHUNK_DELIMITER_SIZE = BEGIN_CHUNK.length;

	public SafeChunkyInputStream(File target) throws IOException {
		this(target, BUFFER_SIZE);
	}

	public SafeChunkyInputStream(File target, int bufferSize) throws IOException {
		input = new FileInputStream(target);
		buffer = new byte[bufferSize];
	}

	protected void accumulate(byte[] data, int start, int end) {
		byte[] result = new byte[chunk.length + end - start];
		System.arraycopy(chunk, 0, result, 0, chunk.length);
		System.arraycopy(data, start, result, chunk.length, end - start);
		chunk = result;
		chunkLength = chunkLength + end - start;
	}

	@Override
    public int available() throws IOException {
		return chunkLength - nextByteInChunk;
	}

	protected void buildChunk() throws IOException {
		if (nextByteInBuffer + CHUNK_DELIMITER_SIZE > bufferLength)
        {
            shiftAndFillBuffer();
        }
		int end = find(END_CHUNK, nextByteInBuffer, bufferLength, true);
		if (end != -1) {
			accumulate(buffer, nextByteInBuffer, end);
			nextByteInBuffer = end + CHUNK_DELIMITER_SIZE;
			return;
		}
		accumulate(buffer, nextByteInBuffer, bufferLength);
		bufferLength = input.read(buffer);
		nextByteInBuffer = 0;
		if (bufferLength == -1) {
			endOfFile = true;
			return;
		}
		buildChunk();
	}

	@Override
    public void close() throws IOException {
		input.close();
	}

	protected boolean compare(byte[] source, byte[] target, int startIndex) {
		for (int i = 0; i < target.length; i++) {
			if (source[startIndex] != target[i])
            {
                return false;
            }
			startIndex++;
		}
		return true;
	}

	protected int find(byte[] pattern, int startIndex, int endIndex, boolean accumulate) throws IOException {
		int pos = findByte(pattern[0], startIndex, endIndex);
		if (pos == -1)
        {
            return -1;
        }
		if (pos + CHUNK_DELIMITER_SIZE > bufferLength) {
			if (accumulate)
            {
                accumulate(buffer, nextByteInBuffer, pos);
            }
			nextByteInBuffer = pos;
			pos = 0;
			shiftAndFillBuffer();
		}
		if (compare(buffer, pattern, pos))
        {
            return pos;
        }
		return find(pattern, pos + 1, endIndex, accumulate);
	}

	protected int findByte(byte target, int startIndex, int endIndex) {
		while (startIndex < endIndex) {
			if (buffer[startIndex] == target)
            {
                return startIndex;
            }
			startIndex++;
		}
		return -1;
	}

	protected void findChunkStart() throws IOException {
		if (nextByteInBuffer + CHUNK_DELIMITER_SIZE > bufferLength)
        {
            shiftAndFillBuffer();
        }
		int begin = find(BEGIN_CHUNK, nextByteInBuffer, bufferLength, false);
		if (begin != -1) {
			nextByteInBuffer = begin + CHUNK_DELIMITER_SIZE;
			return;
		}
		bufferLength = input.read(buffer);
		nextByteInBuffer = 0;
		if (bufferLength == -1) {
			resetChunk();
			endOfFile = true;
			return;
		}
		findChunkStart();
	}

	@Override
    public int read() throws IOException {
		if (endOfFile)
        {
            return -1;
        }
		// if there are bytes left in the chunk, return the first available
		if (nextByteInChunk < chunkLength)
        {
            return chunk[nextByteInChunk++] & 0xFF;
        }
		// Otherwise the chunk is empty so clear the current one, get the next
		// one and recursively call read.  Need to recur as the chunk may be
		// real but empty.
		resetChunk();
		findChunkStart();
		if (endOfFile)
        {
            return -1;
        }
		buildChunk();
		refineChunk();
		return read();
	}

	/**
	 * Skip over any begin chunks in the current chunk.  This could be optimized
	 * to skip at the same time as we are scanning the buffer.
	 */
	protected void refineChunk() {
		int start = chunkLength - CHUNK_DELIMITER_SIZE;
		if (start < 0)
        {
            return;
        }
		for (int i = start; i >= 0; i--) {
			if (compare(chunk, BEGIN_CHUNK, i)) {
				nextByteInChunk = i + CHUNK_DELIMITER_SIZE;
				return;
			}
		}
	}

	protected void resetChunk() {
		chunk = new byte[0];
		chunkLength = 0;
		nextByteInChunk = 0;
	}

	protected void shiftAndFillBuffer() throws IOException {
		int length = bufferLength - nextByteInBuffer;
		System.arraycopy(buffer, nextByteInBuffer, buffer, 0, length);
		nextByteInBuffer = 0;
		bufferLength = length;
		int read = input.read(buffer, bufferLength, buffer.length - bufferLength);
		if (read != -1)
        {
            bufferLength += read;
        }
        else {
			resetChunk();
			endOfFile = true;
		}
	}
}
