package com.sonicsw.mf.framework;

import com.sonicsw.mf.common.AbstractComponent;
import com.sonicsw.mf.common.IComponentContext;

public abstract class AbstractFrameworkComponent
extends AbstractComponent
implements IFrameworkComponent
{
    protected IFrameworkComponentContext m_frameworkContext;
    protected IContainer m_container;

    //
    // IComponent interface
    //

    /**
     * @see com.sonicsw.mf.common.IComponent#init(IComponentContext)
     */
    @Override
    public void init(IComponentContext context)
    {
        super.init(context);
        m_frameworkContext = (IFrameworkComponentContext)context;
        m_container = m_frameworkContext.getContainer();
    }

}
