package com.sonicsw.mf.framework;

import javax.management.MBeanInfo;
import javax.management.ObjectName;

public interface IAuditManager
{
    public boolean configureAuditingEnabled();
    
    public void recordConfigureEvent(String[] logicalPaths, String[] storagePaths, int[] actions, String[] details);
    
    public void recordConfigurePermissionDeniedEvent(String logicalPath, String storagePath, int requiredPermission);
    
    public void recordManageEvent(ObjectName objectName, MBeanInfo mBeanInfo, String operationName, Object[] params, Object returnValue);
    
    public void recordManagePermissionDeniedEvent(ObjectName objectName, String operationName, int requiredPermission);
    
    public void recordEvent(String logger, String message);
}
