package com.sonicsw.mf.framework;

/**
 * Global framework components are singleton framework components within
 * the MF domain. Examples are the Directory Service and the Agent Manager.
 */
public interface IGlobalFrameworkComponent extends IFrameworkComponent
{
    /**
     * Get the reserved ID name for the global component.
     */
    public String getGlobalID();

    /**
     * This method must be implemented by a global component to support the protocol that verifies that only
     * a single instance of this component is started in the domain. The component calls
     * AbstractContainer.globalComponentUniquenessCall(globalID, uniqueCallID) from its init() method with its global ID
     * and a unique call ID (such as a java.rmi.server.UID.toString() object). globalComponentUniquenessCall() calls the uniquenessCheck()
     * method of all the instances (hopefully there is only a single instance - the one that made the call) of that type. In uniquenessCheck
     * the component must verify the the container ID matches its container and the callID matches the callID it passed globalComponentUniquenessCall().
     * If not, it issues a warning about more than a single instance started.
     *
     * @param containerID the ID of the container of the component which called globalComponentUniquenessCall()
     * @param callID a unique ID in the JVM which called globalComponentUniquenessCall()
     *
     */
    public void uniquenessCheck(String containerID, String callID);
}
