package com.sonicsw.mf.framework;

import java.util.Properties;

import com.sonicsw.mf.common.runtime.IFileDescriptor;
import com.sonicsw.mf.common.runtime.IRemoteCallResult;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResultWithData;

public interface IHostManager
{
    public Properties getJVMProperties();

    public IRemoteCallResult  installLauncher(String targetSonicHome);

    public IRemoteCallResult bytesToFile(byte[] src, String destinationFilePath, Boolean rewriteIfExists);

    public IRemoteCallResult setupContainer(Properties props, String INIEncryptionPassword);

    public IRemoteCallResult setupContainer(String containerDSPath, Properties props, String INIEncryptionPassword);

    public IRemoteCallResult setupContainer(String sonicHome, String launcherVersion, Properties props, String INIEncryptionPassword);

    public IRemoteCallResult launchContainer(String containerName, Boolean launchAsWindowsService);

    public IRemoteCallResult launchContainer(String sonicHome, String containerName, Boolean launchAsWindowsService);

    public IRemoteCallResult deleteFiles(String pathOfdirectoryOrFile, Boolean deleteContent);

    public IRemoteCallResult removeContainer(String containerName);

    public RemoteCallResultWithData fileToBytes(String srcFilePath);

    public IRemoteCallResult downloadFileFromDS(String dsFilePath, String destinationFilePath, Boolean rewriteIfExists, Boolean expandZip);

    public IFileDescriptor[] listDirectory(String directoryPath);

    public IRemoteExecResult remoteExec (String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes);
    
    public String[] getAllHostnamesAndIPs(Boolean includeLoopback);
}
