package com.sonicsw.mf.framework;

import javax.management.MBeanInfo;
import javax.management.ObjectName;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.runtime.impl.CollectiveOpStatus;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;

public interface IPermissionsManager
{
    public static String ESCAPED_PATH_DELIMITER = "_0x2F_";
    public static String PATH_DELIMITER = "/";
    public static String ESCAPED_SPACE_CHARACTER = "_0x20_";
    public static String SPACE_CHARACTER = " ";
    
    public void configurePermissionCheck(IComponentContext context, String path, boolean isLogicalPath, int requiredPermission)
    throws ManagementPermissionDeniedException;
    
    public void managePermissionCheck(ObjectName objectName, String operationName, MBeanInfo mBeanInfo)
    throws ManagementPermissionDeniedException;
    
    /**
     * 
     * @return true if the calling thread is an execution thread and the 
     * user ID of the execution thread is the super user "Administrator"
     */
    public boolean isSuperUser();

    /**
     * For use by AM. The returned CollectiveOpStatus will have entries for each component for which there
     * was no permission or that we encountered issues when getting the MBeanInfo.
     * <p>
     * The AM should then find which components in the collection that there is not already a failure for
     * and invoke the operation on those, then merge the collective results with the results from the call
     * made to this method.
     */
    public CollectiveOpStatus managePermissionCheck(ObjectName[] objectNames, String operationName);

    public short getPrincipalType(String principal);
    
    /**
     * Used by the DSComponent to call permissions checking only when it's 
     * really enabled. 
     * 
     * @return true of permissions checking has been enabled
     */
    public boolean isPermissionsCheckingEnabled();
    
}
