package com.sonicsw.mf.framework.agent;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.naming.Context;

import com.sonicsw.mx.util.IEmptyArray;

import com.sonicsw.mf.comm.CommunicationConstants;
import com.sonicsw.mf.comm.IConnectorClient;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.impl.ChangeRegistration;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.CollectiveOpStatus;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.SubComponentState;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.jmx.client.MFNotification;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;

public abstract class AbstractMBean
implements DynamicMBean, NotificationEmitter
{
    private static final boolean DEBUG = false;

    private boolean m_isClosing = false;

    ContainerImpl m_container;
    IComponent m_component;
    private MBeanInfo m_mbeanInfo;
    private String m_releaseVersion;
    private Timer m_commonTimer;
    private Hashtable m_scheduledTasks = new Hashtable();

    private HashMap m_notificationSources = new HashMap();
    private Thread m_notificationSubscriptionRenewalThread;
    private HashMap m_notificationHandlers = new HashMap();
    private HashMap m_lastHandlerRenewals = new HashMap();
    private HashMap m_notificationListeners = new HashMap();
    private long[] m_notificationSequenceNumber;

    // We use a Hashtable since it should be thread safe
    private Hashtable m_acceptChangesList = new Hashtable();
    private ChangeRegistration m_changeRegistration = new ChangeRegistration();

    Class m_componentClass;
    ClassLoader m_componentClassLoader;
    boolean m_isDifferentClassLoader;

    // this is the name of the component within the domain
    CanonicalName m_componentName;
    ObjectName m_objectName;
    private String m_taskThreadName;
    private String m_timerTaskThreadName;

    // this is the configuration name of the component within the domain
    private String m_configID;
    private IElementIdentity m_elementIdentity;

    // component error condition
    private String m_lastErrorDescription;
    private int m_lastErrorLevel;
    IComponentContext m_componentContext;

    // components classpath
    private String m_classpath;

    private int m_traceMaskOnCleanup;

    // value used to determine when to expire notification subscriptions
    private Long m_notificationSubscriptionTimeout = new Long(DurableConnector.DURABLE_SUBSCRIPTION_TTL);
    private long m_notificationSubscriptionRenewalInterval = CommunicationConstants.NOTIFICATION_SUBSCRIPTION_RENEWAL_INTERVAL;  // interval between subscription renewal attempts...

    // we will reuse the AgentManager's canonical name often, so stick it in a var
    // rather than reconstruct each time
    private String m_agentManagerID;

    protected ArrayList m_attributes = new ArrayList();
    protected ArrayList m_operations = new ArrayList();
    protected ArrayList m_notifications = new ArrayList();

    static final ArrayList DEFAULT_ATTRIBUTE_INFOS = new ArrayList(15);
    static final ArrayList DEFAULT_OPERATION_INFOS = new ArrayList(3);
    static final ArrayList DEFAULT_NOTIFICATION_INFOS = new ArrayList(2);

    private static final String[][] EMPTY_STRING_ARRAY_ARRAY = new String[0][];
    private static final Object[] GET_FT_STATE_ATTR_PARAMS = new Object[] { new String[] { "FaultTolerantState" } };

    private static final String[] HANDLE_NOTIFICATION_SIGNATURE = new String[] { INotification.class.getName() };
    private static final String[] HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE = new String[] { String.class.getName(), String[].class.getName(), Long.class.getName() };
    static final String[] SET_ATTRIBUTES_SIGNATURE = new String[] { String[].class.getName(), Object[].class.getName() };
    static final String[] GET_ATTRIBUTE_VALUES_SIGNATURE = new String[] { String[].class.getName() };

    private static Method RELOAD_METHOD;
    private static Method HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD;
    private static Method SET_ATTRIBUTES_METHOD;
    private static Method GET_ATTRIBUTE_VALUES_METHOD;
    private static Method GET_MBEAN_INFO_METHOD;
    private static final Integer LOGICAL_NOTIFY = new Integer(0);
    private static final Integer FILE_NOTIFY = new Integer(1);

    public static final String LOGGED_MESSAGE_TO_NOTIFICATION = "LoggedMessage";
    private static final String HANDLE_NOTIFICATION_METHOD_NAME = "handleNotification";
    private static final String HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME = "handleNotificationSubscription";
    private static final String LOG_MESSAGE_METHOD_NAME = "logMessage";
    private static final String RECORD_AUDIT_EVENT_METHOD_NAME = "recordAuditEvent";

    static
    {
        try
        {
            RELOAD_METHOD = AbstractMBean.class.getDeclaredMethod("reload", IEmptyArray.EMPTY_CLASS_ARRAY);
            HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD = AbstractMBean.class.getDeclaredMethod("handleNotificationSubscription", new Class[] { String.class, String[].class, Long.class });
            SET_ATTRIBUTES_METHOD = AbstractMBean.class.getDeclaredMethod("setAttributes", new Class[] { String[].class, Object[].class });
            GET_ATTRIBUTE_VALUES_METHOD = AbstractMBean.class.getDeclaredMethod("getAttributeValues", new Class[] { String[].class });
            GET_MBEAN_INFO_METHOD = AbstractMBean.class.getDeclaredMethod("getMBeanInfo", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch(NoSuchMethodException nsme)
        {
            nsme.printStackTrace(); // ok to do as it should never happen
        }

        MBeanFeatureInfo mbInfo = null;

        //
        // Attributes
        //

        // component configuration identity
        mbInfo = new MBeanAttributeInfo("ConfigID", String.class.getName(), "Configuration identity.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component class
        mbInfo = new MBeanAttributeInfo("Classname", String.class.getName(), "Component classname.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component release version
        mbInfo = new MBeanAttributeInfo("ReleaseVersion", String.class.getName(), "Component release version.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component state attribute
        mbInfo = new MBeanAttributeInfo("State", Short.class.getName(), "Execution state of the component.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component state string attribute
        mbInfo = new MBeanAttributeInfo("StateString", String.class.getName(), "Description of the execution state of the component.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component error description
        mbInfo = new MBeanAttributeInfo("LastError", String.class.getName(), "Last (uncleared) error condition.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component error severity level
        mbInfo = new MBeanAttributeInfo("LastErrorLevel", Integer.class.getName(), "Last (uncleared) error severity.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component error severity description
        mbInfo = new MBeanAttributeInfo("LastErrorLevelString", String.class.getName(), "Last (uncleared) error severity description.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component uptime attribute
        mbInfo = new MBeanAttributeInfo("Uptime", Long.class.getName(), "Execution time (milliseconds).", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // component classpath attribute
        mbInfo = new MBeanAttributeInfo("Classpath", String.class.getName(), "Component classpath.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // debug mask attribute
        mbInfo = new MBeanAttributeInfo("TraceMask", Integer.class.getName(), "Debug bit mask.", true, true, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        // debug mask values attribute
        mbInfo = new MBeanAttributeInfo("TraceMaskValues", String.class.getName(), "Possible TraceMask values.", true, false, false);
        DEFAULT_ATTRIBUTE_INFOS.add(mbInfo);

        //
        // Operations
        //

        // reload component
        mbInfo = new MBeanOperationInfo("reload", "Asynchronously reload the component and restart the component if it was previously online.",
                                        IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), MBeanOperationInfo.ACTION);
        DEFAULT_OPERATION_INFOS.add(mbInfo);

        //
        // Notifications
        //

    }

    AbstractMBean(ContainerImpl container, IComponent component, String id, String configID)
    throws Exception
    {
        m_container = container;
        m_component = component;
        m_componentContext = retrieveContext();

        m_componentClass = m_component.getClass();
        m_componentClassLoader = m_componentClass.getClassLoader();
        m_isDifferentClassLoader = m_componentClassLoader != m_container.m_defaultClassLoader;

        // get the component's canonical name within the domain
        IContainerIdentity containerIdentity = m_container.getContainerIdentity();
        m_objectName = new ObjectName(containerIdentity.getDomainName() + '.' + containerIdentity.getContainerName() + ':' + IComponentIdentity.ID_PREFIX + id);
        m_componentName = new CanonicalName(m_objectName.getCanonicalName());
        m_taskThreadName = m_componentName.getComponentName() + " - Task";
        m_timerTaskThreadName = m_componentName.getComponentName() + " - Timer Task";

        m_configID = configID;
        IElement element = m_container.getConfiguration(configID);
        m_elementIdentity = element.getIdentity();
        m_agentManagerID = m_componentName.getDomainName() + '.' + IAgentManagerProxy.GLOBAL_ID + ':' + IComponentIdentity.ID_PREFIX + IAgentManagerProxy.GLOBAL_ID;
        m_lastErrorDescription = "";
        m_lastErrorLevel = Level.UNKNOWN;

        try
        {
            if (m_isDifferentClassLoader)
            {
                Thread.currentThread().setContextClassLoader(m_componentClassLoader);
            }
            // this also ensures the configuration is retrieved at least once
            m_releaseVersion = m_componentContext.getConfiguration(false).getIdentity().getReleaseVersion();
            m_component.init(m_componentContext);
        }
        finally
        {
            if (m_isDifferentClassLoader)
            {
                Thread.currentThread().setContextClassLoader(m_container.m_defaultClassLoader);
            }
        }

        m_attributes.addAll(DEFAULT_ATTRIBUTE_INFOS);
        if (id.equals(IAgentProxy.ID))
        {
            // then we don't want to expose stop, start or reload
            MBeanOperationInfo[] operationInfos = (MBeanOperationInfo[])DEFAULT_OPERATION_INFOS.toArray(new MBeanOperationInfo[0]);
            for (int i = 0; i < operationInfos.length; i++)
            {
                if ("start,stop,reload".indexOf(operationInfos[i].getName()) == -1)
                {
                    m_operations.add(operationInfos[i]);
                }
            }
        }
        else if (id.equals(DSComponent.GLOBAL_ID))
        {
            // then we don't want to expose reload - the DS requires a special reload with access to the ds.xml etc.
            // We didn't identify yet a requirement to enable this
            MBeanOperationInfo[] operationInfos = (MBeanOperationInfo[])DEFAULT_OPERATION_INFOS.toArray(new MBeanOperationInfo[0]);
            for (int i = 0; i < operationInfos.length; i++)
            {
                if ("reload".indexOf(operationInfos[i].getName()) == -1)
                {
                    m_operations.add(operationInfos[i]);
                }
            }
        }
        else
        {
            m_operations.addAll(DEFAULT_OPERATION_INFOS);
        }
        if (id.equals(IAgentProxy.ID))
        {
            // then we don't want to expose system.state.Offline
            MBeanNotificationInfo[] notificationInfos = (MBeanNotificationInfo[])DEFAULT_NOTIFICATION_INFOS.toArray(new MBeanNotificationInfo[0]);
            for (int i = 0; i < notificationInfos.length; i++)
            {
                if (!MFNotification.getType(notificationInfos[i].getNotifTypes()).equals(INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY] + '.' + INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY] + '.' + IComponentState.STATE_TEXT[IComponentState.STATE_OFFLINE]))
                {
                    m_notifications.add(notificationInfos[i]);
                }
            }
        }
        else
        {
            m_notifications.addAll(DEFAULT_NOTIFICATION_INFOS);
        }
    }

    private IComponentContext retrieveContext() {
        return getContext();
    }
    abstract IComponentContext getContext();

    Context getInitialContext()
    {
        return m_container.getInitialContext();
    }

    String[] getAllAcceptedChanges()
    {
        if (m_componentContext != null)
        {
            String[] resultList = new String[m_acceptChangesList.size()];
            Enumeration allChanges = m_acceptChangesList.keys();
            for (int i = 0; i < resultList.length; i++)
            {
                resultList[i] = (String)allChanges.nextElement();
            }
            return resultList;
        }
        else {
            throw new Error("No Context"); // Should never happen
        }
    }

    void handleFileChange(IFSElementChange change)
    {
        // Set the delta so that the component can fire the handlers without passing the delta explicitly
        if (change.getChangeType() == IElementChange.ELEMENT_UPDATED)
        {
            setDelta((IDeltaElement)change.getElement());
        }
        else if  (change.getChangeType() == IElementChange.ELEMENT_DELETED)
        {
            setDeletedElementName(change.getElement().getIdentity().getName());
        }

        m_component.handleFileChange(change);

        // If the component didn't fire the handlers we have to adjust since some attributes might
        // have been deleted
        adjustHandlers();
    }

    void handleElementChange(IElementChange change)
    {
        // Set the delta so that the component can fire the handlers without passing the delta explicitly
        if (change.getChangeType() == IElementChange.ELEMENT_UPDATED)
        {
            setDelta((IDeltaElement)change.getElement());
        }
        else if  (change.getChangeType() == IElementChange.ELEMENT_DELETED)
        {
            setDeletedElementName(change.getElement().getIdentity().getName());
        }

        m_component.handleElementChange(change);

        // If the component didn't fire the handlers we have to adjust since some attributes might
        // have been deleted
        adjustHandlers();
    }

    IComponent getManagedComponent() { return m_component; }

    IComponentState getComponentState()
    {
        return new ComponentState(m_componentName, m_elementIdentity, m_component.getState().shortValue(), m_lastErrorDescription, m_lastErrorLevel, getSubComponentStates());
    }
    
    private Map<String, ISubComponentState[]> getSubComponentStates()
    {
        // we have to get the subcomponent state by reflection to ensure version compatibility
        try
        {
            Method getSubComponentStatesMethod = m_component.getClass().getMethod("getSubComponentStates");
            Map<String, Map<String, Short>> rawTypes = (Map<String, Map<String, Short>>)getSubComponentStatesMethod.invoke(m_component);
            
            Map<String, ISubComponentState[]> typeStates = new HashMap<String, ISubComponentState[]>();
            
            for (Map.Entry<String, Map<String, Short>> typeEntry : rawTypes.entrySet())
            {
                String type = typeEntry.getKey();
                Set<Entry<String, Short>> entries = typeEntry.getValue().entrySet();
                ISubComponentState[] subComponentStates = new ISubComponentState[entries.size()];
                
                int i = 0;
                for (Map.Entry<String, Short> stateEntry : entries)
                {
                    subComponentStates[i++] = (new SubComponentState(m_componentName, m_elementIdentity, stateEntry.getKey(), type, stateEntry.getValue().shortValue()));
                }
                
                typeStates.put(type, subComponentStates);
            }
            
            return typeStates;
        }
        catch (Exception e)
        {
            return null;
        }
    }

    final void preCleanup() { m_isClosing = true; }

    void reload()
    throws Exception
    {
        preCleanup(); // we can call this before the container does as we know this is going to happen anyway
        m_container.reloadComponent(m_componentName.getComponentName());
    }

    synchronized void clearError()
    {
        m_lastErrorLevel = Level.UNKNOWN;
        m_lastErrorDescription = "";
    }

    void handleNotification(INotification notification)
    {
        CanonicalName notificationSource = new CanonicalName(notification.getSourceIdentity().getCanonicalName());
        String notificationType = notification.getType();

        // special case the AM for system notifications
        if (notificationType.startsWith(INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY]) && m_componentName.getCanonicalName().endsWith(IAgentManagerProxy.GLOBAL_ID))
        {
            ((INotificationHandler)m_component).handleNotification(notification);
        }

        // if this is a forwarded notification then replace the notification source with the forwarded by
        HashMap attributes = notification.getAttributes();
        if (attributes != null)
        {
            String forwardedBy = (String)attributes.get("ForwardedBy");
            if (forwardedBy != null)
            {
                notificationSource = new CanonicalName(forwardedBy);
            }
        }

        // then forward to any other handlers
        HashMap handlers = null;
        synchronized(m_notificationSources)
        {
            handlers = getNotificationSourceHandlers(notificationSource);
        }

        if (handlers == null)
        {
            return;
        }

        // iterate through the handlers to see if there is a handler for the notification
        Iterator iterator = handlers.entrySet().iterator();
        while (iterator.hasNext())
        {
            Map.Entry entry = (Map.Entry)iterator.next();
            String[] notificationTypes = (String[])entry.getValue();
            for (int i = 0; i < notificationTypes.length; i++)
            {
                if (notificationTypes[i].equals(notificationType))  // check for exact match
                {
                    ((INotificationHandler)entry.getKey()).handleNotification(notification);
                    break;
                }
                else if (notificationTypes[i].endsWith("*"))  // check for wildcard match
                {
                    int index = notificationTypes[i].indexOf("*");
                    String typeSubstring = notificationTypes[i].substring(0, index - 1);
                    if (notificationType.length() >= index) // only need to check for a match if the length of the input notification type is at least as long as the length of the registered notification type
                    {
                        String notificationTypeSubstring = notificationType.substring(0, index - 1);
                        if (typeSubstring.equals(notificationTypeSubstring))
                        {
                           ((INotificationHandler)entry.getKey()).handleNotification(notification);
                           break;
                        }
                    }
                }
            }
        }
    }

    private HashMap getNotificationSourceHandlers(CanonicalName notificationSource)
    {
        String componentName = notificationSource.getComponentName();

        // if not a global (singleton) component then its a straight lookup
        if (componentName.compareTo(notificationSource.getContainerName()) == 0)
        {
            return (HashMap)m_notificationSources.get(notificationSource.getCanonicalName());
        }

        // if not, we have to iterate through
        Iterator notificationSources = m_notificationSources.entrySet().iterator();
        while (notificationSources.hasNext())
        {
            Map.Entry entry = (Map.Entry)notificationSources.next();

            if (((String)entry.getKey()).endsWith(IComponentIdentity.DELIMITED_ID_PREFIX + componentName))
            {
                return (HashMap)entry.getValue();
            }
        }

        return null;
    }

    void handleFSNamingNotification(INamingNotification notification)
    {
        m_component.handleFSNamingNotification(notification);
    }

    void cleanup()
    {
        // stop notification renewal
        if (m_notificationSubscriptionRenewalThread != null)
        {
            m_notificationSubscriptionRenewalThread.interrupt();
        }

        // cancel any scheduled tasks
        Object[] tasks = m_scheduledTasks.keySet().toArray();
        for (int i = 0; i < tasks.length; i++)
        {
            cancelTask((Runnable)tasks[i]);
        }

        m_traceMaskOnCleanup = m_component.getTraceMask().intValue();

        // help GC out .. but careful what you add here in case it is needed by async notification handling
        // after the component is torn down
        m_component = null;
        m_componentContext = null;
        m_componentClassLoader = null;
        m_elementIdentity = null;
    }

    void loadComponent(String id, String configID, boolean start, int traceMask)
    throws Exception
    {
        m_container.loadComponent(id, configID, start, traceMask, false);
    }

    void unloadComponent(String id)
    throws Exception
    {
        m_container.unloadComponent(id);
    }
    
    String getConfigID()
    {
        return this.m_configID;
    }
    
    Boolean acceptChanges(String elementName, String dirName)
    {
        if (m_componentContext != null)
        {
            return new Boolean(acceptChanges(elementName) || acceptChanges(dirName));
        }
        else {
            throw new Error("No Context"); // Should never happen
        }
    }

    boolean isLogicalRequest(String elementName)
    {
        Object hashEntry = m_acceptChangesList.get(elementName);
        return ( (hashEntry != null) &&
                 (hashEntry.equals(LOGICAL_NOTIFY) || hashEntry.equals(FILE_NOTIFY)));
    }

    boolean isFileRequest(String elementName)
    {
        Object hashEntry = m_acceptChangesList.get(elementName);
        return ( (hashEntry != null) && hashEntry.equals(FILE_NOTIFY));
    }

    void setRuntimeConfiguration(IDirElement configuration)
    {
        m_container.setRuntimeConfiguration(configuration);
    }

    IElement getConfiguration(String configID, boolean acceptChanges)
    {
        return getConfiguration(configID, acceptChanges, false);
    }

    IElement getConfiguration(String configID, boolean acceptChanges, boolean alwaysFromDS)
    {
        if (configID == null)
        {
            configID = m_configID;
        }

        // do not override an entry for a logical name request
        if (acceptChanges && (m_acceptChangesList.get(configID) == null) )
        {
            m_acceptChangesList.put(configID, configID);
        }

        // if acceptChanges is false, remove the id from the list. Do not override
        // a logical request
        if (!acceptChanges)
        {
            Object acceptType = m_acceptChangesList.get(configID);
            if (acceptType != null && acceptType.equals(configID))
            {
                m_acceptChangesList.remove(configID);
            }
        }

        return m_container.getConfiguration(configID, alwaysFromDS);
    }

    public int checkFSConfiguration(String path)
    {
    	return m_container.checkFSConfiguration(path);
    }
    
    IElement getFSConfiguration(String path, boolean notify)
    {
        return getFSConfiguration(path, notify, false);
    }

    IElement getFSConfiguration(String path, boolean notify, boolean alwaysFromDS)
    {
        IElement fsElement =  m_container.getFSConfiguration(path, alwaysFromDS);
        if ((fsElement!= null) && notify)
        {
            // logical requests override storage name requests, so always put it in the list
            m_acceptChangesList.put(fsElement.getIdentity().getName(), LOGICAL_NOTIFY);
        }
         //if notify is false, remove the id from the list.
        if (!notify && fsElement != null)
        {
            String storageName = fsElement.getIdentity().getName();
            m_acceptChangesList.remove(storageName);
        }
        return fsElement;
    }

    IElement registerFileChangeInterest(String path)
    {
        String sonicFSPrefix = Container.SONICFS_PROTOCOL.substring(0, Container.SONICFS_PROTOCOL.length() -1);
        String configName = path;

        if (configName.startsWith(sonicFSPrefix))
        {
            configName = configName.substring(sonicFSPrefix.length());
        }
        if (!configName.startsWith(DSComponent.MF_DIR_SEPARATOR_STRING))
            // there's a domain name in the sonicfs URL
        {
            String domainName = configName.substring(0, configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
            if (!domainName.equals(m_componentName.getDomainName()))
            {
                throw new MFRuntimeException("Domain name in register file interest is not known: " + domainName);
            }
            configName = configName.substring(configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
        }
        IElement fileEnvelope = m_container.getFSConfiguration(configName);
        if (fileEnvelope != null)
        {
            m_acceptChangesList.put(fileEnvelope.getIdentity().getName(), FILE_NOTIFY);
        }

        return fileEnvelope;
    }

    void unregisterFileChangeInterest(String path)
    {
        String sonicFSPrefix = Container.SONICFS_PROTOCOL.substring(0, Container.SONICFS_PROTOCOL.length() -1);
        String configName = path;
        if (configName.startsWith(sonicFSPrefix))
        {
            configName = configName.substring(sonicFSPrefix.length());
        }
        if (!configName.startsWith(DSComponent.MF_DIR_SEPARATOR_STRING))
            // there's a domain name in the sonicfs URL
        {
            String domainName = configName.substring(0, configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
            if (!domainName.equals(m_componentName.getDomainName()))
            {
                throw new MFRuntimeException("Domain name in register file interest is not known: " + domainName);
            }
            configName = configName.substring(configName.indexOf(DSComponent.MF_DIR_SEPARATOR_STRING));
        }
        IElement fileEnvelope = m_container.getFSConfiguration(configName);
        if (fileEnvelope != null)
        {
            m_acceptChangesList.remove(fileEnvelope.getIdentity().getName());
        }
    }

    File getLocalFile(String path) throws MFException
    {
        return m_container.getLocalFile(path);
    }

    String getPrivateSubDir(String baseDir)
    {
        return m_container.getPrivateSubDir(this.m_configID, baseDir);
    }


    IElement[] getConfigurations(String[] configIDs, boolean[] acceptChanges)
    {
        if (configIDs == null || acceptChanges == null)
        {
            throw new IllegalArgumentException("The parameters must not be 'null'.'");
        }

        if (configIDs.length != acceptChanges.length)
        {
            throw new IllegalArgumentException("'acceptChanges' must have the same number of array elements as 'configIDs'.");
        }

        for (int i = 0; i < configIDs.length; i++)
        {
            if (acceptChanges[i] && (m_acceptChangesList.get(configIDs[i]) == null) )
            {
                m_acceptChangesList.put(configIDs[i], configIDs[i]);
            }
        }

        return m_container.getConfigurations(configIDs);
    }

    IElement[] getConfigurations(String dirName, boolean acceptChanges)
    {
        if (acceptChanges)
        {
            m_acceptChangesList.put(dirName, dirName);
        }

        return m_container.getConfigurations(dirName, new Boolean(acceptChanges));
    }


    private boolean acceptChanges(String entityName)
    {
        return m_acceptChangesList.containsKey(entityName);
    }

    synchronized boolean registerErrorCondition(String errorMessage, int errorLevel)
    {
        if (errorLevel < Level.UNKNOWN || errorLevel > Level.WARNING)
        {
            throw new IllegalArgumentException("Illegal error level: " + errorLevel);
        }

        // has to be more severe error than that already set
        if (m_lastErrorLevel != Level.UNKNOWN && errorLevel > m_lastErrorLevel)
        {
            return false;
        }

        m_lastErrorLevel = errorLevel;
        m_lastErrorDescription = errorMessage == null ? "" : errorMessage;

        return true;
    }

    abstract void addSharedPath(URL url)
    throws UnsupportedOperationException;

    abstract void addSharedClassname(String classname)
    throws UnsupportedOperationException;

    boolean isOperationExported(String operationName, String[] signature)
    {
        // if its not exported here then try the superclass
        if (getOperationInfo(operationName, signature) == null)
        {
            if (operationName.equals(AbstractMBean.HANDLE_NOTIFICATION_METHOD_NAME) && signature.length == 1 && signature[0].equals(HANDLE_NOTIFICATION_SIGNATURE[0]))
            {
                return true;
            }
            if (operationName.equals(AbstractMBean.LOG_MESSAGE_METHOD_NAME) && m_componentName.getComponentName().equals("AGENT MANAGER"))
            {
                return true;
            }
            if (operationName.equals(AbstractMBean.RECORD_AUDIT_EVENT_METHOD_NAME) && m_componentName.getComponentName().equals("AGENT MANAGER"))
            {
                return true;
            }
            if (operationName.equals(HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME) && signature.length == 3 && signature[0].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[0]) && signature[1].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[1]) && signature[2].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[2]))
            {
                return true;
            }
            if (operationName.equals("setAttributes") && signature.length == 2 && signature[0].equals(SET_ATTRIBUTES_SIGNATURE[0]) && signature[1].equals(SET_ATTRIBUTES_SIGNATURE[1]))
            {
                return true;
            }
            if (operationName.equals("getAttributeValues") && signature.length == 1 && signature[0].equals(GET_ATTRIBUTE_VALUES_SIGNATURE[0]))
            {
                return true;
            }
            // is it a DynamicMBean method
            try
            {
                Class[] classes = new Class[signature.length];
                for (int i = 0; i < signature.length; i++)
                {
                    classes[i] = Class.forName(signature[i]);
                }
                DynamicMBean.class.getDeclaredMethod(operationName, classes);
                return true;
            }
            catch(ClassNotFoundException e) { } // fall through to return false
            catch(NoSuchMethodException e) { } // fall through to return false
            return false;
        }

        return true;
    }

    ObjectName getObjectName() { return m_objectName; }

    //
    // DynamicMBean interface
    //

    @Override
    public Object getAttribute(String name)
    throws AttributeNotFoundException, MBeanException, ReflectionException
    {
        MBeanAttributeInfo info = getAttributeInfo(name);

        if (info == null)
        {
            throw new AttributeNotFoundException(name + " is not a valid attribute.");
        }

        if (!info.isReadable())
        {
            throw new AttributeNotFoundException(name + " is not a readable attribute.");
        }

        // deal with managed attributes before forwarding to the component
        if (name.equals("ConfigID"))
        {
            return m_configID;
        }
        if (name.equals("Classname"))
        {
            return m_componentClass.getName();
        }
        if (name.equals("ReleaseVersion"))
        {
            return m_releaseVersion;
        }
        if (name.equals("LastError"))
        {
            return m_lastErrorDescription;
        }
        if (name.equals("LastErrorLevel"))
        {
            return new Integer(m_lastErrorLevel);
        }
        if (name.equals("LastErrorLevelString"))
        {
            return Level.LEVEL_TEXT[m_lastErrorLevel];
        }
        if (name.equals("Classpath"))
         {
            return m_classpath == null ? getClasspath() : m_classpath; // get on fly if it was never set
        }

        try
        {
            // if its a dynamic MBean call directly
            if (m_component instanceof DynamicMBean)
            {
                return ((DynamicMBean)m_component).getAttribute(name);
            }

            Method method = m_componentClass.getMethod("get" + name, IEmptyArray.EMPTY_CLASS_ARRAY);
            return method.invoke(m_component, IEmptyArray.EMPTY_OBJECT_ARRAY);
        }
        catch(Exception e)
        {
            if (e instanceof NoSuchMethodException)
            {
                throw new ReflectionException(e);
            }
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names)
    {
        // even if its a dynamic MBean, we'll get each attribute locally as there will likely
        // be a combination of attributes values provided by this wrapper class and the underlying
        // dynamic MBean component

        AttributeList attributeList = new AttributeList();

        // loop through the attributes adding their values to the list
        // NOTE: Its undefined what to do on a partial failure.
        for (int i = 0; i < names.length; i++)
        {
            try
            {
                attributeList.add(new Attribute(names[i], getAttribute(names[i])));
            }
            catch(Throwable e) { }
        }

        return attributeList;
    }

    @Override
    public void setAttribute(Attribute attribute)
    throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
    {
        try
        {
            // if its a dynamic MBean call directly
            if (m_component instanceof DynamicMBean)
            {
                ((DynamicMBean)m_component).setAttribute(attribute);
                return;
            }

            String name = attribute.getName();
            MBeanAttributeInfo info = validateAttribute(name);

            Object value = getAttributeValue(attribute,info);

            setAttribute(name, value);
        }
        catch(Exception e)
        {
            if (e instanceof NoSuchMethodException)
            {
                throw new ReflectionException(e);
            }
            throw new MBeanException(e);
        }
    }

    MBeanAttributeInfo validateAttribute(String name)
    throws AttributeNotFoundException
    {
        MBeanAttributeInfo info = getAttributeInfo(name);

        if (info == null)
        {
            throw new AttributeNotFoundException(name + " is not a valid attribute.");
        }

        if (!info.isWritable())
        {
            throw new AttributeNotFoundException(name + " is not a writeable attribute.");
        }

        return info;
    }

    Object getAttributeValue(Attribute attribute,MBeanAttributeInfo info)
    throws InvalidAttributeValueException
    {
        Object value = attribute.getValue();
        if (value != null && !value.getClass().getName().equals(info.getType()))
        {
            throw new InvalidAttributeValueException();
        }

        return value;
    }

    // return the list of attributes that were sucessfuly updated
    public String[] setAttributes(String[] names, Object[] values)
    {
        // We should not get so far with this error - it should be cought by the Agent Manager
        if (names.length != values.length)
        {
            throw new RuntimeException("The number of attribute names does not match the number of values.");
        }

        if (values.length == 0)
        {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }

        AttributeList attributes = new AttributeList();
        for (int i = 0; i < names.length; i++)
        {
            attributes.add(new Attribute(names[i], values[i]));
        }
        AttributeList updatedAttributes = setAttributes(attributes);

        String[] returnValue = new String[updatedAttributes.size()];
        for (int i = 0; i < updatedAttributes.size(); i++)
        {
            returnValue[i] = ((Attribute)updatedAttributes.get(i)).getName();
        }

        return returnValue;

    }

    @Override
    public AttributeList setAttributes(AttributeList attributes)
    {
        AttributeList updatedAttributes = new AttributeList();

        int length = attributes.size();
        for (int i = 0; i < length; i++)
        {
            Attribute attribute = (Attribute)attributes.get(i);
            try
            {
                setAttribute(attribute);
                updatedAttributes.add(attribute);
            }
            catch(Exception e) { } // JMX spec indicates to skip ones that fail the set
        }
        return updatedAttributes;
    }

    @Override
    public Object invoke(String operationName, Object params[], String signature[])
    throws MBeanException, ReflectionException
    {
        MBeanOperationInfo info = getOperationInfo(operationName, signature);

        if (info == null)
        {
            throw new ReflectionException(new NoSuchMethodException(), "Unknown operation: " + operationName);
        }

        try
        {
            return internalInvoke(operationName, params, signature);
        }
        catch(Throwable e)
        {
            try
            {
                ExceptionMapper.throwMappedException(e, false, false);
            }
            catch(MBeanException mBeanException) { throw mBeanException; }
            catch(ReflectionException reflectionException) { throw reflectionException; }
            catch(Exception exception)
            {
                if (exception instanceof RuntimeException)
                {
                    throw (RuntimeException)exception;
                }
            }
            // other conditions should not occur after mapping
            logMessage("Please report to Sonic the following trace...", e, Level.WARNING);
            throw new RuntimeErrorException(new Error("Runtime error: check agent for details"));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo()
    {
        if (m_mbeanInfo == null)
        {
            if (m_component instanceof DynamicMBean)
            {
                m_mbeanInfo = ((DynamicMBean)m_component).getMBeanInfo();
                MBeanAttributeInfo[] attributes = m_mbeanInfo.getAttributes();
                if (attributes != null)
                {
                    for (int i = 0;i < attributes.length;i++)
                    {
                        m_attributes.add(attributes[i]);
                    }
                }
                MBeanOperationInfo[] operations = m_mbeanInfo.getOperations();
                if (operations != null)
                {
                    for (int i = 0;i < operations.length;i++)
                    {
                        m_operations.add(operations[i]);
                    }
                }
                MBeanNotificationInfo[] notifications = m_mbeanInfo.getNotifications();
                if (notifications != null)
                {
                    for (int i = 0;i < notifications.length;i++)
                    {
                        m_notifications.add(notifications[i]);
                    }
                }
            }
            else
            {
                MBeanAttributeInfo[] attributes = m_component.getAttributeInfos();
                if (attributes != null)
                {
                    for (int i = 0;i < attributes.length;i++)
                    {
                        m_attributes.add(attributes[i]);
                    }
                }
                MBeanOperationInfo[] operations = m_component.getOperationInfos();
                if (operations != null)
                {
                    for (int i = 0;i < operations.length;i++)
                    {
                        m_operations.add(operations[i]);
                    }
                }
                MBeanNotificationInfo[] notifications = m_component.getNotificationInfos();
                if (notifications != null)
                {
                    for (int i = 0;i < notifications.length;i++)
                    {
                        m_notifications.add(notifications[i]);
                    }
                }
            }

            // we always control the constructor .. whether its a dynamic MBean or not
            Class mBeanClass = this.getClass();
            MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[1];
            constructors[0] = new MBeanConstructorInfo("Framework constructor", mBeanClass.getConstructors()[0]);

            m_mbeanInfo = new MBeanInfo(mBeanClass.getName(), "Sonic MBean",
                                        (MBeanAttributeInfo[])m_attributes.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY),
                                        constructors,
                                        (MBeanOperationInfo[])m_operations.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY),
                                        (MBeanNotificationInfo[])m_notifications.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY));
        }

        return m_mbeanInfo;
    }

    //
    // NotificationEmitter interface
    //

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
    {
        if (DEBUG)
        {
            System.out.println((new Date(System.currentTimeMillis())).toString() + "Delegate.addNotificationListener()");
        }

        synchronized(m_notificationListeners)
        {
            HashMap handbacks = (HashMap)m_notificationListeners.get(listener);
            if (handbacks == null)
            {
                handbacks = new HashMap();
                m_notificationListeners.put(listener, handbacks);
            }

            ArrayList filters = (ArrayList)handbacks.get(handback);
            if (filters == null)
            {
                filters = new ArrayList();
                handbacks.put(handback, filters);
            }

            if (!filters.contains(filter))
            {
                filters.add(filter);
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
    throws ListenerNotFoundException
    {
        if (DEBUG)
        {
            System.out.println((new Date(System.currentTimeMillis())).toString() + "Delegate.removeNotificationListener()");
        }

        synchronized(m_notificationListeners)
        {
            HashMap handbacks = (HashMap)m_notificationListeners.get(listener);
            if (handbacks == null)
            {
                throw new ListenerNotFoundException("Unknown listener");
            }

            ArrayList filters = (ArrayList)handbacks.get(handback);
            if (filters == null)
            {
                throw new ListenerNotFoundException("Unknown handback");
            }

            if (!filters.remove(filter))
            {
                throw new ListenerNotFoundException("Unknown filter");
            }

            if (filters.isEmpty())
            {
                handbacks.remove(handback);
                if (handbacks.isEmpty())
                {
                    m_notificationListeners.remove(listener);
                }
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener)
    throws ListenerNotFoundException
    {
        if (DEBUG)
        {
            System.out.println((new Date(System.currentTimeMillis())).toString() + "Delegate.removeNotificationListener()");
        }

        synchronized(m_notificationListeners)
        {
            if (m_notificationListeners.remove(listener) == null)
            {
                throw new ListenerNotFoundException("Unknown listener");
            }
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() { return m_mbeanInfo.getNotifications(); }

    //
    // Internal methods
    //

    /**
     * Get the classpath of the underlying resource
     */
    private String getClasspath()
    {
        StringBuffer sb = new StringBuffer();

        URL[] urls = ((URLClassLoader)m_componentClassLoader).getURLs();
        for (int i = 0; i < urls.length; i++)
        {
            if (i > 0)
            {
                sb.append(IContainer.DS_CLASSPATH_DELIMITER);
            }
            sb.append(urls[i].toExternalForm());
        }

        return sb.toString();
    }

    MBeanAttributeInfo getAttributeInfo(String name)
    {
        // get the info object and derive the getter
        MBeanAttributeInfo[] attributes = m_mbeanInfo.getAttributes();
        for (int i = 0; i < attributes.length; i++)
        {
            if (attributes[i].getName().equals(name))
            {
                return attributes[i];
            }
        }

        return null;
    }

    private MBeanOperationInfo getOperationInfo(String operationName, String[] signature)
    {
        // get the info object
        MBeanOperationInfo[] operations = m_mbeanInfo.getOperations();
        for (int i = 0; i < operations.length; i++)
        {
            if (operations[i].getName().equals(operationName))
            {
                MBeanParameterInfo[] params = operations[i].getSignature();
                if (params.length != signature.length)
                {
                    continue;
                }
                for (int j = 0; j < params.length; j++)
                {
                    if (!params[j].getType().equals(signature[j]))
                    {
                        continue;
                    }
                }
                return operations[i];
            }
        }

        return null;
    }

    public Object[] getAttributeValues(String[] names)
    {
        Object[] values = new Object[names.length];

        for (int i = 0; i < names.length; i++)
        {
            try
            {
                values[i] = getAttribute(names[i]);
            } catch(Exception e) { }
        }

        return values;
    }

    private void setAttribute(String name, Object value)
    throws Exception
    {
        int traceMask = AbstractMBean.this.m_component.getTraceMask().intValue();
        Object originalValue = null;
        if ((traceMask & (IComponent.TRACE_ATTRIBUTES | IComponent.TRACE_VERBOSE)) > 0)
        {
            originalValue = getAttribute(name);
        }

        Method method = m_componentClass.getMethod("set" + name, new Class[] { value.getClass() });

        try
        {
            if (m_isDifferentClassLoader)
            {
                Thread.currentThread().setContextClassLoader(m_componentClassLoader);
                value = ContainerUtil.transferObject(value, m_componentClassLoader);
            }
            method.invoke(m_component, new Object[] { value });
        }
        finally
        {
            if (m_isDifferentClassLoader)
            {
                Thread.currentThread().setContextClassLoader(m_container.m_defaultClassLoader);
            }
        }

        if ((traceMask & IComponent.TRACE_ATTRIBUTES) > 0)
        {
            StringBuffer msg = new StringBuffer("Set attribute [" + name + "]");
            if ((traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                msg.append(", values...");
                msg.append(IContainer.NEWLINE).append("\tOriginal value = ").append(originalValue);
                msg.append(IContainer.NEWLINE).append("\tNew value      = ").append(value);
            }
            logMessage(msg.toString(), Level.TRACE);
        }
    }

    Object internalInvoke(String operationName, Object[] params, String[] signature)
    throws Exception
    {
        Object returnValue = null;

        try
        {
            Method method = null;
            Object target = null;

            if (operationName.equals("reload") && signature.length == 0)
            {
                target = this;
                method = RELOAD_METHOD;
            }
            else if (operationName.equals(HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME) && signature.length == 3 && signature[0].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[0]) && signature[1].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[1]) && signature[2].equals(HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE[2]))
            {
                target = this;
                method = HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD;
            }
            else if (operationName.equals("setAttributes") && signature.length == 2 && signature[0].equals(SET_ATTRIBUTES_SIGNATURE[0]) && signature[1].equals(SET_ATTRIBUTES_SIGNATURE[1]))
            {
                target = this;
                method = SET_ATTRIBUTES_METHOD;
            }
            else if (operationName.equals("getAttributeValues") && signature.length == 1 && signature[0].equals(GET_ATTRIBUTE_VALUES_SIGNATURE[0]))
            {
                target = this;
                method = GET_ATTRIBUTE_VALUES_METHOD;
            }
            else if (operationName.equals("getMBeanInfo") && signature.length == 0)
            {
                target = this;
                method = GET_MBEAN_INFO_METHOD;
            }
            else if (operationName.equals("start") )
            {
                //throw exception if starting a component when the FT container is not active
                if (m_container.isFTContainer() && !m_container.isFailingOver() && (!m_container.getContainerFT().isActive()))
                {
                    throw new IllegalStateException("Cannot start component when the container is " + IFaultTolerantState.STATE_TEXT[m_container.getContainerFT().getState()]);
                }
            }

            // still not set ? - then set from component
            if (target == null)
            {
                target = m_component;

                if (!(target instanceof DynamicMBean))
                {
                    Class[] parameterTypes = new Class[signature.length];
                    for (int i = 0;i < signature.length;i++)
                    {
                        parameterTypes[i] = m_componentClassLoader.loadClass((String)signature[i]);
                    }
                    method = m_componentClass.getMethod(operationName, parameterTypes);
                }
            }

            if (method == null)
            {
                returnValue = internalInvoke(target, operationName, signature, params);
            }
            else
            {
                returnValue = internalInvoke(target, operationName, method, params);
            }
        }
        catch(com.odi.FatalException e)
        {
            logMessage("Failed operation ["  + operationName + "], trace follows...", e, Level.SEVERE);
            m_container.m_agent.shutdown(IContainerExitCodes.DS_FAILURE_EXIT_CODE);
            throw e;
        }
        catch(com.odi.SessionException e)
        {
            logMessage("Failed operation ["  + operationName + "], trace follows...", e, Level.SEVERE);
            m_container.m_agent.shutdown(IContainerExitCodes.DS_FAILURE_EXIT_CODE);
            throw e;
        }
        catch(MFException e)
        {
            throwWrappedExceptionOnUnload(e);
        }
        catch(MFRuntimeException e)
        {
            throwWrappedExceptionOnUnload(e);
        }
        catch(RuntimeException e)
        {
            if (e.getClass().getName().startsWith("java."))
            {
                throwWrappedExceptionOnUnload(e);
            }
            MFRuntimeException mfe = new MFRuntimeException();
            mfe.setLinkedException(e);
            throwWrappedExceptionOnUnload(mfe);
        }
        catch(Exception e)
        {
            if (e.getClass().getName().startsWith("java."))
            {
                throwWrappedExceptionOnUnload(e);
            }
            MFException mfe = new MFException();
            mfe.setLinkedException(e);
            throwWrappedExceptionOnUnload(mfe);
        }
        catch(OutOfMemoryError e)
        {
            logMessage("Failed operation ["  + operationName + "] due to insufficient memory...", e, Level.SEVERE);
            throw e;
        }
        catch(Error e)
        {
            logMessage("Failed operation ["  + operationName + "], trace follows...", e, Level.SEVERE);
            throw e;
        }


        return returnValue;
    }

    void throwWrappedExceptionOnUnload(Exception e)
    throws Exception
    {
        if (m_isClosing)
        {
            MFRuntimeException mfe = new MFRuntimeException("Request failure occured while unloading/reloading");
            mfe.setLinkedException(e);
            throw mfe;
        }

        // else
        throw e;
    }

    Object internalInvoke(Object target, String operationName, Object object, Object[] params)
    throws Exception
    {
        // need to get this here as the component may have been destroyed after invoking the operation
        int traceMask = AbstractMBean.this.m_component.getTraceMask().intValue();

        Object returnValue = null;

        ClassLoader contextClassLoader = null;

        try
        {
            if (m_isDifferentClassLoader)
            {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(m_componentClassLoader);
                params = (Object[])ContainerUtil.transferObject(params, m_componentClassLoader);
            }
            if (target instanceof DynamicMBean && object instanceof String[])
            {
                returnValue = ((DynamicMBean)target).invoke(operationName, params, (String[])object);
            }
            else
            {
                returnValue = ((Method)object).invoke(target, params);
            }
            if (m_isDifferentClassLoader)
            {
                returnValue = ContainerUtil.transferObject(returnValue, m_container.m_defaultClassLoader);
            }
        }
        catch(InvocationTargetException e)
        {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof Exception)
            {
                throw (Exception)throwable;
            }
            else
            if (throwable instanceof Error)
            {
                throw (Error)throwable;
            }
            else
            {
                String msg = "Operation [" + operationName + "] failure on: " + m_componentName.getCanonicalName();
                logMessage(msg + ",trace follows...", throwable, Level.WARNING);
                throw new MFRuntimeException(msg);
            }
        }
        finally
        {
            if (m_isDifferentClassLoader)
            {
                Thread.currentThread().setContextClassLoader(contextClassLoader == null ? m_container.m_defaultClassLoader : contextClassLoader);
            }
        }

        if ((traceMask & IComponent.TRACE_OPERATIONS) > 0)
        {
            StringBuffer msg = new StringBuffer("Operation invoked [" + operationName + "]");
            if ((traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                if (params.length > 0 || returnValue != null || (object instanceof Method && !(((Method)object).getReturnType().equals(Void.TYPE))))
                {
                    msg.append(", details...");
                    if (params.length > 0)
                    {
                        for (int i = 0; i < params.length; i++)
                        {
                            msg.append(IContainer.NEWLINE).append("\tparams[").append(i).append("] = ").append(toString(params[i]));
                        }
                    }
                    if (returnValue != null || (object instanceof Method && !(((Method)object).getReturnType().equals(Void.TYPE))))
                    {
                        msg.append(IContainer.NEWLINE).append("\treturn = ").append(toString(returnValue));
                    }
                }
            }
            logMessage(msg.toString(), Level.TRACE);
        }

        return returnValue;
    }

    private String toString(Object object)
    {
        if (object == null)
        {
            return null;
        }

        if (object instanceof List)
        {
            object = ((List)object).toArray();
        }

        if (object instanceof Set)
        {
            object = ((Set)object).toArray();
        }

        if (!object.getClass().isArray())
        {
            return object.toString();
        }

        // arrays get special treatment
        try
        {
        	int origLength = Array.getLength(object);
        	StringBuffer sb = new StringBuffer();
        	sb.append("Array of " + origLength +  " items");
        	int useLength = 10;
        	if (origLength < 10)
            {
                useLength = origLength;
            }
        	if (origLength > 10)
            {
                sb.append("; first 10 items: ");
            }
            else
            {
                sb.append(": ");
            }
            sb.append('{');           
            for (int i = 0; i < useLength; i++)
            {
                if (i > 0)
                {
                    sb.append(", ");
                }
                sb.append(toString(Array.get(object, i)));
            }

            sb.append('}');
            return sb.toString();
        }
        catch (Exception illegal) // catch IllegalArgumentException, if we happen not to
                                  // get an array (unexpected)
                                  // and any other exception we might get but can't think of 
                                  // right now.
        {
        	return " Parsing array we got " + illegal.toString();
        }
    }

    INotification createNotification(short category, String subCategory, String eventName, int severityLevel)
    {
        MFNotification notification = new MFNotification(m_objectName, category, subCategory, eventName, severityLevel);

        if (m_notificationSequenceNumber == null)
        {
            m_notificationSequenceNumber = new long[] { 0 };
        }

        synchronized(m_notificationSequenceNumber)
        {
            notification.setSequenceNumber(m_notificationSequenceNumber[0]++);
        }

        notification.setSourceIdentity(new ComponentIdentity(m_componentName, m_elementIdentity));

        return notification;
    }

    void sendNotification(final INotification notification)
    {
        HashMap attributes = notification.getAttributes();
        boolean isForwardedNotification = attributes != null && attributes.containsKey("ForwardedBy");

        // Sonic00010504 - safety measure to ensure we don't throw a NPE
        int traceMask = m_traceMaskOnCleanup;
        try
        {
            traceMask = AbstractMBean.this.m_component.getTraceMask().intValue();
        }
        catch (NullPointerException npe) { }

        // component state notifications carry the last error info
        if (notification.getCategory() == INotification.SYSTEM_CATEGORY &&
            notification.getSubCategory().equals(INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY]))
        {
            // only set last error stuff if its not been set already (a forwarded notification would have it set at the source)
            if (!isForwardedNotification)
            {
                notification.setAttribute("LastError", m_lastErrorDescription);
                notification.setAttribute("LastErrorLevel", "" + m_lastErrorLevel);
                attributes = notification.getAttributes();
            }
        }

        if ((traceMask & IComponent.TRACE_NOTIFICATIONS) > 0 && !notification.getEventName().equals(LOGGED_MESSAGE_TO_NOTIFICATION))
        {
            StringBuffer msg = new StringBuffer("Notification generated [" + notification.getType() + "]");
            if ((traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                if (attributes == null)
                {
                    msg.append(", containing 0 attributes");
                }
                else if (!attributes.isEmpty())
                {
                    msg.append(", containing attributes...");
                    Object[] entries = attributes.entrySet().toArray();
                    for (int i = 0; i < entries.length; i++)
                    {
                        msg.append(IContainer.NEWLINE).append('\t').append(((Map.Entry)entries[i]).getKey()).append('=').append(((Map.Entry)entries[i]).getValue());
                    }
                }
            }
            logMessage(msg.toString(), Level.TRACE);
        }

        // this can be done on the current thread here, as if it ends up being a remote call then it will
        // get handled on a separate thread later on
        sendInternalNotification(notification);

        // don't send externally if this is a startup notification being sent by the AGENT .. these only
        // go to the AM, which then will send out its own startup notification
        if (notification.getType().equals(IAgentManagerProxy.SYSTEM_STATE_STARTUP_NOTIFICATION_ID) &&
            m_componentName.getComponentName().equals(IAgentProxy.ID))
        {
            return;
        }

        // Fire off on a separate thread so we are not blocking the sender
        // for a protracted period if there are multiple listeners.  If the
        // container is closing, kick off the thread immediately; otherwise
        // let the container's Task Scheduler determine when to run the thread.
        Runnable notificationSender = new Runnable()
        {
            @Override
            public void run()
            {
                AbstractMBean.this.sendExternalNotification(notification);
            }
        };

        // if the container is in the process of shutting down, fire off the notification immediately, using a separate thread;
        // otherwise, schedule the notification to be published by the notification publisher thread.
        // [It may be obvious, but the notification is sent asynchronously in both cases.]
        if (m_container.isClosing())
        {
        	(new Thread(notificationSender)).start();
        }
        else
        {
            m_container.getNotificationPublisher().enqueueNotificationTask(notificationSender, System.currentTimeMillis() + JMSConnectorServer.NOTIFICATION_TTL);
        }
    }

    void logMessage(String message, int severityLevel)
    {
        m_container.logMessage(m_componentName.getComponentName(), message, severityLevel);
    }

    void logMessage(String message, Throwable exception, int severityLevel)
    {
        m_container.logMessage(m_componentName.getComponentName(), message, exception, severityLevel);
    }

    void logMessage(Throwable exception, int severityLevel)
    {
        logMessage("Trace follows...", exception, severityLevel) ;
    }

    private void setDelta(IDeltaElement delta)
    {
         m_changeRegistration.setDelta(delta);
    }

    private void setDeletedElementName(String deletedElementName)
    {
         m_changeRegistration.setDeletedElementName(deletedElementName);
    }

    private void adjustHandlers()
    {
         m_changeRegistration.adjustHandlers();
    }

    void fireAttributeChangeHandlers()
    {
         m_changeRegistration.fireAttributeChangeHandlers(true);
    }

    void registerAttributeChangeHandler(AttributeName name, IAttributeChangeHandler handler)
    {
         m_changeRegistration.registerAttributeChangeHandler(name, handler);
    }

    void unregisterAttributeChangeHandler(AttributeName name)
    {
         m_changeRegistration.unregisterAttributeChangeHandler(name);
    }

    IElement getContainerConfiguration(boolean acceptsChanges)
    {
        return getConfiguration(m_container.getContainerIdentity().getConfigIdentity().getName(), acceptsChanges);
    }
    
    IAttributeSet getDeploymentParameters()
    {
        // get the container's Config Element
        IElementIdentity containerIdentity = m_container.getContainerIdentity().getConfigIdentity();
        IElement containerCE = m_componentContext.getConfiguration( containerIdentity.getName(), true );

        // get the "components" attribute set
        IAttributeSet containerAS = (IAttributeSet) containerCE.getAttributes();
        IAttributeSet componentAS = (IAttributeSet) containerAS.getAttribute( IContainerConstants.COMPONENTS_ATTR );

        // get the "StartupParams" attribute map for the component
        HashMap map = (HashMap) componentAS.getAttributes();
        String compID = m_componentName.getComponentName();
        IAttributeSet spas = (IAttributeSet) map.get(compID);

        // return if no startup parameters found for the component
        if (spas == null)
        {
            return null ;
        }

        // get the "deploymentParametersSet" attribute set
        IAttributeSet dpas = (IAttributeSet) spas.getAttribute(/*IContainerConstants.DEPLOYMENT_PARAMETERS*/"DEPLOYMENT_PARAMETERS");

        return dpas ;
    }

    /**
     * This is the "server" side of internal notification subscriptions. addNotificationHandler and
     * removeNotificationHandler handle the "client" side of internal notification subscriptions.
     */
    public void handleNotificationSubscription(String handlerID, String[] notificationTypes)
    {
        handleNotificationSubscription(handlerID, notificationTypes, m_notificationSubscriptionTimeout);
    }

    /**
     * This is the "server" side of internal notification subscriptions. addNotificationHandler and
     * removeNotificationHandler handle the "client" side of internal notification subscriptions.
     */
    public void handleNotificationSubscription(String destination, String[] notificationTypes, Long notificationSubscriptionTimeout)
    {
        NotificationHandlerDelegate localHandler = null;
        synchronized(m_notificationHandlers)
        {
            // if the length is 0, then we should remove all subscriptions for this handler
            if (notificationTypes.length == 0)
            {
                //logMessage("handleNotificationSubscription() remove: " + destination, Level.TRACE);

                localHandler = (NotificationHandlerDelegate)m_notificationHandlers.remove(destination);
                m_container.deleteNotificationHandlerSubscriptionsFromCache(m_objectName, localHandler);
            }
            else
            {
                localHandler = (NotificationHandlerDelegate)m_notificationHandlers.get(destination);
                if (localHandler == null)
                {
                    localHandler = new NotificationHandlerDelegate(destination);
                    m_notificationHandlers.put(destination, localHandler);
                    //logMessage("handleNotificationSubscription() add: " + destination, Level.TRACE);
                }
                //else logMessage("handleNotificationSubscription() renew/update: " + destination, Level.TRACE);


                localHandler.setHandledNotificationTypes(notificationTypes);
                localHandler.setNotificationSubscriptionTimeout(notificationSubscriptionTimeout.longValue());

                m_container.storeNotificationHandlerSubscriptionsInCache(m_objectName, localHandler);
            }

            //logMessage("handleNotificationSubscription(): " + new java.util.Date() + ", destination=" + destination + ", notificationTypes.length()=" + notificationTypes.length, Level.TRACE);
        }
    }

    void restoreNotificationHandler(NotificationHandlerDelegate localHandler)
    {
        synchronized(m_notificationHandlers)
        {
            m_notificationHandlers.put(localHandler.getDestination(), localHandler);
        }
    }

    /**
     * Send notifications within MF.
     */
    private void sendInternalNotification(final INotification notification)
    {
        // if its a system state notification and this component is not the AM, then send it to the AM
        if (notification.getCategory() == INotification.SYSTEM_CATEGORY && notification.getSubCategory().equals(INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY]) && !m_componentName.getComponentName().equals(IAgentManagerProxy.GLOBAL_ID))
        {
            // when sending to the AM the TTL can be short because the AM will poll if it does not get a notification within
            // the poll period
            final long amNotificationsTTL = m_container.m_agent.getNotificationInterval();

            // delaying sending notifications until the container is booted avoids
            // failure messages being sent to the console for something that is
            // obvious (the messages themselves can cause concern)
            if (m_container.isBooted())
            {
                invokeHandleNotification(m_agentManagerID, notification, amNotificationsTTL);
            }
            else
            {
                Thread invoker = new Thread(m_componentName.getComponentName() + " - Delayed Notification Notifier")
                {
                    @Override
                    public void run()
                    {
                        // we must use the delegate here as we are synchronizing on it
                        IContainer container = ContainerImpl.getContainer();
                        synchronized(container)
                        {
                            while (!container.isBooted())
                            {
                                if (container.isClosing())
                                {
                                    return;
                                }

                                try { container.wait(1000); } catch (InterruptedException e) { } // ignore
                            }
                       }
                       AbstractMBean.this.invokeHandleNotification(AbstractMBean.this.m_agentManagerID, notification, amNotificationsTTL);
                    }
                };
                invoker.setDaemon(true);
                invoker.start();
            }
        }

        if (m_notificationHandlers.isEmpty())
         {
            return; // no one is interested !
        }

        String notificationType = notification.getType();

        // find the set of notification handlers that have been registered to handle the input notification type
        Iterator localHandlers = getMatchingNotificationHandlers(notificationType);
        while (localHandlers.hasNext())
        {
            NotificationHandlerDelegate localHandler = (NotificationHandlerDelegate)localHandlers.next();
            invokeHandleNotification(localHandler.getDestination(), notification, localHandler.getNotificationSubscriptionTimeout());
        }
    }

    private Iterator getMatchingNotificationHandlers(String notificationType)
    {
        ArrayList handlerList = new ArrayList();

        synchronized(m_notificationHandlers)
        {
            Iterator localHandlers = m_notificationHandlers.values().iterator();
            while (localHandlers.hasNext())
            {
                NotificationHandlerDelegate localHandler = (NotificationHandlerDelegate)localHandlers.next();
                if (localHandler.hasExpired()) // don't provide a match because its expired
                {
                    localHandlers.remove();
                    m_container.deleteNotificationHandlerSubscriptionsFromCache(m_objectName, localHandler);

                    if ((m_container.m_agent.m_traceMask & Agent.TRACE_SUBSCRIPTION_EXPIRATIONS) > 0)
                    {
                        m_container.logMessage(IAgentProxy.ID, "Expired management notification subcription(s) from \"" + localHandler.getDestination() + "\" to \"" + getContext().getComponentName().getComponentName() + "\"", Level.TRACE);
                    }

                    continue;
                }

                if (localHandler.handlesNotificationType(notificationType))
                {
                    handlerList.add(localHandler);
                }
            }
        }

        return handlerList.iterator();
    }


    /**
     * Send notifications to external clients that have specifically registered for them.
     */
    void sendExternalNotification(INotification notification)
    {
        // at the moment the underlying implementation is already a JMX notification
        Notification jmxNotification = (Notification)notification;

        ArrayList matchingListeners = new ArrayList();
        ArrayList matchingHandbacks = new ArrayList();
        synchronized(m_notificationListeners)
        {
            if (m_notificationListeners.isEmpty())
             {
                return;  // simply return if there are not registered listeners
            }

            Iterator listeners = m_notificationListeners.entrySet().iterator();
            while (listeners.hasNext())
            {
                ArrayList notifiedHandbacks = new ArrayList();
                Map.Entry listenerEntry = (Map.Entry)listeners.next();
                NotificationListener listener = (NotificationListener)listenerEntry.getKey();
                Iterator handbacks = ((HashMap)listenerEntry.getValue()).entrySet().iterator();
                while (handbacks.hasNext())
                {
                    Map.Entry handbackEntry = (Map.Entry)handbacks.next();
                    Object handback = handbackEntry.getKey();
                    // test if we are already sending to this handback, if we have skip to next filter handback pair
                    if (notifiedHandbacks.contains(handback))
                    {
                        continue;
                    }

                    Iterator filters = ((ArrayList)handbackEntry.getValue()).iterator();
                    while (filters.hasNext())
                    {
                        NotificationFilter filter = (NotificationFilter)filters.next();
                        if (filter == null || filter.isNotificationEnabled(jmxNotification))
                        {
                            notifiedHandbacks.add(handback);
                            matchingListeners.add(listener);
                            matchingHandbacks.add(handback);
                        }
                    }
                }
            }
        }

        for (int i = matchingListeners.size() - 1; i >= 0; i--)
        {
            ((NotificationListener)matchingListeners.get(i)).handleNotification(jmxNotification, matchingHandbacks.get(i));
        }
    }

    private void invokeHandleNotification(String destination, INotification notification, long ttl)
    {
        boolean isTraceable = !(notification.getEventName().equals(Agent.LOG_MESSAGE_NOTIFICATION_TYPE));

        // Sonic00010504 - safety measure to ensure we don't throw a NPE
        int traceMask = m_traceMaskOnCleanup;
        if (isTraceable)
        {
            try
            {
                traceMask = AbstractMBean.this.m_component.getTraceMask().intValue();
            }
            catch (NullPointerException npe) { }
        }

        boolean synchronous = false;

        // if the handler is in the same container, then make the call synchronous
        // if the container is shutting down
        if (isSameContainer(destination) && m_container.isClosing())
        {
            synchronous = true;
        }
        try
        {
            if (isTraceable && (traceMask & IComponent.TRACE_NOTIFICATIONS) > 0 && (traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                StringBuffer msg = new StringBuffer("Sending notification [" + notification.getType() + "] to " + destination);
                logMessage(msg.toString(), Level.TRACE);
            }
            invoke(destination, AbstractMBean.HANDLE_NOTIFICATION_METHOD_NAME, new Object[] { notification }, HANDLE_NOTIFICATION_SIGNATURE, synchronous, ttl);
        }
        catch(Exception e)
        {
            if (isTraceable && (traceMask & IComponent.TRACE_NOTIFICATIONS) > 0 && (traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                StringBuffer msg = new StringBuffer("Failed to send notification [" + notification.getType() + "] to " + destination + ", trace follows...");
                logMessage(msg.toString(), e, Level.TRACE);
            }
        }
    }

    void setNotificationSubscriptionRenewalInterval(Long notificationSubscriptionRenewalInterval)
    {
        if (notificationSubscriptionRenewalInterval != null)
        {
            m_notificationSubscriptionRenewalInterval = notificationSubscriptionRenewalInterval.longValue();
        }
        else
        {
            m_notificationSubscriptionRenewalInterval = CommunicationConstants.NOTIFICATION_SUBSCRIPTION_RENEWAL_INTERVAL;
        }
    }

    Long getNotificationSubscriptionRenewalInterval()
    {
        return new Long(m_notificationSubscriptionRenewalInterval);
    }

    void addNotificationHandler(String notificationSource, INotificationHandler handler, String[] notificationTypes)
    {
        if (notificationTypes.length == 0)
        {
            throw new IllegalArgumentException();
        }

        String[] alreadySubscribedNotifications = null;

        // record the subscription locally
        synchronized(m_notificationSources)
        {
            HashMap handlers = (HashMap)m_notificationSources.get(notificationSource);
            if (handlers == null)
            {
                handlers = new HashMap();
                m_notificationSources.put(notificationSource, handlers);
            }
            else
            {
                alreadySubscribedNotifications = getSubscriptionNotifications(notificationSource);
            }

            handlers.put(handler, notificationTypes);

            // test if we need to create a first subscription or replace the existing subscription
            if (alreadySubscribedNotifications != null && notificationTypes != null && alreadySubscribedNotifications.length == notificationTypes.length)
            {
                // compare the two lists (order may not be the same) .. but if one exists in one list but not the other then we must renew the subscription
                // so the source is immediately updated
                boolean isMatch = false;
                for (int i = 0; i < notificationTypes.length; i++)
                {
                    isMatch = false;
                    for (int j = 0; j < alreadySubscribedNotifications.length; j++)
                    {
                        if (notificationTypes[i].equals(alreadySubscribedNotifications[j]))
                        {
                            isMatch = true;
                            break;
                        }
                    }
                    if (!isMatch)
                    {
                        break;
                    }
                }

                if (isMatch)
                {
                    // don't need to create/update the subscriptions
                    return;
                }
            }
        }

        // renew the subscription to create the subscription in the first place, or overwrite the existing subcription
        renewNotificationSubscriptions(notificationSource);

        // if we don't have a notification renewer, then we need to create one
        if (m_notificationSubscriptionRenewalThread == null)
        {
            m_notificationSubscriptionRenewalThread = new Thread(m_componentName.getComponentName() + " - Notification Subsciption Renewer")
            {
                @Override
                public void run()
                {
                    try
                    {
                        while (!(isInterrupted() || AbstractMBean.this.m_isClosing))
                        {
                            Thread.sleep(m_notificationSubscriptionRenewalInterval);

                            String[] sources = null;
                            synchronized(m_notificationSources)
                            {
                                sources = (String[])m_notificationSources.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
                            }
                            for (int i = 0; i < sources.length; i++)
                            {
                                if (isInterrupted() || AbstractMBean.this.m_isClosing)
                                {
                                    break;
                                }

                                renewNotificationSubscriptions(sources[i]);
                            }
                        }
                    }
                    catch(InterruptedException ie) { }
                    finally
                    {
                        m_notificationSubscriptionRenewalThread = null;
                    }
                }
            };
            m_notificationSubscriptionRenewalThread.setDaemon(true);
            m_notificationSubscriptionRenewalThread.start();
        }
    }

    private void renewNotificationSubscriptions(String notificationSource)
    {
        if (m_isClosing)
        {
            return;
        }
        String[] notificationTypes = getSubscriptionNotifications(notificationSource);

        if (DEBUG)
        {
            System.out.println((new Date(System.currentTimeMillis())).toString() + "AbstractMBean.renewNotificationSubscriptions: notificationSource=" + notificationSource + ", # types=" + notificationTypes.length);
        }

        try
        {
            if (m_isClosing)
            {
                return;
            }

            // test if the component is in the same container, but we can't renew a subscription on it because
            // the component has been unloaded (or was never loaded in the first place)
            CanonicalName canonicalName = new CanonicalName(notificationSource);
            if (isSameContainer(notificationSource) && !m_container.isHostingComponent(canonicalName.getComponentName()))
            {
                return;
            }

            if (m_isClosing)
            {
                return;
            }

            Long lastRenewal = (Long)m_lastHandlerRenewals.get(notificationSource);
            if (lastRenewal != null && lastRenewal.longValue() > System.currentTimeMillis() - 1000)
            {
                Thread.sleep(1000);
            }
            m_lastHandlerRenewals.put(notificationSource, new Long(System.currentTimeMillis()));

            // no reflection needed as only framework components should be making subscriptions
            Object[] params = new Object[] { m_componentName.getCanonicalName(), notificationTypes, m_notificationSubscriptionTimeout };
            invoke(notificationSource, HANDLE_NOTIFICATION_SUBSCRIPTION_METHOD_NAME, params, HANDLE_NOTIFICATION_SUBSCRIPTION_SIGNATURE, false, 0); // supply notification subscription timeout value...
        }
        catch(Exception e)
        {
            // from looking at "makeHandleNotificationSubscriptionInvocationAttempts, it doesn't appear as
            // though an exception will actually be thrown from that method - thus
            // it should be safe to simply log a trace message here if debug tracing is enabled...
            // Sonic00010504 - safety measure to ensure we don't throw a NPE
            int traceMask = m_traceMaskOnCleanup;
            try
            {
                traceMask = AbstractMBean.this.m_component.getTraceMask().intValue();
            }
            catch (NullPointerException npe) { }

            if ((traceMask & IComponent.TRACE_NOTIFICATIONS) > 0)
            {
                StringBuffer msg = new StringBuffer("Exception thrown while renewing subscription by " + this.m_componentName.getCanonicalName() + " to notification source = " + notificationSource);
                if ((traceMask & IComponent.TRACE_VERBOSE) > 0)
                {
                    msg.append(", for notificationTypes: ");
                    for (int i = 0; i < notificationTypes.length; i++)
                    {
                        msg.append(notificationTypes[i] + ", ");
                    }
                }
                logMessage(msg.toString(), e, Level.TRACE);
            }
        }
    }

    private String[] getSubscriptionNotifications(String notificationSource)
    {
        // a table to hold the aggregated set of notifications to subscribed to for all
        // the handlers of a given notification source
        HashSet subscriptionNotifications = new HashSet();

        // get all the notification handlers for the given notification source
        HashMap handlers = (HashMap)m_notificationSources.get(notificationSource);
        if (handlers != null) // else we will return no notification types
        {
            // iterate through the total list of notification types handled by all the handlers
            // to create the one aggregated list
            String[][] notificationTypes = (String[][])handlers.values().toArray(EMPTY_STRING_ARRAY_ARRAY);
            for (int i = 0; i < notificationTypes.length; i++)
            {
                for (int j = 0; j < notificationTypes[i].length; j++)
                {
                    subscriptionNotifications.add(notificationTypes[i][j]);
                }
            }
        }

        return (String[])subscriptionNotifications.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    void removeNotificationHandler(String notificationSource, INotificationHandler handler)
    {
        synchronized(m_notificationSources)
        {
            HashMap handlers = (HashMap)m_notificationSources.get(notificationSource);
            if (handlers != null)
            {
                String[] preNotificationTypes = getSubscriptionNotifications(notificationSource);
                handlers.remove(handler);
                String[] postNotificationTypes = getSubscriptionNotifications(notificationSource);

                boolean found = false; // will be set to true if we find some notification that still needs to be subscribed to
                for (int i = 0; i < preNotificationTypes.length; i++)
                {
                    found = false;
                    for (int j = 0; j < postNotificationTypes.length; j++)
                    {
                        if (preNotificationTypes[i].equals(postNotificationTypes[j]))
                        {
                            found = true;
                            break;
                        }
                    }
                    if (!found)
                    {
                        // update the subscription as soon as we can to stop unwanted notifications arriving
                        renewNotificationSubscriptions(notificationSource);
                        break;
                    }
                }

                // if there are no more handlers then we can remove the target
                if (handlers.isEmpty())
                {
                    m_notificationSources.remove(notificationSource);
                    m_lastHandlerRenewals.remove(notificationSource);
                }
            }

            if (m_notificationSources.isEmpty())
            {
                if (m_notificationSubscriptionRenewalThread != null)
                {
                    m_notificationSubscriptionRenewalThread.interrupt();
                }
            }
        }
    }

    //ASN: JP Morgan Scalability Enhancments...
    private long adjustExpirationTime(String target, String operationName, long expirationTime)
    {
        long adjustedExpirationTime = expirationTime;

        if (operationName.equalsIgnoreCase(ContainerImpl.GET_ATTRIBUTE_METHOD_NAME) || operationName.equalsIgnoreCase(ContainerImpl.GET_ATTRIBUTES_METHOD_NAME) ||
            operationName.equalsIgnoreCase(ContainerImpl.SET_ATTRIBUTE_METHOD_NAME) || operationName.equalsIgnoreCase(ContainerImpl.SET_ATTRIBUTES_METHOD_NAME))
        {
            // TBD: do we want to use some value other than that for notifications?
            adjustedExpirationTime = System.currentTimeMillis() + JMSConnectorServer.NOTIFICATION_TTL;
        }
        return adjustedExpirationTime;
    }

    Object invoke(String target, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout)
    throws Exception
    {
        Invoker invoker = null;

        // check for getAttribute, getAttributes, setAttribute, setAttribute invocations, and assign TTL if so...
        long expirationTime = 0;
        expirationTime = adjustExpirationTime( target, operationName, expirationTime);

        if (isSameContainer(target))
        {
            invoker = new LocalInvoker(target, operationName, params, signature, synchronous);
        }
        else
        {
            invoker = new RemoteInvoker(target, operationName, params, signature, synchronous, timeout);
        }

        if (synchronous)
        {
            invoker.run();
            if (invoker.exception != null)
            {
                throw invoker.exception;
            }
            return invoker.returnValue;
        }
        else
        {
            //scheduleTask(invoker, null, true);
            //ASN: JP Morgan scalability enhancment work...
            scheduleTask(invoker, null, true, expirationTime);
            return null;
        }
    }

    ICollectiveOpStatus invoke(final String[] targets, final String operationName, final Object[] params, final String[] signature, final boolean synchronous, final long timeout)
    throws Exception
    {
        long startTime = System.currentTimeMillis();
        
        final Hashtable results = synchronous ? new Hashtable(targets.length) : null;

        for (int i = 0; i < targets.length; i++)
        {
            final String target = targets[i];
            if (synchronous) // we need another thread
            {
                Runnable invoker = new Runnable()
                {
                    @Override
                    public void run()
                    {
                        Object rtnValue = null;
                        Exception e = null;
                        try
                        {
                            rtnValue = invoke(target, operationName, params, signature, synchronous, timeout);
                        }
                        catch(Exception ex)
                        {
                            rtnValue = null;
                            e = ex;
                        }
                        synchronized(results)
                        {
                            results.put(target, new Object[] { rtnValue, e });
                        
                            if (results.size() == targets.length)
                            {
                                results.notifyAll();
                            }
                        }
                    }
                };
                m_container.getTaskScheduler().scheduleTask(invoker, false);
            }
            else
            {
                // we don't need yet another thread to be used (since the asyn invoke will use its own thread
                invoke(target, operationName, params, signature, synchronous, timeout);
            }
        }

        if (!synchronous)
        {
            return null;
        }

        synchronized (results)
        {
            try
            {
                if (timeout <=0)
                {
                    while (results.size() < targets.length)
                    {
                        results.wait();
                    }
                }
                else
                {
                    long waitTime = timeout - (System.currentTimeMillis() - startTime);
                    while (waitTime > 0 && results.size() < targets.length)
                    {
                        results.wait(waitTime);
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
            }
            catch (InterruptedException ie)
            {
            }
            // loop through the results and if there are any missing then add them with a timeout exception
            for (int i = 0; i < targets.length; i++)
            {
                Object result = results.get(targets[i]);
                if (result == null)
                {
                    results.put(targets[i], new Object[]
                    { null, new InvokeTimeoutException("Request timeout.") });
                }
            }
        }
        // now build a collective results set
        Object[] entries = results.entrySet().toArray();
        CollectiveOpStatus collectiveOpStatus = new CollectiveOpStatus(entries.length);
        for (int i = 0; i < entries.length; i++)
        {
            Map.Entry entry = (Map.Entry)entries[i];
            Object[] result = (Object[])entry.getValue();

            collectiveOpStatus.addResult((String)entry.getKey(), result[0], (Throwable)result[1]);
        }
        return collectiveOpStatus;
    }

    //ASN: JP Morgan scalability enhancment work...
    void scheduleTask(Runnable task, Date startTime, boolean usePooledThread)
    {
        scheduleTask(task, startTime, usePooledThread, (long)0);
    }

    void scheduleTask(Runnable task, Date startTime, boolean usePooledThread, long expirationTime)
    {
        // if no start time is given then execute immeditately
        if (startTime == null || startTime.getTime() <= System.currentTimeMillis())
        {
            if (usePooledThread)
            {
                ITaskScheduler taskScheduler = m_container.getTaskScheduler();
                //taskScheduler.scheduleTask(task, false);
                //ASN: JP Morgan scalability enhancment work...
                taskScheduler.scheduleTask(task, false, expirationTime);
            }
            else
            {
                new Thread(task, m_taskThreadName).start();
            }
        }
        else
        {
            if (m_commonTimer == null)
            {
                m_commonTimer = m_container.getTimer();
            }

            TimerTaskDelegate timerTask = new TimerTaskDelegate(task, usePooledThread);
            m_scheduledTasks.put(task, timerTask);
            m_commonTimer.schedule(timerTask, startTime);
        }
    }

    void cancelTask(Runnable task)
    {
        if ((m_commonTimer == null) || (task == null))
        {
            return;
        }

        TimerTaskDelegate timerTask = (TimerTaskDelegate)m_scheduledTasks.remove(task);
        if (timerTask == null)
        {
            return;
        }

        timerTask.clearTask();
    }

    private boolean isSameContainer(String target)
    {
        CanonicalName canonicalName = new CanonicalName(target);

        // different domain ?
        if (!canonicalName.getDomainName().equals(m_componentName.getDomainName()))
        {
            return false;
        }

        // same container ?
        if (canonicalName.getContainerName().equals(m_componentName.getContainerName()))
        {
            return true;
        }

        // is the target a singleton component that resides in the same container and hence its
        // container name will be different ?
        if (canonicalName.getContainerName().equals(canonicalName.getComponentName()))
        {
            if (m_container.isHostingComponent(canonicalName.getComponentName()))
            {
                // now check if this is an active fault tolerant component (e.g. DS or AM)
                try
                {
                    CanonicalName localName = new CanonicalName(m_componentName.getDomainName(), m_componentName.getContainerName(), canonicalName.getComponentName());
                    Object[] values = (Object[])invoke(localName.getCanonicalName(), "getAttributeValues", GET_FT_STATE_ATTR_PARAMS, GET_ATTRIBUTE_VALUES_SIGNATURE, true, 0);
                    Short status = (Short)values[0];

                    // check if the component doesn't have a fault tolerant attribute - if so we can call the local component
                    if (status == null)
                    {
                        return true;
                    }
                    // check if the component is not FT or is active - if so we can call the local component
                    if (status.shortValue() == IFaultTolerantState.STATE_NOT_FAULT_TOLERANT || status.shortValue() == IFaultTolerantState.STATE_ACTIVE)
                    {
                        return true;
                    }
                }
                catch(Exception e)
                {
                    // if we get an exception, we should assume its because the operation is unknown and we should just try
                    // the local object
                    return true;
                }
                return false;
            }
        }

        return false;
    }


    private abstract class Invoker
    implements Runnable
    {
        String target;
        String operationName;
        Object[] params;
        String[] signature;
        boolean synchronous;

        Object returnValue;
        Exception exception;

        Invoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous)
        {
            this.target = target;
            this.operationName = operationName;
            this.params = params;
            this.signature = signature;
            this.synchronous = synchronous;
        }
        
        @Override
        public String toString()
        {
        	StringBuffer sb = new StringBuffer();
        	sb.append(super.toString());
        	sb.append(" (operation: ").append(operationName);
        	sb.append(", target: ").append(target).append(')');
        	return sb.toString();
        }
    }

    private class LocalInvoker
    extends Invoker
    {
        private LocalInvoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous)
        {
            super(target, operationName, params, signature, synchronous);
        }

        @Override
        public void run()
        {
            try
            {
                // if were closing don't make any further remote call (unless its an internal notification send)
                if (AbstractMBean.this.m_isClosing && !operationName.equals("handleNotification"))
                {
                    return;
                }
                if (AbstractMBean.this.m_isDifferentClassLoader)
                {
                    super.params = (Object[])ContainerUtil.transferObject(params, AbstractMBean.this.m_container.m_defaultClassLoader);
                }
                if (AbstractMBean.this.m_isClosing && !operationName.equals("handleNotification"))
                {
                    return;
                }
                super.returnValue = AbstractMBean.this.m_container.invokeLocal(super.target, super.operationName, super.params, super.signature);
                if (AbstractMBean.this.m_isClosing)
                {
                    return;
                }
                if (AbstractMBean.this.m_isDifferentClassLoader)
                {
                    super.returnValue = ContainerUtil.transferObject(super.returnValue, AbstractMBean.this.m_componentClassLoader);
                }
            }
            catch(Exception e)
            {
                if (AbstractMBean.this.m_isClosing || AbstractMBean.this.m_container.isClosing())
                {
                    return;
                }
                if (this.synchronous)
                {
                    super.exception = e;
                }
                else
                {
                    if ((AbstractMBean.this.m_container.m_agent.getTraceMask().intValue() & IConnectorClient.TRACE_REQUEST_REPLY_FAILURES) > 0)
                    {
                        AbstractMBean.this.logMessage("Failed to invoke [" + operationName + "] on " + super.target + ", trace follows...", e, Level.TRACE);
                    }
                    else
                    {
                        AbstractMBean.this.logMessage("Failed to invoke [" + operationName + "] on " + super.target, Level.WARNING);
                    }
                }
            }
        }
    }

    private class RemoteInvoker
    extends Invoker
    {
        long timeout;

        private RemoteInvoker(String target, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout)
        {
            super(target, operationName, params, signature, synchronous);
            this.timeout = timeout;
        }

        @Override
        public void run()
        {
            try
            {
                // if were closing don't make any further remote call (unless its an internal notification send)
                if (AbstractMBean.this.m_isClosing && !operationName.equals("handleNotification"))
                {
                    return;
                }
                super.returnValue = m_container.invokeRemote(super.target, super.operationName, super.params, super.signature, this.timeout, super.synchronous);
            }
            catch(Exception e)
            {
                if (AbstractMBean.this.m_isClosing || AbstractMBean.this.m_container.isClosing())
                {
                    return;
                }
                if (this.synchronous)
                {
                    this.exception = e;
                }
                else
                {
                    if (e.getClass().getName().equals(InvokeTimeoutException.class.getName()) ||
                        (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getName().equals(InvokeTimeoutException.class.getName())))
                    {
                        AbstractMBean.this.logMessage("Timeout while invoking [" + super.operationName + "] on " + super.target, Level.WARNING);
                    }
                    else
                    if (e.getClass().getName().equals(InvokeTimeoutCommsException.class.getName()) ||
                        (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getName().equals(InvokeTimeoutCommsException.class.getName())))
                    {
                        if ((AbstractMBean.this.m_container.m_agent.getTraceMask().intValue() & IConnectorClient.TRACE_REQUEST_REPLY_FAILURES) > 0)
                        {
                            AbstractMBean.this.logMessage("Existing connection failure caused: timeout while invoking [" + super.operationName + "] on " + super.target, Level.TRACE);
                        }
                    }
                    else
                    if ((AbstractMBean.this.m_container.m_agent.getTraceMask().intValue() & IConnectorClient.TRACE_REQUEST_REPLY_FAILURES) > 0)
                    {
                        AbstractMBean.this.logMessage("Failed to invoke [" + super.operationName + "] on " + super.target + ", trace follows...", e, Level.TRACE);
                    }
                    else
                    {
                        AbstractMBean.this.logMessage("Failed to invoke [" + super.operationName + "] on " + super.target, Level.WARNING);
                    }
                }
            }
        }
    }

    private class TimerTaskDelegate
    extends TimerTask
    {
        Runnable task;
        private boolean usePooledThread;

        private TimerTaskDelegate(Runnable task, boolean usePooledThread)
        {
            this.task = task;
            this.usePooledThread = usePooledThread;
        }

        @Override
        public void run()
        {
            // has the task been cancelled ?
            Runnable task = null;
            synchronized(this)
            {
                if (this.task == null)
                {
                    return;
                }
                task = this.task;
            }

            if (AbstractMBean.this.m_isClosing)
            {
                return;
            }

            if (this.usePooledThread)
            {
                // should only happen for framework components (hence no reflection needed)
                AbstractMBean.this.m_container.getTaskScheduler().scheduleTask(task, false);
            }
            else
            {
                new Thread(task, m_timerTaskThreadName).start();
            }

            AbstractMBean.this.m_scheduledTasks.remove(task);
            this.clearTask();
        }

        public void clearTask()
        {
            synchronized(this)
            {
                this.task = null;
            }
        }
    }
}
