package com.sonicsw.mf.framework.agent;

import java.util.Hashtable;

import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.Sorter;

import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;

public class AgentCLI
extends com.sonicsw.mx.util.CLI
{
    private static volatile Agent m_agent;
    
    static
    {
        // override the parent class object
        m_cliClassObject = com.sonicsw.mf.framework.agent.AgentCLI.class;
        try
        {
            addCommand("shutdown",
                       m_cliClassObject.getDeclaredMethod("shutdown", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("shutdownHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("restart",
                       m_cliClassObject.getDeclaredMethod("restart", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("restartHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("reload",
                       m_cliClassObject.getDeclaredMethod("reloadComponent", new Class[] {String.class}),
                       m_cliClassObject.getDeclaredMethod("reloadComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("start",
                       m_cliClassObject.getDeclaredMethod("startComponent", new Class[] {String.class}),
                       m_cliClassObject.getDeclaredMethod("startComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("stop",
                       m_cliClassObject.getDeclaredMethod("stopComponent", new Class[] {String.class}),
                       m_cliClassObject.getDeclaredMethod("stopComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("clearError",
                       m_cliClassObject.getDeclaredMethod("clearError", new Class[] {String.class}),
                       m_cliClassObject.getDeclaredMethod("clearErrorHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("resume logging",
                       m_cliClassObject.getDeclaredMethod("resumeLogging", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("resumeLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("pause logging",
                       m_cliClassObject.getDeclaredMethod("pauseLogging", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("pauseLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand(">",
                       m_cliClassObject.getDeclaredMethod("resumeLogging", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("resumeLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("<",
                       m_cliClassObject.getDeclaredMethod("pauseLogging", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("pauseLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("show status",
                       m_cliClassObject.getDeclaredMethod("showStatus", IEmptyArray.EMPTY_CLASS_ARRAY),
                       m_cliClassObject.getDeclaredMethod("showStatusHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            addCommand("ping",
                       m_cliClassObject.getDeclaredMethod("ping", new Class[] {String.class, String.class}),
                       m_cliClassObject.getDeclaredMethod("pingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
        }
        catch(NoSuchMethodException e) { e.printStackTrace(); } // should not happen !
    }

    public static void init(Agent agent) throws NoSuchMethodException
    {
        m_agent = agent;
        setPrompt(m_agent.getContainerName() + DEFAULT_PROMPT);
    }

    public static String shutdown()
    {
        // disable the prompt now
        SHOW_PROMPT = false;
        m_agent.shutdown();
        return null;
    }

    public static String shutdownHelp()
    {
        return AgentStrings.m_shutdownHelp;
    }

    public static String restart()
    throws Exception
    {
        // disable the prompt now
        SHOW_PROMPT = false;
        m_agent.restart();
        return null;
    }

    public static String restartHelp()
    {
        return AgentStrings.m_restartHelp;
    }

    public static String reloadComponent(String ID)
                throws Exception
    {
        if (ID == null || ID.length() == 0)
        {
            return reloadComponentHelp();
        }

        m_agent.reloadComponent(ID);
        return null;
    }

    public static String reloadComponentHelp()
    {
        return AgentStrings.m_reloadComponentHelp;
    }

    public static String resumeLogging()
    {
        m_agent.setLogToConsole(Boolean.TRUE);
        return null;
    }

    public static String resumeLoggingHelp()
    {
        return AgentStrings.m_resumeLoggingHelp;
    }

    public static String pauseLogging()
    {
        m_agent.setLogToConsole(Boolean.FALSE);
        return null;
    }

    public static String pauseLoggingHelp()
    {
        return AgentStrings.m_pauseLoggingHelp;
    }

    public static String showStatus()
    throws Exception
    {
        String fullStatusString = "";
        int largestName = 0;
        Hashtable statusStrings = new Hashtable(20);
        String[] componentNames;
        
        IComponentState[] components = m_agent.getContainerState().getComponentStates();
        componentNames = new String[components.length];
        for (int i=0; i<components.length; i++)
        {
            IComponentIdentity identity = (IComponentIdentity)components[i].getRuntimeIdentity();
            try
            {
                Object[] attributeValues = m_agent.getAttributeValues(identity.getCanonicalName(), new String[] { "ConfigID", "StateString", "LastErrorLevelString", "Uptime" }); 
                String componentName = identity.getComponentName();
                StringBuffer statusString = new StringBuffer();
                statusString.append('[');
                statusString.append(attributeValues[0]);
                statusString.append(", ");
                statusString.append(attributeValues[1]);
                statusString.append(", ");
                statusString.append(attributeValues[2]);
                statusString.append(", ");
                statusString.append(formatUptimeString(((Long)attributeValues[3]).longValue()));
                statusString.append(']');
                statusStrings.put(componentName, statusString);
                statusStrings.put(componentName, statusString.toString());
                componentNames[i] = componentName;
                if (componentName.length() > largestName)
                {
                    largestName = componentName.length();
                }
            }
            catch (Exception e)
            {
                System.out.println("Problem with " + identity.getCanonicalName());
                e.printStackTrace();
            }
        }
        Object[] cNames = Sorter.sort(componentNames);
        for (int index = 0; index < cNames.length; index++)
        {
            String cName = ((String)componentNames[index]);
            fullStatusString = fullStatusString + cName;
            for (int spacing=largestName + 1; spacing > cName.length(); spacing--)
            {
                fullStatusString= fullStatusString + " ";
            }
            fullStatusString = fullStatusString + (String)(statusStrings.get(componentNames[index]));
            if (index < (cNames.length - 1))
            {
                fullStatusString = fullStatusString + "\n";
            }
        }
        return fullStatusString;
    }

    public static String showStatusHelp()
    {
        return AgentStrings.m_showStatusHelp;
    }

    public static String ping(String containerName, String timeoutString)
    {
        if (containerName == null || containerName.length() == 0)
        {
            return pingHelp();
        }

        long timeout = 0;
        if (timeoutString != null && timeoutString.length() > 0)
        {
            try
            {
                timeout = Long.parseLong(timeoutString) * 1000;
                if (timeout <= 0)
                {
                    return pingHelp();
                }
            }
            catch(Exception e)
            {
                return pingHelp();
            }
        }
        return m_agent.remotePing(containerName, timeout);
    }

    public static String pingHelp()
    {
        return AgentStrings.m_pingHelp;
    }

    public static String startComponent(String ID)
    throws Exception
    {
        if (ID == null || ID.length() == 0)
        {
            return startComponentHelp();
        }
        m_agent.startComponent(ID);
        return null;
    }

    public static String startComponentHelp()
    {
        return AgentStrings.m_startComponentHelp;
    }

    public static String stopComponent(String ID)
    throws Exception
    {
        if (ID == null || ID.length() == 0)
        {
            return stopComponentHelp();
        }

        m_agent.stopComponent(ID);
        return null;
    }

    public static String stopComponentHelp()
    {
        return AgentStrings.m_stopComponentHelp;
    }

    public static String clearError(String ID)
    throws Exception
    {
        if (ID == null || ID.length() == 0)
        {
            return clearErrorHelp();
        }

        m_agent.clearError(ID);
        return null;
    }

    public static String clearErrorHelp()
    {
        return AgentStrings.m_clearErrorHelp;
    }


    private static String formatUptimeString(long milli)
    {
        String uptime = "";
        int hours = (int)(milli / 3600000);
        if (hours < 10)
        {
            uptime = uptime + "0" + hours;
        }
        else
        {
            uptime = uptime + hours;
        }
        uptime = uptime + ":";
        int minutes = (int)(milli % 3600000) / 60000;
        if (minutes < 10)
        {
            uptime = uptime + "0" + minutes;
        }
        else
        {
            uptime = uptime + minutes;
        }
        uptime = uptime + ":";
        int seconds = ((int)(milli % 3600000) % 60000) / 1000;
        if (seconds < 10)
        {
            uptime = uptime + "0" + seconds;
        }
        else
        {
            uptime = uptime + seconds;
        }
        return uptime;
    }
}
