// Copyright (c) 2009 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.framework.agent;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import com.sonicsw.mf.framework.IMessageLogger;

class ConsoleLogger implements IMessageLogger
{
    // certain notifications need to come from the Agent so well keep a handle to it
    private Agent m_agent;
    private Writer m_writer;
    private final OutputStream m_delegate;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    ConsoleLogger(Agent agent, OutputStream outputStream)
    {
        m_agent = agent;
        m_delegate = outputStream;
        createLogWriter(outputStream);
    }

    @Override
    public void logMessage(String logMessage)
    {
        synchronized (m_delegate)
        {
            try
            {
                logMessage += LINE_SEPARATOR;
                m_writer.write(logMessage);
                m_writer.flush();
            } catch(IOException ex) { } // should not happen
        }
    }

    private void createLogWriter(OutputStream outputStream)
    {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream);
        m_writer = new BufferedWriter(osw);
    }

    // these two methods are for support of components that are using unsupported
    // writes to stdout/stderr rather than logMessage()
    void write(int b)
    {
        synchronized (m_delegate)
        {
            try
            {
                m_writer.write(b);
                m_writer.flush();
            } catch(IOException e) { }
        }
    }
    void write(byte[] b, int off, int len)
    {
        synchronized (m_delegate)
        {
            try
            {
                for (int i = off; i < off + len; i++)
                {
                    m_writer.write(b[i]);
                }
                m_writer.flush();
            } catch(IOException e) { }
        }
    }
}
