package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.IContainer;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class ContainerFTStateListener  implements IStateListener {
    private ContainerImpl m_containerImpl;
    public ContainerFTStateListener(ContainerImpl containerImpl) {
        m_containerImpl = containerImpl;
    }

    @Override
    public void stateChanging(short currentState, short intendedState)
    {

    }

    @Override
    public void stateChanged(short previousState, short currentState)
    {
        switch (previousState)
        {
            case IFaultTolerantState.STATE_WAITING:
            {
                switch (currentState)
                {
                    case IFaultTolerantState.STATE_ACTIVE:
                    case IFaultTolerantState.STATE_STANDBY:
                    {
                        IContainer container = ContainerImpl.getContainer();
                        container.logMessage(null, "Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.INFO);
                        break;
                    }
                }
                break;
            }
            case IFaultTolerantState.STATE_STANDBY:
            {
                switch (currentState)
                {
                    case IFaultTolerantState.STATE_ACTIVE:
                    {
                        IContainer container = ContainerImpl.getContainer();
                        container.logMessage(null, "Failover to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.WARNING);
                        m_containerImpl.sendFailoverNotification();
                        break;
                    }
                    case IFaultTolerantState.STATE_WAITING:
                    {
                        IContainer container = ContainerImpl.getContainer();
                        container.logMessage(null, "Revert to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.WARNING);
                        break;
                    }
                }
                break;
            }
            case IFaultTolerantState.STATE_ACTIVE:
            {
                switch (currentState)
                {
                    case IFaultTolerantState.STATE_WAITING:
                    case IFaultTolerantState.STATE_STANDBY:
                    {
                        IContainer container = ContainerImpl.getContainer();
                        container.logMessage(null, "Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.INFO);
                        break;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void stateChangeFailed(short currentState, short intendedState)
    {
        IContainer container = ContainerImpl.getContainer();
        container.logMessage(null, "Failed to change from " + IFaultTolerantState.STATE_TEXT[currentState] + " to " + IFaultTolerantState.STATE_TEXT[intendedState], Level.WARNING);
    }

}