package com.sonicsw.mf.framework.agent;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Timer;

import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.loading.MLet;
import javax.naming.Context;

import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.ServiceMaintainer;
import com.sonicsw.mx.util.ServiceMaintenance;
import com.sonicsw.mf.comm.CommunicationConstants;
import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IEnterpriseAware;
import com.sonicsw.mf.common.runtime.IEnterpriseStateAccess;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.util.LockFile;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IConnectorServer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponent;
import com.sonicsw.mf.framework.IGlobalFrameworkComponent;
import com.sonicsw.mf.framework.IMessageLogger;
import com.sonicsw.mf.framework.INotificationPublisher;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.agent.cache.CacheClosedException;
import com.sonicsw.mf.framework.agent.cache.CacheException;
import com.sonicsw.mf.framework.agent.cache.ConfigCacheFactory;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.OutOfPersistentSpaceException;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.framework.directory.IDirectoryMFService;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.interceptor.actional.soniclog.SonicLogInterceptor;
import com.sonicsw.mf.jmx.client.JMSConstants;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.IDirectoryServiceProxy;

import progress.message.client.EUserAlreadyConnected;

public final class ContainerImpl
    implements com.sonicsw.mf.comm.IConnectionListener, com.sonicsw.sdf.IShutdown {
    private static final boolean DEBUG = false;

    MBeanServer m_mbeanServer;

    private Class m_mbeanServerClass;

    private IConsumer m_connectorHandback;

    // a table of JMX client notification listeners to delegates
    private HashMap m_notificationListeners = new HashMap();

    private static ContainerImpl m_container;

    private static IContainer m_containerDelegate;

    private HashSet m_sharedClasses;

    private IDirElement m_containerConfig;

    private IConfigCache m_configCache;

    private IConfigCacheView m_configCacheView;

    private String m_sonicArchiveSearchPath;

    private RuntimeConfigurationManager m_runtimeConfigurationManager;

    private IContainerIdentity m_containerIdentity;

    private JMSConnectorServer m_connector;

    private InternalRequestHandler m_internalRequestHandler = new InternalRequestHandler();

    private HashSet m_storageNames = new HashSet();

    private boolean m_generateCache; // true when run to generate cache (cache generation utility or a deployed
                                     // container from central connection)

    private boolean m_generateCacheUtil; // true when run from cache generation utility

    private boolean m_configureFromCache;

    private String m_directConnectionURL = "localhost";

    private String m_directConnectionUser = "";

    private String m_directConnectionPassword = ""; // NOSONAR field change is not required.

    private Thread m_designatedReconcileThread = null;

    private Object m_reconcileLock = new Object();

    private Object m_reportingChangeLock = new Object();

    private boolean m_dsNotInitiallyAccessible;

    private boolean m_useLocalCacheLogged = false;

    private ServiceMaintainer m_dsMonitor;

    private ServiceMaintainer m_dsTemporaryMonitor;

    private Object m_dsTemporaryMonitorLock = new Object();

    private long m_lastTimeWeSubscribed = 0;

    private long m_dsPingFrequency = IContainerConstants.DIRECTORY_SERVICE_PING_INTERVAL_DEFAULT * 60000;

    private boolean m_recentReconcileSucessful = false;

    private Random m_random;

    private long m_startTimestamp;

    URLClassLoader m_defaultClassLoader;

    // certain notifications need to come from the Agent so well keep a handle to it
    Agent m_agent;

    AbstractMBean m_agentMBean; // SNC00078102: used by logMessage() to determine whether the Agent is (still) available
                                // - less risky change than nulling m_agent when the Agent is torn down

    LocalFileManager m_fileManager;

    // Directory Service proxy
    private ContainerDS m_directory;

    private HostManager m_hostManager;

    private boolean m_isBooted = false;

    private boolean m_isLoading = false;

    private boolean m_isUnloading = false;

    private boolean m_isClosing = false;

    private boolean m_isOutOfMemory = false;

    private Hashtable m_mBeans = new Hashtable();

    private ArrayList m_reloadingIDs = new ArrayList();

    private HashMap m_reloadingDetails = new HashMap();

    private TaskScheduler m_taskScheduler = new TaskScheduler(this);

    private NotificationPublisher m_notificationPublisher = new NotificationPublisher(this);

    private NotificationListenerExpirer m_notificationListenerExpirer = new NotificationListenerExpirer();

    private Monitor m_abortMonitor; // QA way to force halt of VM

    private Timer m_timer = new Timer(true);

    private ArrayList m_listOfLoggers = new ArrayList(0);

    private boolean m_isLoggingStarted = false;

    private String m_tempLogBuffer = "";

    private String m_managementNode;

    private HashSet m_storedLibraries = new HashSet();

    private ExternalRequestHandler m_externalRequestHandler;

    private volatile boolean m_isFailingOver = false;

    private boolean m_allowFailover = true;

    private boolean m_skippedDSReconciliation = false;

    private com.sonicsw.sdf.IDiagnosticsManager m_diagnosticsManager = null;

    private ArrayList m_pendingLogMessageQueue = new ArrayList();

    private LockFile m_containerRunningLockFile = null;

    //
    // Constants
    //
    private static final String ADD_NOTIFICATION_LISTENER_METHOD_NAME = "addNotificationListener";

    private static final String REMOVE_NOTIFICATION_LISTENER_METHOD_NAME = "removeNotificationListener";

    private static final String HANDLE_NOTIFICATION_METHOD_NAME = "handleNotification";

    private static final String EXTERNAL_NOTIFICATION_SUBSCRIPTIONS = "externalNotificationSubscriptions";

    private static final String INTERNAL_NOTIFICATION_SUBSCRIPTIONS = "internalNotificationSubscriptions";

    static final String GET_ATTRIBUTE_METHOD_NAME = "getAttribute";

    static final String GET_ATTRIBUTES_METHOD_NAME = "getAttributes";

    static final String SET_ATTRIBUTE_METHOD_NAME = "setAttribute";

    static final String SET_ATTRIBUTES_METHOD_NAME = "setAttributes";

    public static final String RESTART_MESSAGE = "Restart initiated";

    public static final String SHUTDOWN_MESSAGE = "Shutdown initiated";

    private static final String DEFAULT_CONNECTION_URLS = "tcp://localhost:2506";

    private static final long MIN_DS_PING_FREQUENCY = 900000; // 15 minutes

    private static final long MAX_DS_PING_FREQUENCY = 9000000; // 150 minutes

    private static final long MAX_TEMP_DS_PING_FREQUENCY = 60000; // 1 minute (temp DS monitor)

    private ContainerExitCode m_containerExitCode = null;

    private ContainerFT m_containerFT;

    private boolean m_isFTContainer;

    // Keep a handle on the JVM's raw stderr stream so we can write OOM exception info' there if memory gets so tight
    // that Sonic logging breaks down
    private static final PrintStream s_errDirect = new PrintStream(new FileOutputStream(java.io.FileDescriptor.err));

    private static final boolean m_isLSD = Boolean.getBoolean(IContainer.MF_LSD_COLOCATE_PROPERTY); // is this container
                                                                                                    // running as part
                                                                                                    // of LSD container
                                                                                                    // collocation

    private static final long SHUTDOWN_PAUSE = 2000; // 2 secs pause before shutdown
    static {
        // redirect stdout/stderr
        if (!m_isLSD) {
            Agent.redirectOutput();
        }
    }

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID)
    throws Exception {
        this(containerClassLoader, cacheDirectory, containerName, containerConfigID, new Long(0), new ContainerExitCode());
    }

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID,
                         Long maxCacheSize)
    throws Exception {
        this(containerClassLoader, cacheDirectory, containerName, containerConfigID, maxCacheSize, new ContainerExitCode());
    }

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID,
                         Long maxCacheSize, Object containerExitCode)
    throws Exception {
        if (!m_isLSD) {
            m_containerRunningLockFile = new LockFile(IContainer.CONTAINER_RUNNING_LOCK_FILE);
            if (!m_containerRunningLockFile.lock()) {
                throw new Exception("Container is already running in \"" + System.getProperty("user.dir") + "\"");
            }

            createStartTimestamp();
        }
        m_configureFromCache = Boolean.getBoolean(IContainer.CONFIGURE_FROM_CACHE_PROPERTY);

        // Initialize and start the DiagnosticsManager
        m_diagnosticsManager = com.sonicsw.sdf.DiagnosticsManagerAccess.createManager();
        m_diagnosticsManager.setContainerName(containerName);
        m_diagnosticsManager.setShutdownInterface(this);

        // Sets cache generation parameters
        m_containerExitCode = (ContainerExitCode)containerExitCode;
        m_directConnectionURL = System.getProperty(IContainer.CACHE_GENERATION_URL_PROPERTY);
        m_generateCacheUtil = m_directConnectionURL != null;
        m_generateCache = m_generateCacheUtil || Boolean.getBoolean(IContainer.GENERATE_CACHE_FROM_CENTRAL_CONNECTION_PROPERTY);
        m_directConnectionUser = System.getProperty(IContainer.CACHE_GENERATION_USER_PROPERTY);
        if (m_directConnectionUser == null) {
            m_directConnectionUser = "";
        }
        m_directConnectionPassword = System.getProperty(IContainer.CACHE_GENERATION_PASSWORD_PROPERTY);
        if (m_directConnectionPassword == null) {
            m_directConnectionPassword = ""; // NOSONAR field change is not required.
        }

        NotificationListenerDelegate.setContainerImpl(this);

        try {
            m_container = this;
            m_containerDelegate = new Delegate();
            m_defaultClassLoader = (URLClassLoader)containerClassLoader;

            // start the task scheduler
            m_taskScheduler.start();

            // start the notification publisher and notification listener expirer threads
            m_notificationPublisher.start();
            m_notificationListenerExpirer.start();

            // open the cache
            String password = ContainerUtil.retrieveCachePassword(new File(cacheDirectory), true);
            m_configCache = ConfigCacheFactory.createCache(cacheDirectory, password, (maxCacheSize == null) ? 0 : maxCacheSize.longValue());
            m_configCache.clearNativeLibraryDirectory();
            m_configCacheView = m_configCache.getCacheView();

            // main container boot sequence
            bootFramework(containerConfigID);
        } catch (OutOfMemoryError e) {
            // if some terminal condition was detected during startup, then shutdown would have been initiated
            // and m_isClosing will be true .. so we can simply return
            if (m_isClosing) {
                return;
            }
            throw e;
        } catch (ShutdownInProgressException e) {
            // we use this to programmatically indicate that the boot process is being aborted due to a shutdown
            // being initiated during the startup
            if (m_isClosing) {
                return;
            }
            throw e;
        }
    }

    // com.sonicsw.sdf.IShutdown implementation
    @Override
    public void shutdownCallback(long callerID) {
        if (m_startTimestamp != 0 && callerID == m_startTimestamp) {
            shutdown(IContainerExitCodes.NORMAL_SHUTDOWN_EXIT_CODE);
        }
    }

    private void createStartTimestamp() {
        m_startTimestamp = System.currentTimeMillis();
        File timestampFile = new File(IContainer.START_TIMESTAMP_FILE);
        try {
            timestampFile.delete();
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(timestampFile, false)), true);
            writer.println(m_startTimestamp);
            writer.close();
        } catch (IOException e) {
            logMessage(null, "Could not create file " + timestampFile.getAbsolutePath(), e, Level.WARNING);
        }
    }

    //
    // IConnectionListener implementation
    //

    /**
     * The container's management connection has been restored - we want to touch bases with the DS
     */
    @Override
    public void onReconnect(String localRoutingNode) {
        validateConnectorNodeName(localRoutingNode);

        exhaustPendingLogMessageQueue(); // centralized logging catchup

        if (m_isBooted) // if not then an explicit reconcile will be performed as part of cache creation
        {
            Runnable reconciler = new Runnable() {
                @Override
                public void run() {
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    // internal invocations are treated as though executed by the super-user ID
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(IManagementPermission.SUPER_USER_NAME);
                    ContainerImpl.this.reconcileCache();
                }
            };
            m_taskScheduler.scheduleTask(reconciler, false);
        }

        // If this container uses this containers management connection as the fault detection connection,
        // then let the container FT logic know to allow it to reset
        if (m_containerFT != null) {
            m_containerFT.onReconnect();
        }
    }

    @Override
    public void onDisconnect() {
        if (m_containerFT != null) {
            m_containerFT.onDisconnect();
        }
    }

    @Override
    public void onFailure(Exception e) {
        if (m_containerFT != null) {
            m_containerFT.onFailure(e);
        }
    }

    //
    // end of IConnectionListener implementation
    //

    // Executes diagnostics instructions
    public String diagnose(String instructions) {
        if (m_diagnosticsManager != null) {
            return m_diagnosticsManager.executeDiagnosticsInstructions(instructions);
        } else {
            return ("The Sonic Diagnostics Framework is not available");
        }
    }

    static IContainer getContainer() {
        return m_containerDelegate;
    }

    void addMessageLogger(IMessageLogger logger) {
        m_listOfLoggers.add(logger);
    }

    void removeMessageLogger(IMessageLogger logger) {
        m_listOfLoggers.remove(logger);
    }

    void setDSPingFrequency(Integer minutes) {
        if (minutes == null) {
            minutes = new Integer(IContainerConstants.DIRECTORY_SERVICE_PING_INTERVAL_DEFAULT);
        }

        m_dsPingFrequency = minutes.intValue() * 60000;

        if (m_dsPingFrequency < MIN_DS_PING_FREQUENCY) {
            m_dsPingFrequency = MIN_DS_PING_FREQUENCY;
        } else if (m_dsPingFrequency > MAX_DS_PING_FREQUENCY) {
            m_dsPingFrequency = MAX_DS_PING_FREQUENCY;
        }
    }

    String remotePing(String containerName, String pingMessage, long timeout) throws Exception {
        String canonicalName = new CanonicalName(m_containerIdentity.getDomainName(), containerName, IAgentProxy.ID).getCanonicalName();
        return (String)m_connector.invoke(IContainer.INTERNAL_COMMS_TYPE, canonicalName, canonicalName, "ping",
                                          new Object[] { pingMessage }, new String[] { String.class.getName() }, timeout);
    }

    boolean loadConfiguredComponent(String id, IAttributeSet componentAttrs, boolean isExtension, boolean frameworkOnly) {
        String configID = isExtension ? ((Reference)componentAttrs.getAttribute(IContainerConstants.EXTENSION_CONFIG_REF_ATTR)).getElementName()
                                     : ((Reference)componentAttrs.getAttribute(IContainerConstants.CONFIG_REF_ATTR)).getElementName();

        Boolean isAutoStart = null;
        if (m_generateCache) {
            // if we are in cache generating mode we don't need to start the component
            isAutoStart = Boolean.FALSE;
        } else {
            if (isExtension) {
                isAutoStart = Boolean.TRUE;
            } else {
                isAutoStart = (Boolean)componentAttrs.getAttribute(IContainerConstants.AUTO_START_ATTR);
            }
            if (isAutoStart == null) {
                isAutoStart = new Boolean(IContainerConstants.AUTO_START_DEFAULT);
            }
        }

        Integer traceMask = null;
        if (isExtension) {
            traceMask = new Integer(-1);
        } else {
            traceMask = (Integer)componentAttrs.getAttribute(IContainerConstants.TRACE_MASK_ATTR);
        }
        if (traceMask == null) {
            traceMask = new Integer(IContainerConstants.TRACE_MASK_DEFAULT);
        }

        try {
            // if there are any native libraries defined, store them in the libX directory
            AttributeSet librariesAttrs = (AttributeSet)componentAttrs.getAttribute(IContainerConstants.NATIVE_LIBRARIES_ATTR);
            if (librariesAttrs != null) {
                writeLibraries(librariesAttrs);
            }

            // load the component
            return (loadComponent(id, configID, isAutoStart.booleanValue(), traceMask.intValue(), frameworkOnly) != null);
        } catch (OutOfMemoryError e) {
            throw e;
        } catch (Throwable e) {
            // the problem will have already been reported, so all we need to do is return the fact that the
            // component was not loaded
            return false;
        }
    }

    /**
     * Reload a component to the container.
     * 
     * @param id
     *            The unique name of the component within the container.
     */
    final void reloadComponent(final String id) throws Exception {
        synchronized (m_reloadingIDs) {
            while (!m_reloadingIDs.isEmpty()) {
                m_reloadingIDs.wait(250);
                if (m_isClosing) {
                    return;
                }
            }
            m_reloadingIDs.add(id);
        }

        Runnable reloader = new Runnable() {
            @Override
            public void run() {
                internalReloadComponent(id, true);
            }
        };
        m_taskScheduler.scheduleTask(reloader, false);
    }

    void beginLogging() {
        m_isLoggingStarted = true;
        for (int i = 0; i < m_listOfLoggers.size(); i++) {
            IMessageLogger logger = (IMessageLogger)m_listOfLoggers.get(i);
            logger.logMessage(m_tempLogBuffer);
        }
        m_tempLogBuffer = "";
    }

    void setTraceMask(int traceMask) {
        m_connector.setTraceMask(traceMask);
        ClassLoaderFactory.setTraceMask(traceMask, m_containerDelegate);
    }

    void setSonicArchiveSearchPath(String searchPath) {
        if (searchPath == null || searchPath.length() == 0) {
            String message = "Invalid or unspecified archive search path: " + (searchPath == null ? "<null>" : searchPath);
            logMessage(null, message, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        }
        m_sonicArchiveSearchPath = searchPath;
    }

    // reportChangedElements is used by the local AGENT to report a group modification notification is has
    // received to all the local components
    void reportChangedElements(IDirElement[] elements) {
        try {
            updateConfigElements(elements);
        } catch (VersionOutofSyncException e) {
            // We failed to apply the modification. We probably have missed some updates - reconcile the cache
            reconcileCache();
        } catch (CacheClosedException e) {
            // We are probably shutting down
            return;
        } catch (PersistentCacheException e) {
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.CACHE_FAILURE_EXIT_CODE);
        }

    }

    // reportChangedElement is used by the local AGENT to report the modification notification is has
    // received to all the local components
    void reportChangedElement(IBasicElement element) {

        boolean reportToComponent = true;
        boolean replacement = false;
        if (element instanceof IEnvelope) {
            IEnvelope envelope = (IEnvelope)element;
            reportToComponent = envelope.getProperty(IEnvelope.DELETED_BUT_RECREATED_LABEL) == null ? true : false;
            replacement = envelope.getProperty(IEnvelope.REPLACEMENT_LABEL) == null ? false : true;
            element = envelope.getEnvelopedElement();
        }

        // DS_STARTUP_ELEMENT is a special element sent by the DS to tell the container it is up again
        // If the accessibility status didn't change (i.e. m_dsMonitor didn't even know the DS was down,
        // we call reconcileCache() ourselves (m_dsMonitor typically calls it when it detects DS re-accessibility
        if (element.getIdentity().getName().equals(DSComponent.DS_STARTUP_ELEMENT)) {
            reconcileCache();
            return;
        }

        if (element.getIdentity().getName().equals(DSComponent.DS_RENAMING_ELEMENT)) {
            notifyBeansOfRename(element);
            return;
        }

        try {
            cacheAndReportElement(element, reportToComponent, replacement);
        } catch (VersionOutofSyncException e) {
            // We failed to apply the modification. We probably have missed some updates - reconcile the cache
            reconcileCache();
        } catch (CacheClosedException e) {
            // We are probably shutting down
            return;
        } catch (PersistentCacheException e) {
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.CACHE_FAILURE_EXIT_CODE);
        }
    }

    private void storeNotificationListenerSubscriptionsInCache(ObjectName objectName, NotificationListenerDelegate localListener) {
        // if the delegate has not changed then there is nothing to store
        if (!localListener.isDirty()) {
            return;
        }

        // N.B. the ObjectName should have been "fixed up" by this time, in order to
        // remove any FT instance name [see the "interceptNotificationRegistrationOperation" method, in ContainerImpl]

        // N.B. in the current (6.1) version [and previous versions], only one filter/handback pair is
        // allowed; in other words, multiple handbacks cannot be associated
        // with the same filter instance. This is non-compliant with respect
        // to the JMX Remote API specification, but will not be addressed
        // until a post-6.1 release. That spec calls for associating a
        // unique ID, on the client side, with each filter, and passing that
        // unique ID to the server (container). That way, each filter can
        // be identified, and compared, even though the deserialized filter
        // objects [references, actually] may not match.
        // To try and account for this future change in our implementation,
        // the storage format/schema will allow for a string identifier for
        // each filter. However, in this first pass, we will only allow
        // a single handback to be stored for each filter.

        // get the component name and an IDirElement for the notification subscriptions (a new one will be created if
        // one does not exist)
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);

        String destination = localListener.getDestination();
        IAttributeSet subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();

        try {
            // add the listener delegate as a bytes attribute (the listener's "destination" is the unique ID used for
            // the listener delegate)
            subscriptionsAttrs.setBytesAttribute(destination, localListener.toByteArray());
        } catch (Exception e) {
            logMessage(null, "Exception while caching notification subscriptions for " + objectName.getCanonicalName(), e, Level.WARNING);
            return;
        }

        setRuntimeConfigurationInCacheOnly(subscriptionsElement);
    }

    private void deleteNotificationListenerSubscriptionsFromCache(NotificationListenerDelegate localListener) {
        // get the component name and an IDirElement for the notification subscriptions (a new one will be created if
        // one does not exist)
        String componentName = new CanonicalName(localListener.getObjectName().getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);

        String destination = localListener.getDestination();
        IAttributeSet subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();

        try {
            if (localListener.getHandbackFilterPairs().size() == 0) // listener is no longer functional
            {
                Object existing = subscriptionsAttrs.getAttribute(destination);
                if (existing != null) {
                    subscriptionsAttrs.deleteAttribute(destination);
                    if (subscriptionsAttrs.getAttributes().size() == 0) // no listeners left for the component so delete
                    {
                        deleteRuntimeElementFromCacheOnly(subscriptionsElement.getIdentity().getName());
                        return;
                    }
                }
            } else {
                // add the listener delegate as a bytes attribute (the listener's "destination" is the unique ID used
                // for the listener delegate)
                subscriptionsAttrs.setBytesAttribute(destination, localListener.toByteArray());
            }

            setRuntimeConfigurationInCacheOnly(subscriptionsElement);
        } catch (Exception e) {
            logMessage(null, "Exception while updating cached notification subscriptions for "
                + localListener.getObjectName().getCanonicalName(), e, Level.WARNING);
        }
    }

    void storeNotificationHandlerSubscriptionsInCache(ObjectName objectName, NotificationHandlerDelegate localHandler) {
        // if the delegate has not changed then there is nothing to store
        if (!localHandler.isDirty()) {
            return;
        }

        // get the component name and an IDirElement for the notification subscriptions (a new one will be created if
        // one does not exist)
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);

        IAttributeSet subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();

        try {
            // add the handlers delegate as a bytes attribute
            subscriptionsAttrs.setBytesAttribute(localHandler.getDestination(), localHandler.toByteArray());
        } catch (Exception e) {
            logMessage(null, "Exception while caching notification subscriptions for " + objectName.getCanonicalName(), e, Level.WARNING);
            return;
        }

        setRuntimeConfigurationInCacheOnly(subscriptionsElement);
    }

    void deleteNotificationHandlerSubscriptionsFromCache(ObjectName objectName, NotificationHandlerDelegate localHandler) {
        // get the component name and an IDirElement for the notification subscriptions (a new one will be created if
        // one does not exist)
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);

        String destination = localHandler.getDestination();
        IAttributeSet subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();

        try {
            Object existing = subscriptionsAttrs.getAttribute(destination);
            if (existing != null) {
                subscriptionsAttrs.deleteAttribute(destination);
                if (subscriptionsAttrs.getAttributes().size() == 0) // no listeners left for the component so delete
                {
                    deleteRuntimeElementFromCacheOnly(subscriptionsElement.getIdentity().getName());
                    return;
                }
            }

            setRuntimeConfigurationInCacheOnly(subscriptionsElement);
        } catch (Exception e) {
            logMessage(null, "Exception while updating cached notification subscriptions for " + localHandler.getDestination(), e,
                       Level.WARNING);
        }
    }

    private void restoreNotificationSubscriptionsFromCache(ComponentMBean mBean) {
        // get the component name and an IDirElement for the notification subscriptions (a new one will be created if
        // one does not exist)
        ObjectName objectName = mBean.getObjectName();
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();

        IDirElement subscriptionsElement = null;
        IAttributeSet subscriptionsAttrs = null;
        Iterator delegates = null;

        // external (JMX client) subscriptions
        subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();
        delegates = subscriptionsAttrs.getAttributes().values().iterator();
        while (delegates.hasNext()) {
            try {
                NotificationListenerDelegate localListener = NotificationListenerDelegate.fromByteArray((byte[])delegates.next());
                String remoteListenerKey = localListener.getRemoteListenerKey();
                synchronized (m_notificationListeners) {
                    m_notificationListeners.put(remoteListenerKey, localListener);
                }
                m_mbeanServer.addNotificationListener(objectName, localListener, null, null);
            } catch (Exception e) {
                logMessage(null, "Exception while reading cached notification subscriptions for " + objectName.getCanonicalName(), e,
                           Level.WARNING);
                break;
            }
        }

        // internal (MF) subscriptions
        subscriptionsElement = getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        subscriptionsAttrs = (IAttributeSet)subscriptionsElement.getAttributes();
        delegates = subscriptionsAttrs.getAttributes().values().iterator();
        while (delegates.hasNext()) {
            try {
                NotificationHandlerDelegate localHandler = NotificationHandlerDelegate.fromByteArray((byte[])delegates.next());
                mBean.restoreNotificationHandler(localHandler);
            } catch (Exception e) {
                logMessage(null, "Exception while reading cached notification subscriptions for " + objectName.getCanonicalName(), e,
                           Level.WARNING);
                break;
            }
        }
    }

    private void notifyBeansOfRename(IBasicElement renamingNotificationsElement) {
        // don't bother
        if (m_isClosing) {
            return;
        }

        try {
            byte[] streamBytes = (byte[])((IElement)renamingNotificationsElement).getAttributes().getAttribute("notifications");
            ByteArrayInputStream bais = new ByteArrayInputStream(streamBytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ArrayList notificationsList = (ArrayList)ois.readObject();
            for (int i = 0; i < notificationsList.size(); i++) {
                IRenameNotification notification = (IRenameNotification)notificationsList.get(i);
                String[] storageNames = m_configCache.rename(notification.getName(), notification.getNewName());
                for (int j = 0; j < storageNames.length; j++) {
                    Object[] entries = m_mBeans.entrySet().toArray();
                    for (int k = 0; k < entries.length; k++) {
                        Map.Entry entry = (Map.Entry)entries[k];
                        AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;

                        // check to see if the component has been unloaded (possible if the AGENT got a container
                        // component
                        // deletion config change before the actual component gets it)
                        if (mBean == null) {
                            continue;
                        }

                        try {
                            // if the bean is interested in this configuration and the bean's request was a logical
                            // name request, then let the bean handle this naming notification
                            if ((mBean.acceptChanges(getParentName(storageNames[j]), storageNames[j]).booleanValue())
                                && mBean.isLogicalRequest(storageNames[j])) {
                                // don't bother
                                if (m_isClosing) {
                                    return;
                                }
                                mBean.handleFSNamingNotification(notification);
                            }
                        } catch (Throwable t) {
                            // The component might have shutdown so the failure is not necessarily a problem
                            logMessage(null, "Failed to pass configuration change to component "
                                + (String)entry.getKey() + ", trace follows... ", t, Level.WARNING);
                        }
                    }
                }
            }
        } catch (Exception e) {
            MFRuntimeException re = new MFRuntimeException("Cache element rename failure");
            re.initCause(e);
            throw re;
        }
    }

    /**
     * Determines if this container is currently hosting a component with the given component ID.
     */
    boolean isHostingComponent(String id) {
        // if we're in the process of reloading then we are technically hosting the component
        // even if it is temporarily removed from the mBeans table
        synchronized (m_reloadingIDs) {
            if (m_reloadingIDs.contains(id)) {
                return true;
            }
        }

        return m_mBeans.containsKey(id);
    }

    void deleteRuntimeConfiguration(String id) {
        String rootDir = IMFDirectories.MF_DIR_SEPARATOR
            + IMFDirectories.MF_RUNTIME_DIR + IMFDirectories.MF_DIR_SEPARATOR + m_containerIdentity.getCanonicalName()
            + IMFDirectories.MF_DIR_SEPARATOR + id;

        deleteRuntimeElement(rootDir + "/metrics");
        deleteRuntimeElement(rootDir + "/alerts");

        // notification subscriptions are only held in the cache
        deleteRuntimeElementFromCacheOnly(rootDir + '/' + EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        deleteRuntimeElementFromCacheOnly(rootDir + '/' + INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
    }

    boolean isBooted() {
        return m_isBooted;
    }

    boolean isClosing() {
        return m_isClosing;
    }

    IContainerIdentity getContainerIdentity() {
        return m_containerIdentity;
    }

    ITaskScheduler getTaskScheduler() {
        return m_taskScheduler;
    }

    INotificationPublisher getNotificationPublisher() {
        return m_notificationPublisher;
    }

    void traceMessage(String message) {
        if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
            logMessage(null, message, Level.TRACE);
        }
    }

    void logMessage(String id, String message, int severityLevel) {
        // Check to see if the logging interceptor is enabled and if we should disable regular logging output
        // after processing the log message (occurs when beforeLogMessage returns true).
        if (m_isBooted && m_agent.getActionalLogInterceptor().booleanValue() && !m_isClosing) {
            if (SonicLogInterceptor.beforeLogMessage(id, message, severityLevel)) {
                return;
            }
        }

        String timestampedMessage = ContainerUtil.createLogMessage(m_isLSD ? m_containerIdentity.getContainerName() : null, id, message,
                                                                   severityLevel);

        // If the command line is enabled, and the container is done booting
        // we want to print any output on a new line , so it doesn't
        // come out right after the CLI prompt. This only affects the output
        // to System.out; other logs will not see the CLI prompt
        if (m_isBooted && m_agent.getLogToConsole().booleanValue() && m_agent.getCommandLine().booleanValue() && !m_isClosing) {
            m_agent.crAfterPrompt();
        }

        if (m_isLoggingStarted) {
            for (int i = 0; i < m_listOfLoggers.size(); i++) {
                IMessageLogger logger = (IMessageLogger)m_listOfLoggers.get(i);
                logger.logMessage(timestampedMessage);
            }
        } else {
            m_tempLogBuffer += (m_tempLogBuffer.length() == 0 ? "" : IContainer.NEWLINE) + timestampedMessage;
            if (m_isClosing) {
                System.out.println(m_tempLogBuffer);
            }
        }

        // Don't print CLI prompts while the container is getting initialized or after shutdown has been initiated
        if (m_agent != null
            && m_isBooted && (m_agent.getLogToConsole().booleanValue() && m_agent.getCommandLine().booleanValue()) && !m_isClosing
            && !message.equals(SHUTDOWN_MESSAGE)) {
            m_agent.redoCLIPrompt();
        }

        if (severityLevel < Level.TRACE) {
            synchronized (m_pendingLogMessageQueue) {
                m_pendingLogMessageQueue.add(timestampedMessage);
                if (m_pendingLogMessageQueue.size() > 500) {
                    m_pendingLogMessageQueue.remove(0); // keep FIFO to 500 messages max .. rem this is just best effort
                }
            }

            exhaustPendingLogMessageQueue();
        }

        if (severityLevel < Level.TRACE && m_agentMBean != null && m_agentMBean.getManagedComponent() != null) {
            ((Agent)m_agentMBean.getManagedComponent()).sendLogMessageNotification(id, message, severityLevel);
        }
    }

    void logMessage(String id, String message, Throwable exception, int severityLevel) {
        if (isOutOfMemoryError(exception)) {
            if (m_isOutOfMemory) {
                return; // we should only log an OOM once
            }
            m_isOutOfMemory = true;
        }

        try {
            String formattedTraceMessage = ContainerUtil.appendThrowableToMessage(message, exception);

            logMessage(id, formattedTraceMessage, severityLevel);
        } catch (OutOfMemoryError oome) {
            // If we couldn't log the last message then at least try to
            // write the stack to stderr. Note that this attempt will still
            // hit the Sonic logging mechanism since stderr is redirected there.
            // If memory is very tight this could still fail.
            try {
                System.err.print("An OutOfMemoryError occurred while attempting to log the following exception: ");
                System.err.println(exception.toString());
                exception.printStackTrace();
                System.err.println("Logging failed due to: " + oome.toString());
            } catch (Throwable t) {
                // SNC00085152 - last-ditch attempt to log the exception - this time
                // subverting Sonic logging and writing directly to vanilla stderr.
                // The exception will miss the container log - a user would need to
                // capture the JVM's stderr stream to see this output.
                try {
                    s_errDirect.print("Sonic logging failed for the following exception: ");
                    s_errDirect.println(exception.toString());
                    exception.printStackTrace(s_errDirect);
                    s_errDirect.println("Logging failed due to:");
                    s_errDirect.print("1. ");
                    s_errDirect.println(oome.toString());
                    s_errDirect.print("2. ");
                    s_errDirect.println(t.toString());
                } catch (Throwable t2) {
                    // there's really nothing we can do now
                }
            }

            m_isOutOfMemory = true;
        }

        if (m_isOutOfMemory) {
            if (m_agent != null) {
                m_agent.shutdown(IContainerExitCodes.INSUFFICIENT_MEMORY_EXIT_CODE);
            } else {
                shutdown(IContainerExitCodes.INSUFFICIENT_MEMORY_EXIT_CODE);
            }
        }
    }

    private boolean isOutOfMemoryError(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            return true;
        }

        Throwable cause = exception.getCause();
        if (cause != null && isOutOfMemoryError(cause)) {
            return true;
        }

        return false;
    }

    void logMessage(String id, Throwable exception, int severityLevel) {
        logMessage(id, "Trace follows...", exception, severityLevel);
    }

    IContainerState getContainerState() {
        String domainName = m_containerIdentity.getDomainName();
        String containerName = m_containerIdentity.getContainerName();

        CanonicalName canonicalName = new CanonicalName(domainName, containerName, "");
        ContainerState containerState = new ContainerState(canonicalName, m_containerIdentity.getConfigIdentity());

        if (m_isClosing) {
            containerState.setState(IContainerState.STATE_OFFLINE);
        }

        Object[] entries = m_mBeans.entrySet().toArray();
        for (int i = 0; i < entries.length; i++) {
            Map.Entry entry = (Map.Entry)entries[i];
            canonicalName = new CanonicalName(domainName, containerName, (String)entry.getKey());
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;

            IComponentState componentState = mBean.getComponentState();
            if (m_isClosing) {
                ((ComponentState)componentState).setState(IComponentState.STATE_OFFLINE);
            }
            containerState.addComponentState(componentState);
        }

        return containerState;
    }

    IConnectorServer getConnectorServer() {
        return m_connector.getConnectorServer();
    }

    void shutdown(int exitCode) {
        shutdown(exitCode, false);
    }

    void shutdown(int exitCode, boolean cleanRestart) {
        // tell the connector close is pending as we don't want the appearance that were hanging around
        if (m_connector != null) {
            m_connector.closePending();
        }

        if (m_isClosing) {
            return;
        }

        // log the shutdown locally
        if (!m_generateCache) {
            StringBuffer sb = new StringBuffer();
            if (exitCode == IContainerExitCodes.CONTAINER_RESTART_EXIT_CODE) {
                sb.append(RESTART_MESSAGE);
            } else {
                sb.append(SHUTDOWN_MESSAGE);
            }
            if (exitCode != IContainerExitCodes.NORMAL_SHUTDOWN_EXIT_CODE) {
                sb.append(" (exit code=").append(exitCode).append(')');
                logMessage(null, sb.toString(), Level.WARNING);
            } else {
                logMessage(null, sb.toString(), Level.INFO);
            }
        }

        m_isClosing = true;

        synchronized (m_notificationListenerExpirer.getLockObj()) {
            m_notificationListenerExpirer.getLockObj().notifyAll();
        }

        synchronized (m_containerDelegate) {
            m_containerDelegate.notifyAll();
        }

        try {
            // notify externally
            if (m_agent != null) {
                m_agent.sendShutdownNotification(exitCode);
            }

            // if the mgmt comms is via a broker in this container we need to try to give
            // some small window in which the shutdown notification can be handled by the AM
            try {
                Thread.sleep(2000);
            } catch (Exception e) {
            }

            if (!m_isLoggingStarted && m_tempLogBuffer.length() > 0) {
                ((PrintStream)Agent.m_stdout).println(m_tempLogBuffer);
                ((PrintStream)Agent.m_stdout).flush();
                m_tempLogBuffer = "";
            }

            if (m_dsMonitor != null) {
                m_dsMonitor.close();
            }

            Object[] entries = null;

            // loop through application components unloading them
            entries = m_mBeans.entrySet().toArray();
            for (int i = 0; i < entries.length; i++) {
                Map.Entry entry = (Map.Entry)entries[i];
                AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
                if (!ContainerUtil.isFrameworkComponent(mBean.getManagedComponent().getClass())) {
                    String id = (String)entry.getKey();
                    // have to use introspection since it will be a different class loader
                    try {
                        unloadComponent(id);
                    } catch (Throwable e) {
                        logMessage(null, "Failed to unload ID=" + id + ", trace follows...", e, Level.WARNING);
                    }
                }
            }

            // loop through framework components (the ones left) unloading them
            entries = m_mBeans.keySet().toArray();
            for (int i = 0; i < entries.length; i++) {
                try {
                    if (!entries[i].equals(IAgentProxy.ID)) {
                        unloadComponent((String)entries[i]);
                    }
                } catch (Throwable e) {
                    logMessage(null, "Failed to unload ID=" + (String)entries[i] + ", trace follows...", e, Level.WARNING);
                }
            }

            synchronized (m_containerDelegate) {
                m_containerDelegate.notifyAll();
            }

            if (m_connectorHandback != null) {
                m_connectorHandback.close();
                m_connectorHandback = null;
            }

            // cleanup the JMS communications
            if (m_connector != null) {
                try {
                    // Sonic00005081 Give some chance for the replies to existing requests (e.g. shutdown)
                    // and notifications to be sent to the source of the request.
                    try {
                        Thread.sleep(2000);
                    } catch (InterruptedException e) {
                    }
                    m_connector.close();
                } catch (Throwable e) {
                    Throwable t = e instanceof MFRuntimeException ? e.getCause() : e;
                    logMessage(null, "Failed to clean up JMS subscriptions/connections, trace follows...", t, Level.WARNING);
                }
            }

            // close the cache
            if (m_configCache != null && exitCode != IContainerExitCodes.CACHE_FAILURE_EXIT_CODE) {
                try {
                    m_configCache.close();
                } catch (PersistentCacheException e) {
                    logMessage(null, "Unable to persist local configuration cache, trace follows...", e, Level.SEVERE);
                }
            }

            if (m_isLoggingStarted) {
                try {
                    unloadComponent(IAgentProxy.ID);
                } catch (Exception e) {
                } // don't bother we're in shutdown
            }

            // for NT service, ActivationDaemon and test infrastructure
            if (IContainer.SIGNAL_MODE) {
                System.out.print("" + IContainer.SHUTDOWN_SIGNAL_CHAR + exitCode + IContainer.SHUTDOWN_SIGNAL_CHAR);
                System.out.flush();
            }
        } catch (Throwable e) {
            e.printStackTrace();
        } finally {
            if (IContainer.SIGNAL_MODE) {
                // gives a small chance for NT Service to get stop signals
                try {
                    Thread.sleep(SHUTDOWN_PAUSE);
                } catch (InterruptedException e) {
                }
            }

            if (!m_generateCache) {
                if (exitCode == IContainerExitCodes.CONTAINER_RESTART_EXIT_CODE) {
                    logMessage(null, "Restarting...", Level.INFO);
                } else {
                    logMessage(null, "Exiting...", Level.INFO);
                }
            }

            // the HTML adaptor property is for internal use only and should not be published
            if (System.getProperty("htmlAdaptor", "false").equals("true")) {
                try {
                    int port = Integer.parseInt(System.getProperty("htmlAdaptor.port", "8082"));
                    m_mbeanServer.invoke(new ObjectName("Adaptor:name=html,port=" + port), "stop", IEmptyArray.EMPTY_OBJECT_ARRAY,
                                         IEmptyArray.EMPTY_STRING_ARRAY);
                } catch (Throwable e) {
                    logMessage(null, e, Level.SEVERE);
                }
            }

            m_notificationPublisher.close();
            m_taskScheduler.close();
            if (m_abortMonitor != null) {
                m_abortMonitor.close();
            }

            if (m_isLSD) {
                // get the root thread group
                ThreadGroup root = Thread.currentThread().getThreadGroup();
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                Thread[] activeThreads = new Thread[1000]; // should be plenty big enough

                while (true) // iterate until the only active non-daemon threads are the VM destroy threads
                {
                    int count = root.enumerate(activeThreads, true);
                    for (int i = 0; i < count; i++) {
                        if (!activeThreads[i].isDaemon() && !activeThreads[i].getName().equals("DestroyJavaVM")) {
                            try {
                                Thread.sleep(1000);
                            } catch (Exception e) {
                            }
                            continue;
                        }
                    }
                    break;
                }
            }

            if (cleanRestart) {
                try {
                    new java.io.FileOutputStream(IContainer.CLEAN_RESTART_FILE, true).close();
                } catch (Exception e) {
                    logMessage("Could not wrire clean restart file", e, Level.WARNING);
                }
            }
            new File(IContainer.START_TIMESTAMP_FILE).delete();
            if (!m_isLSD) {
                m_containerRunningLockFile.unlock();
            }
            synchronized (m_containerExitCode) {
                m_containerExitCode.setExitCode(new Integer(exitCode));
                m_containerExitCode.exit(true);
                m_containerExitCode.notifyAll();
            }
        }
    }

    void addGlobalComponentSupport(String globalID, String instanceID, IGlobalComponentListener globalComponentListener) throws Exception {
        if (m_isClosing) {
            return;
        }

        m_connector.addGlobalComponentSupport(globalID, instanceID, globalComponentListener);
    }

    void removeGlobalComponentSupport(String globalID, String instanceID) {
        m_connector.removeGlobalComponentSupport(globalID, instanceID);
    }

    void setLocalDS(IFrameworkComponent ds) {
        m_directory.setLocalDS((DSComponent)ds);
    }

    void addSharedClassname(String classname) {
        synchronized (m_sharedClasses) {
            m_sharedClasses.add(classname);
        }
    }

    Timer getTimer() {
        return m_timer;
    }

    /**
     * Load a component to the container.
     * 
     * @param id
     *            The unique name of the component within the container. If the component is a global (singleton)
     *            component then this parameter will be ignored.
     * @param configID
     *            The name of the configuration for this component as known by the DirectoryService.
     * @param start
     *            If true call .start() on the component.
     * @param traceMask
     *            The initial debug mask value.
     * @param frameworkOnly
     *            If true then do not not the component if it is not a framework component.
     * 
     * @return The framework mBean that wraps the IComponent instance. If we were requested to load only framework
     *         components and the component is not a framework component, then null will be returned.
     */
    final Object loadComponent(String id, String configID, boolean start, int traceMask, boolean frameworkOnly) throws Exception {
        synchronized (m_containerDelegate) {
            while (m_isLoading || m_isUnloading) {
                if (m_isClosing) {
                    throw new IllegalStateException("Cannot load component [" + id + "] while shutdown is occuring");
                }
                m_containerDelegate.wait();
            }
            m_isLoading = true;

            try {
                AbstractMBean mBean = null;
                IComponent component = null;
                boolean isFrameworkComponent;

                try {
                    mBean = internalLoadComponent(id, configID, traceMask, frameworkOnly);
                    // the problem was already reported or the component was not a framework component
                    if (mBean == null) {
                        return null;
                    }

                    component = mBean.getManagedComponent();
                    isFrameworkComponent = component instanceof IFrameworkComponent;

                    // send a notification if appropriate
                    if (m_isBooted) {
                        Integer lastErrorLevel = null;
                        String lastError = null;

                        if (component instanceof IGlobalFrameworkComponent) {
                            id = ((IGlobalFrameworkComponent)component).getGlobalID();
                        }

                        lastError = (String)mBean.getAttribute("LastError");
                        lastErrorLevel = (Integer)mBean.getAttribute("LastErrorLevel");

                        // send load notification for any component other than the AGENT MANAGER (if a notification were
                        // to be sent for the AGENT MANAGER, the reloading process would block - see Sonic00010555)
                        boolean sendNotification = !id.equals(IAgentManagerProxy.GLOBAL_ID);
                        if (!sendNotification) {
                            synchronized (m_reloadingIDs) {
                                if (!m_reloadingIDs.contains(IAgentManagerProxy.GLOBAL_ID)) {
                                    // part of fix for Sonic00010555
                                    sendNotification = true;
                                }
                            }
                        }
                        if (sendNotification) {
                            m_agent.sendComponentLoadNotification(id, configID, lastError, lastErrorLevel);
                        }
                    }
                } catch (OutOfMemoryError e) {
                    logMessage(null, "Failed to load ID=" + id + " due to insufficient memory...", e, Level.SEVERE);
                    throw e; // statement will never be reached
                } catch (Throwable e) {
                    logMessage(null, "Failed to load ID=" + id + ", trace follows...", e, Level.SEVERE);
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw (Error)e;
                }

                // The Agent is always started in bootframework() independent of other components so we don't
                // need to start again
                if (id.equals(IAgentProxy.ID)) {
                    start = false;
                }

                // If this is an FT container, then only start components if the container has booted and
                // it is in the active state. (Note: backed out earlier fix for MQ-34498)
                if (m_containerFT != null && !m_containerFT.isActive()) {
                    start = false;
                }

                // Note: If FT state changes now, components will be stopped after the start component completes
                // since stop component is blocked on m_containerDelegate in stopComponents

                if (start) {
                    startComponent(id, component, isFrameworkComponent);
                }

                return mBean;
            } finally {
                m_isLoading = false;
                m_containerDelegate.notifyAll();
            }
        }
    }

    private void startComponent(String id, IComponent component, boolean isFrameworkComponent) throws Exception {
        try {
            if (!(id.equals(IAgentProxy.ID) || id.equals(IDirectoryServiceProxy.GLOBAL_ID))) {
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getDelegatingLoader(m_containerIdentity.getCanonicalName(),
                                                                                                    id));
            }

            // special case for AGENT MANAGER, so that any pending requests to it will be unblocked (see Sonic00010555)
            if (id.equals(IAgentManagerProxy.GLOBAL_ID)) // part of fix for Sonic00010555
            {
                MBeanHolder holder = (MBeanHolder)m_mBeans.get(id);
                if ((holder != null)) {
                    synchronized (m_reloadingIDs) {
                        if (m_reloadingIDs.contains(id)) {
                            m_reloadingIDs.clear();
                            m_reloadingIDs.notifyAll();
                        }
                    }
                }
            }

            component.start();
        } catch (OutOfMemoryError e) {
            logMessage(null, "Failed to start ID=" + id + " due to insufficient memory...", e, Level.SEVERE);
            throw e; // statement will never be reached
        } catch (Throwable e) {
            logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, Level.SEVERE);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        } finally {
            if (!isFrameworkComponent) {
                Thread.currentThread().setContextClassLoader(m_defaultClassLoader);
            }
        }
    }

    /**
     * Unload a component from the container.
     * 
     * @param id
     *            The unique name of the component within the container.
     */
    final void unloadComponent(String id) throws Exception {
        synchronized (m_containerDelegate) {
            while (m_isUnloading || (m_isLoading && !m_isClosing)) {
                m_containerDelegate.wait();
            }
            m_isUnloading = true;

            try {
                MBeanHolder holder = (MBeanHolder)m_mBeans.get(id);
                if (holder == null) {
                    throw new MFException("Unknown ID: " + id);
                }

                AbstractMBean mBean = holder.mBean;
                if (mBean == null) {
                    throw new MFException("Unknown ID: " + id);
                }

                ClassLoaderFactory.removeLoaderUsages(m_containerIdentity.getCanonicalName(), id);

                IComponent component = mBean.getManagedComponent();
                if (component.getState().shortValue() != IComponentState.STATE_OFFLINE) {
                    component.stop();
                }
                component.destroy();

                mBean.cleanup();
                m_mbeanServer.unregisterMBean(mBean.getObjectName());
                boolean logUnload = !id.equals(IAgentManagerProxy.GLOBAL_ID);
                if (!logUnload) {
                    synchronized (m_reloadingIDs) {
                        if (!m_reloadingIDs.contains(IAgentManagerProxy.GLOBAL_ID)) {
                            logUnload = true;
                        }
                    }
                }
                if (logUnload) {
                    // log the unload locally
                    if (!m_generateCache) {
                        logMessage(null, "Unloaded ID=" + id, Level.INFO);
                    }

                    // send a notification if appropriate
                    if (m_isBooted && !m_isClosing) {
                        m_agent.sendComponentUnloadNotification(id);
                    }
                }

                // clear current notification listeners
                String matchString = IComponentIdentity.DELIMITED_ID_PREFIX + id;
                synchronized (m_notificationListeners) {
                    Iterator iterator = m_notificationListeners.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        String key = (String)entry.getKey();
                        if (key.endsWith(matchString)) {
                            iterator.remove();
                            ((NotificationListenerDelegate)entry.getValue()).close();
                        }
                    }
                }

                holder.mBean = null;
            } finally {
                m_mBeans.remove(id);
                m_isUnloading = false;
                m_containerDelegate.notifyAll();
            }
        }
    }

    /**
     * Invokes a call on a component in this container
     */
    Object invokeLocal(String target, String operationName, Object[] params, String[] signature) throws Exception {
        try {
            return m_internalRequestHandler.invoke(new ObjectName(target), operationName, params, signature, true);
        } catch (InvocationTargetException ite) {
            Throwable throwable = ite.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            // else
            throw (Error)throwable;
        }
    }

    /**
     * Invokes a call on a component in this container allowing specification of check exported
     */
    Object invokeLocal(String target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
        try {
            return m_internalRequestHandler.invoke(new ObjectName(target), operationName, params, signature, checkExported);
        } catch (InvocationTargetException ite) {
            Throwable throwable = ite.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            // else
            throw (Error)throwable;
        }
    }

    /**
     * Invokes a call on a component in another container
     */
    Object invokeRemote(String target, String operationName, Object[] params, String[] signature, long timeout, boolean synchronous) throws Exception {
        if (synchronous) {
            return m_connector.invoke(IContainer.INTERNAL_COMMS_TYPE, target, target, operationName, params, signature, timeout);
        } else {
            // ASN: JP Morgan Scalability Enhancements...
            long ttl = timeout; // by default, use request timeout value as the time-to-live for any published remote
                                // oneway invocations...
            if (operationName.equals(ContainerImpl.HANDLE_NOTIFICATION_METHOD_NAME)) {
                // if invocation is to send a [remote internal asynchronous] notification, set the TTL to the value used
                // for external notifications...
                ttl = JMSConnectorServer.NOTIFICATION_TTL;
            }

            m_connector.invokeOneway(IContainer.INTERNAL_COMMS_TYPE, target, target, operationName, params, signature, timeout, ttl);
            return null;
        }
    }

    AbstractMBean getMBean(String id) {
        boolean logIfBlocked = false;

        // if were in the process of reloading the mBean/component then wait for the reload to complete
        synchronized (m_reloadingIDs) {
            if (m_reloadingIDs.contains(id)) {
                logIfBlocked = true;
            }
        }

        if (logIfBlocked) {
            logMessage(id, "Management request blocked during component reload...", Level.INFO);
        }

        synchronized (m_reloadingIDs) {
            while (m_reloadingIDs.contains(id)) {
                try {
                    m_reloadingIDs.wait();
                } catch (InterruptedException e) {
                }
            }
        }

        if (logIfBlocked) {
            logMessage(id, "...request resumed after reload", Level.INFO);
        }

        MBeanHolder holder = (MBeanHolder)m_mBeans.get(id);
        return holder == null ? null : holder.mBean;
    }

    // Note: For internal use only; does not block on what is being reloaded, because the thread that is calling this
    // *is* the reload thread
    AbstractMBean getMBeanNonBlocking(String id) {
        MBeanHolder holder = (MBeanHolder)m_mBeans.get(id);
        return holder == null ? null : holder.mBean;
    }

    Context getInitialContext() {
        return new MFContext(this, "");
    }

    private void setupInterestInLogicalName() {
        // must always ensure this container has been retrieved
        if (!m_storageNames.contains(m_containerIdentity.getConfigIdentity().getName())) {
            m_storageNames.add(m_containerIdentity.getConfigIdentity().getName());
        }

        synchronized (m_storageNames) {
            Iterator storageNames = m_storageNames.iterator();
            while (storageNames.hasNext()) {
                if (m_isClosing) {
                    return;
                }
                storageToLogical((String)storageNames.next());
            }
        }
    }

    String storageToLogical(String storageName) {
        String logicalName = m_configCache.storageToLogical(storageName);

        // should only happen when the cache has been erased
        if (logicalName == null) {
            logicalName = m_directory.storageToLogical(storageName);
        }

        // register interest in changes
        if (logicalName != null) {
            m_directory.registerInterestInChanges(m_containerIdentity.getCanonicalName(), logicalName);
            synchronized (m_storageNames) {
                if (!m_storageNames.contains(storageName)) {
                    m_storageNames.add(storageName);
                }
            }
        }

        return logicalName;
    }

    int checkFSConfiguration(String path) {
        try {
            if (m_configCacheView.getElementByLogicalName(path) != null) {
                // found in the cache
                if (DEBUG) {
                    System.out.println("checkFSConfiguration: " + path + " found in the cache.");
                }
                return IComponentContext.AVAILABLE;
            }
        } catch (CacheClosedException ex) {
            MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
            re.initCause(ex);
            throw re;
        }

        if (DEBUG) {
            System.out.println("checkFSConfiguration: " + path + " not in the cache.");
        }

        // not in the cache; look up the DS
        try {
            if (m_directory.getElementByLogicalName(m_containerIdentity.getCanonicalName(), path, false) != null) {
                // found in the DS
                if (DEBUG) {
                    System.out.println("checkFSConfiguration: " + path + " found in the DS.");
                }
                return IComponentContext.AVAILABLE;
            } else {
                // not in the DS either
                if (DEBUG) {
                    System.out.println("checkFSConfiguration: " + path + " not in the DS.");
                }
                return IComponentContext.NOTAVAILABLE;
            }
        } catch (Exception ex) {
            // not in the cache and the DS is unreachable
            if (DEBUG) {
                System.out.println("checkFSConfiguration: error looking up " + path + " in the DS: " + ex);
            }
            return IComponentContext.MAYBENOTAVAILABLE;
        }
    }

    IElement getFSConfiguration(String logicalName, boolean alwaysFromDS) {
        IElement config = null;

        // first try to get the requested configuration from the cache
        try {
            if (!alwaysFromDS) {
                config = m_configCacheView.getElementByLogicalName(logicalName);
            }

            // if it was not available, can we get it from the directory service
            if (config == null) {
                config = m_directory.getElementByLogicalName(m_containerIdentity.getCanonicalName(), logicalName);

                if (config == null) {
                    return null;
                }
                // The element returned by the DS might not be "logicalName" but an archive that
                // contains "logicalName". Put it in the cache with the correct logicalName. If logicalName is then
                // found in the archive, return the element
                String archiveName = config.getArchiveName();
                if (archiveName == null) {
                    archiveName = logicalName;
                }
                // put the configuration retrieved from the DS in the cache
                m_configCache.setElementByLogicalName(archiveName, config);
                if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
                    logMessage(null, "Configuration [" + config.getIdentity().getName() + "] added to cache", Level.TRACE);
                }
            }
        }

        catch (VersionOutofSyncException e) {
            // Should never happen
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        } catch (CacheException e) {
            // The cache is already closed because we shutdown.
            if (e instanceof CacheClosedException) {
                return config;
            }

            MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
            re.initCause(e);
            throw re;
        }

        return config;
    }

    IElement getFSConfiguration(String logicalName) {
        return getFSConfiguration(logicalName, false);
    }

    File getLocalFile(String logicalName) throws MFException {
        LogicalFile file = null;
        File blobFile = null;
        try {
            file = m_fileManager.localFileFromLocation(null, logicalName, false, null);

        } catch (CacheClosedException ex) {
            // just return a null blobfile
        } catch (VersionOutofSyncException e) {
            // Should never happen
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        } catch (CacheException e) {
            // The cache is already closed because we shutdown.
            MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
            re.initCause(e);
            throw re;
        }
        if (file != null) {
            blobFile = new File(file.getFileName());
        }
        return blobFile;
    }

    // used for testing. Not exposed
    File getLocalFile(String location, String logicalName) throws MFException {
        LogicalFile file = null;
        File blobFile = null;
        try {
            file = m_fileManager.localFileFromLocation(location, logicalName, false, null);

        } catch (CacheClosedException ex) {
            // just return a null blobfile
        } catch (VersionOutofSyncException e) {
            // Should never happen
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        } catch (CacheException e) {
            // The cache is already closed because we shutdown.
            MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
            re.initCause(e);
            throw re;
        }
        if (file != null) {
            blobFile = new File(file.getFileName());
        }
        return blobFile;
    }

    String getPrivateSubDir(String configID, String baseDir) {
        if (DEBUG) {
            System.out.println("ContainerImpl.getPrivateSubDir, configID == " + configID + " baseDir == " + baseDir);
        }
        IAttributeSet containerAttrs = m_containerConfig.getAttributes();
        String domainName = (String)containerAttrs.getAttribute(IContainerConstants.DOMAIN_NAME_ATTR);
        String containerName = (String)containerAttrs.getAttribute(IContainerConstants.CONTAINER_NAME_ATTR);
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.COMPONENTS_ATTR);
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();

        if (components != null) {
            for (int i = 0; i < components.length; i++) {
                Map.Entry componentEntry = (Map.Entry)components[i];
                String id = (String)componentEntry.getKey();
                IAttributeSet compSet = (IAttributeSet)componentEntry.getValue();
                String compId = ((Reference)compSet.getAttribute(IContainerConstants.CONFIG_REF_ATTR)).getElementName();
                if (compId.equals(configID)) {
                    if (!baseDir.endsWith(File.separator)) {
                        baseDir = baseDir + File.separator;
                    }
                    String dirName = baseDir + domainName + "." + containerName + "." + id;
                    File tempDir = new File(dirName);
                    boolean madeDirs = true;
                    if (!tempDir.exists()) {
                        madeDirs = tempDir.mkdirs();
                    }
                    if (madeDirs) {
                        return tempDir.getAbsolutePath();
                    }
                }
            }
        }
        return null;
    }

    IElement getConfiguration(String configID, boolean alwaysFromDS) {
        IElement config = null;

        while (true)// first try to get the requested configuration from the cache
        {
            try {
                if (!alwaysFromDS) {
                    config = m_configCacheView.getElement(configID);
                }

                // if it was not available, can we get it from the directory service
                if (config == null) {
                    config = m_directory.getElement(m_containerIdentity.getCanonicalName(), configID);

                    if (config == null) {
                        return null;
                    }

                    // put the configuration retrieved from the DS in the cache
                    setElement(config);
                    if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
                        logMessage(null, "Configuration [" + config.getIdentity().getName() + "] added to cache", Level.TRACE);
                    }
                }

                break;
            } catch (VersionOutofSyncException e) {
                // Should never happen
                logMessage(null, e, Level.SEVERE);
                shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
                break;
            } catch (CacheException e) {
                // The cache is already closed because we shutdown.
                if (e instanceof CacheClosedException) {
                    return config;
                }

                MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
                re.initCause(e);
                throw re;
            } catch (InvokeTimeoutException e) {
                if (m_generateCache && !m_isClosing) // infinite retry
                {
                    logMessage(null, "Timeout while obtaining configuration [" + configID + "], retry initiated", Level.WARNING);
                    continue;
                } else {
                    throw e;
                }
            }
        }

        return config;
    }

    IElement getConfiguration(String configID) {
        return getConfiguration(configID, false);
    }

    IElement[] getConfigurations(String[] configIDs) {
        IElement[] configs = new IElement[configIDs.length];

        while (true)// first try to get the requested configuration from the cache
        {
            // first try to get the requested configurations from the cache
            try {
                boolean allAllreadyInCache = true;
                for (int i = 0; i < configIDs.length; i++) {
                    configs[i] = m_configCacheView.getElement(configIDs[i]);
                    if (configs[i] == null) {
                        allAllreadyInCache = false;
                    }
                }

                // if it was not all available, we get it from the DS
                if (!allAllreadyInCache) {
                    configs = m_directory.getElements(m_containerIdentity.getCanonicalName(), configIDs);

                    // put the configurations retrieved from the DS in the cache
                    for (int i = 0; i < configs.length; i++) {
                        setElement(configs[i]);
                        if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
                            logMessage(null, "Configuration [" + configs[i].getIdentity().getName() + "] added to cache", Level.TRACE);
                        }
                    }
                }

                break;
            } catch (VersionOutofSyncException e) {
                // Should never happen
                logMessage(null, e, Level.SEVERE);
                shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
                break;
            } catch (CacheException e) {
                // The cache is already closed because we shutdown.
                if (e instanceof CacheClosedException) {
                    return configs;
                }

                MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
                re.initCause(e);
                throw re;
            } catch (InvokeTimeoutException e) {
                if (m_generateCache && !m_isClosing) // infinite retry
                {
                    logMessage(null, "Timeout while obtaining multiple configurations, retry initiated", Level.WARNING);
                    continue;
                } else {
                    throw e;
                }
            }
        }

        return configs;
    }

    public void generateDSBootFile(String dsConfigID) {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return;
        }

        try {
            String dsBootContent = m_directory.exportDSBootFileString(dsConfigID);
            ContainerUtil.encryptAndStore(dsBootContent, IContainer.DEFAULT_DS_BOOTFILE_NAME, IContainer.PASSWORD);
            logMessage(null, "(Re)Generated the " + IContainer.DEFAULT_DS_BOOTFILE_NAME + " file", Level.INFO);
        } catch (Exception e) {
            logMessage(null, "Failed to generate the \"" + IContainer.DEFAULT_DS_BOOTFILE_NAME + "\" file, trace follows...", e,
                       Level.WARNING);
        }
    }

    IDirIdentity[] listDirectories(String parentDir) {
        return m_directory.listDirectories(parentDir);
    }

    IElementIdentity[] listElements(String dirName) {
        return m_directory.listElements(dirName);
    }

    IDirElement[] getAllElements(String dirName) {
        return m_directory.getAllElements(dirName);
    }

    com.sonicsw.mf.common.config.IIdentity[] listAll(String dirName) {
        return m_directory.listAll(dirName);
    }

    IElement[] getConfigurations(String dirName, Boolean acceptChanges) {
        IElement[] configs = null;

        while (true)// first try to get the requested configuration from the cache
        {
            try {
                if (m_configCacheView.getInterestInDir(dirName)) {
                    configs = m_configCacheView.getAllElements(dirName);
                    // If the directory names is not valid throws an exception
                    if (configs == null) {
                        throw new MFRuntimeException(dirName + " is invalid.");
                    }
                } else
                // We never registered interest in this directory - get the elements from the DS
                {
                    configs = m_directory.getAllElements(m_containerIdentity.getCanonicalName(), dirName);

                    // put the configurations retrieved from the DS in the cache
                    setElements(configs);
                    if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
                        logMessage(null, "Configurations [" + dirName + "] added to cache", Level.TRACE);
                    }

                    m_configCache.setInterestInDir(dirName);
                }

                break;
            } catch (VersionOutofSyncException e) {
                // Should never happen
                logMessage(null, e, Level.SEVERE);
                shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
                break;
            } catch (CacheException e) {
                MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
                re.initCause(e);
                throw re;
            } catch (InvokeTimeoutException e) {
                if (m_generateCache && !m_isClosing) // infinite retry
                {
                    logMessage(null, "Timeout while obtaining multiple configurations [" + dirName + ", retry initiated", Level.WARNING);
                    continue;
                } else {
                    throw e;
                }
            }
        }

        return configs;
    }

    IDirElement getRuntimeConfiguration(String id, String type) {
        return m_runtimeConfigurationManager.getRuntimeConfiguration(id, type, false);
    }

    IDirElement getRuntimeConfigurationFromContainerCache(String id, String type) {
        return m_runtimeConfigurationManager.getRuntimeConfiguration(id, type, true);
    }

    void setRuntimeConfiguration(IDirElement config) {
        m_runtimeConfigurationManager.setRuntimeConfiguration(config, false);
    }

    void setRuntimeConfigurationInCacheOnly(IDirElement config) {
        m_runtimeConfigurationManager.setRuntimeConfiguration(config, true);
    }

    private void deleteRuntimeElement(String configID) {
        m_runtimeConfigurationManager.deleteRuntimeConfiguration(configID, false);
    }

    private void deleteRuntimeElementFromCacheOnly(String configID) {
        m_runtimeConfigurationManager.deleteRuntimeConfiguration(configID, true);
    }

    void makeGlobalComponentUniquenessCall(String globalComponentID, String callID) throws Exception {
        makeGlobalComponentUniquenessCall(globalComponentID, callID, null);
    }

    void makeGlobalComponentUniquenessCall(String globalComponentID, String callID, String instanceID) throws Exception {
        try {
            String containerID = (instanceID == null ? globalComponentID : JMSConnectorServer.getPseudoContainerID(globalComponentID,
                                                                                                                   instanceID));

            String canonicalName = new CanonicalName(m_containerIdentity.getDomainName(), containerID, globalComponentID).getCanonicalName();
            m_connector.invokeOneway(IContainer.INTERNAL_COMMS_TYPE, canonicalName, canonicalName, "uniquenessCheck",
                                     new Object[] { m_containerIdentity.getCanonicalName(), callID },
                                     new String[] { String.class.getName(), String.class.getName() }, 0);
        } catch (InvokeTimeoutException e) {
        } // If we cannot publish the uniquenessCheck() call then we just give up
    }

    //
    // Private methods
    //

    /**
     * Perform framework loading to get the container in a started state. A started state is one where the container has
     * loaded the bootstrap framework components and is then in a position to start loading other components.
     */
    private void bootFramework(String containerConfigID) throws Exception {
        // load the container configuration from the cache
        m_containerConfig = (IDirElement)m_configCacheView.getElement(containerConfigID);
        m_containerIdentity = new ContainerIdentity(m_containerConfig);
        IAttributeSet containerAttrs = m_containerConfig.getAttributes();

        // since we now have the full configuration, we can...

        // .. test if the DS should be loaded
        Boolean hostsDS = (Boolean)containerAttrs.getAttribute(IContainerConstants.HOSTS_DIRECTORY_SERVICE_ATTR);

        // .. get the maximum data memory of the cache and set it
        IAttributeSet cacheAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.CACHE_ATTR);
        Integer maxDataMemory = (Integer)cacheAttrs.getAttribute(IContainerConstants.MAXIMUM_DATA_MEMORY_ATTR);
        m_configCache.adjustSize(maxDataMemory);

        // .. get the configured thread pool settings and set them
        Integer maxThreads = (Integer)containerAttrs.getAttribute(IContainerConstants.MAX_THREADS_ATTR);
        if (maxThreads != null) {
            m_taskScheduler.setMaxThreads(maxThreads.intValue());
        }
        Integer minThreads = (Integer)containerAttrs.getAttribute(IContainerConstants.MIN_THREADS_ATTR);
        if (minThreads != null) {
            m_taskScheduler.setMinThreads(minThreads.intValue());
        }

        // .. get the max notification publishing queue size
        Integer queueSize = (Integer)containerAttrs.getAttribute(IContainerConstants.NOTIFICATION_DISPATCH_QUEUE_SIZE_ATTR);
        if (queueSize != null) {
            m_notificationPublisher.setQueueSize(queueSize.intValue());
        }

        // .. get the DS ping frequency and set it
        setDSPingFrequency((Integer)containerAttrs.getAttribute(IContainerConstants.DIRECTORY_SERVICE_PING_INTERVAL_ATTR));

        // .. determine the Sonic archive search path
        setSonicArchiveSearchPath((String)containerAttrs.getAttribute(IContainerConstants.ARCHIVE_SEARCH_PATH_ATTR));

        // .. determine if this is an FT container
        IAttributeSet ftAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.FAULT_TOLERANCE_PARAMETERS_ATTR);
        m_isFTContainer = ftAttrs != null;
        if (m_isFTContainer) {
            String ftRole = (String)ftAttrs.getAttribute(IContainerConstants.FAULT_TOLERANCE_ROLE_ATTR);
            if (ftRole == null || ftRole.length() == 0) {
                m_isFTContainer = false;
            }
        }

        // log if we are generating the cache
        if (m_generateCache) {
            String msg = m_generateCacheUtil ? "Generating configuration cache" : "Updating configuration cache";
            logMessage(null, msg + " for container \"" + m_containerIdentity.getCanonicalName() + "\"...", Level.INFO);
        }

        logMessage(null, getConfigMessage(containerAttrs), Level.CONFIG);
        validateConfig(containerAttrs);

        if (!m_generateCache) {
            logMessage(null, '"' + m_containerIdentity.getCanonicalName() + "\" starting...", Level.INFO);
        }

        // any development classpath overrides to log?
        String devClasspath = null;
        devClasspath = System.getProperty(IContainer.MF_DEV_GLOBAL_CLASSPATH_PROPERTY);
        if (devClasspath != null) {
            m_container.logMessage(null, "Using global classpath prepended with: " + devClasspath, Level.CONFIG);
        }
        devClasspath = System.getProperty(IContainer.MF_DEV_SHAREDLIBRARY_CLASSPATH_PROPERTY);
        if (devClasspath != null) {
            m_container.logMessage(null, "Using shared library classpaths prepended with: " + devClasspath, Level.CONFIG);
        }
        // any development overrides?
        devClasspath = System.getProperty(IContainer.MF_DEV_PRIVATE_CLASSPATH_PROPERTY);
        if (devClasspath != null) {
            m_container.logMessage(null, "Using private classpaths prepended with: " + devClasspath, Level.CONFIG);
        }

        if (System.getProperty("disableShutdownHook", "false").equals("false")) {

            final Thread shutdownHook = new Thread() {
                @Override
                public void run() {
                    if (m_isBooted) {
                        m_agent.shutdown(IContainerExitCodes.NORMAL_SHUTDOWN_EXIT_CODE);
                    } else {
                        shutdown(m_containerExitCode.getExitCode());
                    }

                    synchronized (m_containerExitCode) {
                        while (!m_containerExitCode.exit()) {
                            try {
                                m_containerExitCode.wait(1000);
                            } catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
            };

            shutdownHook.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }

        if (Integer.getInteger(IContainer.MF_QA_ABORT_PROPERTY, 0).longValue() > 0) {
            m_abortMonitor = new Monitor();
            m_abortMonitor.start();
        }

        // create the JMX MBeanServer
        bootMBeanServer();

        // load the connector
        loadConnectorServer(containerAttrs);

        // Create a proxy for the DS
        m_directory = new ContainerDS(this, m_connector, m_containerIdentity, IContainer.INTERNAL_COMMS_TYPE);
        m_hostManager = new HostManager(m_containerIdentity.getDomainName(), m_containerIdentity.getCanonicalName(), this);

        // Set the first parameter - the DS - to null since the first getLocalFile call with ARCHIVE_NAME_ATTR should
        // not try
        // to acces the DS, just use the cache (see SNC00075779). After that getLocalFile call we call
        // m_fileManager.setBlobSource(m_directory)
        m_fileManager = new LocalFileManager(null, m_configCache, new ContainerLogger(), m_containerIdentity.getCanonicalName());

        // tell the cache that MFcontainer.car is in use
        String archiveName = (String)containerAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR);
        if (archiveName != null) {
            m_fileManager.getLocalFile(m_sonicArchiveSearchPath, archiveName);
        }

        m_fileManager.setBlobSource(m_directory);

        // create a manager for runtime configurations such as enabled metrics and alerts
        m_runtimeConfigurationManager = new RuntimeConfigurationManager(this, m_configCache, m_directory);

        // now we have a proxy for the DS we can start loading components..

        // .. load the AGENT first
        Integer traceMask = (Integer)containerAttrs.getAttribute(IContainerConstants.TRACE_MASK_ATTR);
        if (traceMask == null) {
            traceMask = new Integer(IContainerConstants.TRACE_MASK_DEFAULT);
        }
        AbstractMBean mBean = (AbstractMBean)loadComponent(IAgentProxy.ID, containerConfigID, true, traceMask.intValue(), true);
        m_agent = (Agent)mBean.getManagedComponent();
        m_agentMBean = mBean;
        startComponent(IAgentProxy.ID, m_agent, true); // always start agent component no matter FT container or not

        // ensure we pass the traceMask to the Filemanager (needed for correct logging)
        m_fileManager.setTraceMask(null != m_agent ? m_agent.m_traceMask : 0);

        // .. then load the DS if required
        if (hostsDS != null && hostsDS.booleanValue()) {
            if (isFTContainer()) // FT container
            {
                String errMessage = "Hosting DS in an FT container is not supported";
                logMessage(null, errMessage, Level.SEVERE);
                shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
            } else {
                loadDirectoryService(containerAttrs);
            }
        }

        // setup the URLStreamHandlerFactory instance for various URLStreamHandler(s)
        SonicURLStreamHandlerFactoryImpl urlStreamHandlerFactory = new SonicURLStreamHandlerFactoryImpl(this);
        try {
            URL.setURLStreamHandlerFactory(urlStreamHandlerFactory);
        } catch (Throwable e) {
            if (!m_isLSD) {
                logMessage(null, "Failed to set URLStreamHandlerFactory, trace follows...", e, Level.SEVERE);
            }
        }

        m_directory.setURLStreamHandlerFactory(urlStreamHandlerFactory);

        // now weve loaded the DS we can setup fine grained security before allowing external calls
        m_agent.initFineGrainedSecurity();

        // the HTML adaptor property is for internal use only and should not be published
        if (System.getProperty("htmlAdaptor", "false").equals("true")) {
            try {
                int port = Integer.parseInt(System.getProperty("htmlAdaptor.port", "8082"));
                // do through reflection to avoid dependency on jmxtools.jar when not needed
                Class htmlAdaptorClass = m_defaultClassLoader.loadClass("com.sun.jdmk.comm.HtmlAdaptorServer");
                Constructor constructor = htmlAdaptorClass.getConstructor(new Class[] { int.class });
                DynamicMBean htmlAdaptor = (DynamicMBean)constructor.newInstance(new Object[] { new Integer(port) });
                m_mbeanServer.registerMBean(htmlAdaptor, new ObjectName("Adaptor:name=html,port=" + port));
                htmlAdaptor.invoke("start", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
            } catch (Throwable e) {
                logMessage(null, e, Level.SEVERE);
            }
        }

        // now we have the AGENT loaded, we can start handling requests
        m_externalRequestHandler = new ExternalRequestHandler();
        m_connectorHandback = m_connector.addRequestHandler(m_externalRequestHandler);

        if (m_isClosing) {
            throw new ShutdownInProgressException();
        }

        // now we have the connector setup we can...
        // .. reconcile the cache with the DS
        reconcileCache();
        // .. set the initial backup version
        if (m_configCacheView.getDSBackupVersion() == null) {
            m_configCache.setDSBackupVersion(getBackupTimestampFromDS());
        }
        // .. starts a thread that periodically renews config subscriptions at the ds, monitor DS availability and
        // reconcile the cache if the DS becomes available after being unavailable; we monitor in frequency of half
        // of the subscription expiration time to make sure subscriptions don't expire before we renew.
        startDSMonitoringThread(m_dsPingFrequency, !m_dsNotInitiallyAccessible);

        // if this is a FT Container, initialize container FT
        if (isFTContainer() && !m_generateCache) {
            m_containerFT = new ContainerFT(this, m_connector);
        }

        // load any components specified in the containers configuration
        // If this is a FT container, the auto-start components loaded here are not started.
        // They are started by FT state controller when this container transits to FT ACTIVE state.
        loadAllConfiguredComponents(containerAttrs);

        // if were just generating the cache, then log the fact that weve completed this and shutdown
        if (m_generateCache) {
            String cacheDirName = null;
            cacheDirName = m_configCache.getCacheRootDirectory().getPath();

            try {
                String restartingMsg = (m_generateCacheUtil) ? "" : " - restarting...";
                logMessage(null,
                           "...cache "
                               + (!m_generateCacheUtil ? "updated" : "generated") + " in \"" + new File(cacheDirName).getCanonicalPath()
                               + '"' + restartingMsg, Level.INFO);
            } catch (IOException e) {
            } // can't occur .. otherwise we wouldn't have been able to create the cache!

            // If we generated the cache in a deployed container from a central connection - create file telling the
            // launcher to configure from cache and restart
            if (m_generateCache && !m_generateCacheUtil) {
                File configureFromCacheFile = new File(IContainer.CONFIGURE_FROM_CACHE_FILE);
                new FileOutputStream(configureFromCacheFile, true).close();
            }
            shutdown(m_generateCacheUtil ? IContainerExitCodes.NORMAL_SHUTDOWN_EXIT_CODE : IContainerExitCodes.CONTAINER_RESTART_EXIT_CODE);
        }

        // finally indicate the startup has completed
        setContainerStartupComplete();
    }

    HostManager getHostManager() {
        return m_hostManager;
    }

    private String getConfigMessage(IAttributeSet containerAttrs) {
        StringBuffer message = new StringBuffer(IContainer.NEWLINE);

        // MF/Sonic info
        message.append(IContainer.NEWLINE);
        message.append('\t').append(Version.getProductName()).append(IContainer.NEWLINE);
        message.append('\t').append(Version.getVersionText()).append(IContainer.NEWLINE);
        message.append('\t').append("Copyright (c) 2015. Aurea Software, Inc.").append(IContainer.NEWLINE);
        message.append('\t').append("All rights reserved.").append(IContainer.NEWLINE);

        // Host / OS info
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Local host: ");
        message.append(System.getProperty(IContainer.CONTAINER_PRIVATE_HOST_PROPERTY));
        if (System.getProperty("os.name") != null) {
            message.append(" (").append(System.getProperty("os.name"));
            if (System.getProperty("os.version") != null) {
                message.append(" - ").append(System.getProperty("os.version"));
            }
        }
        message.append(')').append(IContainer.NEWLINE);
        if (System.getProperty(IContainer.CONTAINER_PUBLIC_HOST_PROPERTY).length() > 0) {
            message.append('\t').append("External host: ");
            message.append(System.getProperty(IContainer.CONTAINER_PUBLIC_HOST_PROPERTY));
            message.append(IContainer.NEWLINE);
        }
        message.append('\t').append("Available Processors: ");
        message.append(java.lang.Runtime.getRuntime().availableProcessors());
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Java Process ID: ");
        message.append(java.lang.management.ManagementFactory.getRuntimeMXBean().getName());
        message.append(IContainer.NEWLINE);

        // JVM info
        message.append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.runtime.name")).append(" (build ")
               .append(System.getProperty("java.runtime.version")).append(')').append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.vm.vendor")).append(" (home ").append(System.getProperty("java.home"))
               .append(", version ").append(System.getProperty("java.version")).append(')').append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.vm.name")).append(" (build ").append(System.getProperty("java.vm.version"))
               .append(", ");
        String javaVMInfo = System.getProperty("java.vm.info");
        if (javaVMInfo.indexOf(')') > 0) {
            javaVMInfo = javaVMInfo.substring(0, javaVMInfo.indexOf(')') + 1);
        }
        message.append(javaVMInfo).append(')').append(IContainer.NEWLINE);

        // Configured args/props info
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Configured Arguments : ");
        String args = (String)containerAttrs.getAttribute(IContainerConstants.JVM_ARGUMENTS_ATTR);
        if (args != null && args.length() > 0) {
            message.append(containerAttrs.getAttribute(IContainerConstants.JVM_ARGUMENTS_ATTR));
        } else {
            message.append("<none>");
        }
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Configured Properties: ");
        IAttributeSet systemProps = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.SYSTEM_PROPERTIES_ATTR);
        if (systemProps != null && systemProps.getAttributes().size() > 0) {
            Iterator iterator = systemProps.getAttributes().entrySet().iterator();
            for (int i = 0; iterator.hasNext(); i++) {
                if (i > 0) {
                    message.append(" ");
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                String propertyName = (String)entry.getKey();
                message.append("-D").append(propertyName).append('=');
                String propertyValue = (String)entry.getValue();
                if (propertyValue != null && propertyValue.length() > 0) {
                    if (propertyName.equals("sonicsw.mf.ft.user") || propertyName.equals("sonicsw.mf.ft.password")) {
                        message.append("..."); // mask the username and password from display
                    } else {
                        message.append('"').append(propertyValue).append('"');
                    }
                }
            }
        } else {
            message.append("<none>");
        }
        message.append(IContainer.NEWLINE);

        return message.toString();
    }

    /**
     * Warns user of possible inconsistencies in the JVM/Container environment settings Currently the only check relates
     * to the -Xrs parameter, but further tests may be added in the future.
     */
    private void validateConfig(IAttributeSet containerAttrs) {
        boolean runningAsWindowsService = false;
        boolean xrsFlagSet = false;
        boolean utilLibEnabled = false;

        // Check whether -Xrs is specified. Add a space prefix/postfix to ensure a
        // match for ' -Xrs ' even if it's the first/last entry
        String args = " " + containerAttrs.getAttribute(IContainerConstants.JVM_ARGUMENTS_ATTR) + " ";
        xrsFlagSet = args.indexOf(" -Xrs ") >= 0;

        // Check whether the Windows native util library has been enabled
        String winsvcUtilDir = System.getProperty(IContainer.WINSVC_UTILDIR_PROPERTY);
        utilLibEnabled = winsvcUtilDir != null && winsvcUtilDir.trim().length() > 0;
        runningAsWindowsService = winsvcUtilDir != null;

        if (runningAsWindowsService && !xrsFlagSet && !utilLibEnabled) {
            logMessage(null,
                       "Container appears to have been launched as a Windows Service without the sonicmfUtil DLL, and -Xrs is not specified.  Container may terminate unexpectedly.  Use of sonicmfUtil is recommended (try reinstalling the Windows Service), otherwise use -Xrs.",
                       Level.WARNING);
        }

        // If non-empty WINSVC_UTILDIR_PROPERTY specified then sonicmfUtil.dll will have
        // been loaded successfully, otherwise container startup would have failed and we
        // wouldn't have reached this point.
        if (xrsFlagSet && utilLibEnabled) {
            logMessage(null,
                       "Container appears to have been launched as a Windows Service and the sonicmfUtil DLL is available.  The -Xrs flag is not required and should be removed.",
                       Level.WARNING);
        }
    }

    private void exhaustPendingLogMessageQueue() {
        if (m_agent == null) {
            return;
        }

        while (!m_pendingLogMessageQueue.isEmpty()) {
            JMSConnectorServer connector = m_connector;
            if (connector == null) {
                return;
            }
            if (!connector.isConnected()) {
                return;
            }

            synchronized (m_reloadingIDs) // can't log to AM if were reloading it
            {
                if (m_reloadingIDs.contains(IAgentManagerProxy.GLOBAL_ID)) {
                    return;
                }
            }

            synchronized (m_pendingLogMessageQueue) {
                if (m_pendingLogMessageQueue.isEmpty()) {
                    return;
                }

                String timestampedMessage = (String)m_pendingLogMessageQueue.get(0);
                boolean bestEffortLogged = false;

                try {
                    if (m_agent.centrallyLogMessage(timestampedMessage)) {
                        bestEffortLogged = true;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (bestEffortLogged) {
                    m_pendingLogMessageQueue.remove(0);
                } else {
                    return; // typically the logging has not been initialized yet
                }
            }
        }
    }

    ContainerDS getDS() {
        return m_directory;
    }

    // //////////////////////// Container FT ////////////////////

    ContainerFT getContainerFT() {
        return m_containerFT;
    }

    boolean isFTContainer() {
        return m_isFTContainer;
    }

    Boolean getAllowFailover() {
        return isFTContainer() ? new Boolean(m_allowFailover) : null;
    }

    void setAllowFailover(Boolean allowFailover) {
        if (!isFTContainer()) {
            throw new IllegalStateException("Setting of this attribute is not supported for a non-FT container");
        }

        boolean allow = allowFailover.booleanValue();
        if (allow != m_allowFailover) {
            if (!m_containerFT.isActive()) {
                logMessage(m_containerIdentity.getContainerName(), "FT container failover " + (allow ? "reenabled" : "disabled"),
                           allow ? Level.INFO : Level.WARNING);
            }
            m_allowFailover = allow;
        }
    }

    // notification
    void sendFailoverNotification() {
        m_agent.sendFailoverNotification();
    }

    // Agent uses pingThread to do suspendActive operation
    PingThread getPingThread() {
        return m_containerFT.getPingThread();
    }

    void expireSubscription(NotificationListenerDelegate delegate) {
        synchronized (m_notificationListeners) {
            // should be able to ignore failures to remove
            try {
                m_mbeanServer.removeNotificationListener(delegate.getObjectName(), delegate);
            } catch (OperationsException e) {
            }
            delegate.removeAllHandbackFilterPairs();
            deleteNotificationListenerSubscriptionsFromCache(delegate);
            m_notificationListeners.remove(delegate.getRemoteListenerKey());
            delegate.close();
        }

        if ((m_agent.m_traceMask & Agent.TRACE_SUBSCRIPTION_EXPIRATIONS) > 0) {
            logMessage(IAgentProxy.ID,
                       "Expired management notification subcription(s) from JMX client "
                           + m_connector.getJMXClientHostAndID(delegate.getDestination()) + " to \""
                           + new CanonicalName(delegate.getObjectName().getCanonicalName()).getComponentName() + "\"", Level.TRACE);
        }
    }

    void setFailingOver(boolean isFailingOver) {
        m_isFailingOver = isFailingOver;
    }

    boolean isFailingOver() {
        return m_isFailingOver;
    }

    private boolean isAutoStartComponent(String componentId) {
        if (m_generateCache) {
            return false; // if we are in cache generating mode we don't need to start the component
        }

        boolean autostart = IContainerConstants.AUTO_START_DEFAULT;

        IAttributeSet attrsOfComps = (IAttributeSet)m_containerConfig.getAttributes().getAttribute(IContainerConstants.COMPONENTS_ATTR);
        if (attrsOfComps == null) {
            return autostart;
        }

        IAttributeSet theCompAttrs = (IAttributeSet)attrsOfComps.getAttribute(componentId);
        if (theCompAttrs == null) {
            return autostart;
        }

        Boolean AutoStart = (Boolean)theCompAttrs.getAttribute(IContainerConstants.AUTO_START_ATTR);
        autostart = (AutoStart == null) ? IContainerConstants.AUTO_START_DEFAULT : AutoStart.booleanValue();
        return autostart;
    }

    // called by container FT when a waiting/standby container turns active
    void startComponents() {
        synchronized (m_containerDelegate) {
            while (!m_isClosing && !m_isBooted) {
                try {
                    m_containerDelegate.wait();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (m_isClosing) {
                return;
            }
        }

        HashMap appComponents = new HashMap(); // key:id, value:component

        // loop through framework components to start them
        Iterator compEntryIter = m_mBeans.entrySet().iterator();
        while (compEntryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)compEntryIter.next();
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
            IComponent component = mBean.getManagedComponent();
            String id = (String)entry.getKey();

            if (!isAutoStartComponent(id)) {
                continue;
            }

            if (ContainerUtil.isFrameworkComponent(component.getClass())) // have to use introspection since it will be
                                                                          // a different class loader
            {
                try {
                    synchronized (m_containerDelegate) {
                        // agent is always started in bootFramework. Therefore, we don't need to start agent here.
                        if ((component != null) && !id.equals(IAgentProxy.ID)) {
                            startComponent(id, component, true);
                        }
                        m_containerDelegate.notifyAll();
                    }
                } catch (Throwable e) {
                    logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, Level.WARNING);
                }
            } // framework component
            else {
                // keep application components to start later
                appComponents.put(id, component);
            }
        } // for

        // loop through application components to start them
        Iterator appEntryIter = appComponents.entrySet().iterator();
        ;
        while (appEntryIter.hasNext()) {
            Map.Entry appEntry = (Map.Entry)appEntryIter.next();
            String id = (String)appEntry.getKey();

            if (!isAutoStartComponent(id)) {
                continue;
            }

            IComponent component = (IComponent)appEntry.getValue();
            try {
                if (component != null) {
                    synchronized (m_containerDelegate) {
                        startComponent(id, component, false);
                        m_containerDelegate.notifyAll();
                    }
                }
            } catch (Throwable e) {
                logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, Level.WARNING);
            }
        }
    }

    void stopComponents() {
        if (m_isClosing) {
            return;
        }

        HashMap frameworkComponents = new HashMap(); // key:id, value:framework component
        // loop through application components unloading them
        Iterator compEntryIter = m_mBeans.entrySet().iterator();
        while (compEntryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)compEntryIter.next();
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
            IComponent component = mBean.getManagedComponent();
            String id = (String)entry.getKey();
            if (ContainerUtil.isFrameworkComponent(component.getClass())) // have to use introspection since it will be
                                                                          // a different class loader
            {
                // keep framework components to stop after application components
                frameworkComponents.put(id, component);
            } else {
                try {
                    synchronized (m_containerDelegate) {
                        component.stop();
                        m_containerDelegate.notifyAll();
                    }
                } catch (Throwable e) {
                    logMessage(null, "Failed to stop ID=" + id + ", trace follows...", e, Level.WARNING);
                }
            }
        }

        // loop through framework components to stop them
        Iterator frameworkEntryIter = frameworkComponents.entrySet().iterator();
        while (frameworkEntryIter.hasNext()) {
            Map.Entry frameworkEntry = (Map.Entry)frameworkEntryIter.next();
            String id = (String)frameworkEntry.getKey();
            IComponent component = (IComponent)frameworkEntry.getValue();
            try {
                if ((component != null) && !id.equals(IAgentProxy.ID)) {
                    synchronized (m_containerDelegate) {
                        component.stop();
                        m_containerDelegate.notifyAll();
                    }
                }
            } catch (Throwable e) {
                logMessage(null, "Failed to stop ID=" + id + ", trace follows...", e, Level.WARNING);
            }
        }
    }

    /**
     * Create the MBeanServer and setup any initial MBeans
     */
    private void bootMBeanServer() throws Exception {
        if (m_isLSD) {
            // we need a separate MBeanServer per collocated container instance
            m_mbeanServer = MBeanServerFactory.createMBeanServer(getContainerIdentity().getCanonicalName());
        } else {
            // to allow compilation in jdk1.5 need to get default MBeanServer using reflection and to not
            // break 1.4
            try {
                Class managementFactoryClass = m_defaultClassLoader.loadClass("java.lang.management.ManagementFactory");
                Method getPlatformMBeanServerMethod = managementFactoryClass.getMethod("getPlatformMBeanServer",
                                                                                       IEmptyArray.EMPTY_CLASS_ARRAY);
                m_mbeanServer = (MBeanServer)getPlatformMBeanServerMethod.invoke(null, IEmptyArray.EMPTY_OBJECT_ARRAY);
            } catch (ClassNotFoundException e) {
                m_mbeanServer = MBeanServerFactory.createMBeanServer(getContainerIdentity().getCanonicalName());
            }
        }
        m_mbeanServerClass = m_mbeanServer.getClass();

        // now add a MLet to service generic MBeans created via the MBean server
        MLet mLet = new MLet(m_defaultClassLoader.getURLs(), m_defaultClassLoader.getParent());
        m_mbeanServer.registerMBean(mLet, new ObjectName("Loader:name=Default"));
    }

    private final void setContainerStartupComplete() {
        // If the appropriate system property is set then we send a bell character to indicate
        // startup has completed; we use the bell because its not printable and we write directly
        // to stdout rather than using the logging mechanism (thus it does not get sent to the
        // log file if any).
        // This facility is used only by our NT service and our QA classes to avoid depenedency
        // on looking for a particular startup string like that below !
        if (IContainer.SIGNAL_MODE) {
            System.out.print(IContainer.STARTUP_SIGNAL_CHAR);
            System.out.flush();
        }

        m_isBooted = true;

        // log the start locally
        logMessage(null, "...startup complete", Level.INFO);

        // when were done booting we need to set a flag to indicate were booted
        // and hence changes beyond the boot state can be notified to listeners
        synchronized (m_containerDelegate) {
            // let waiters know we have started
            m_containerDelegate.notifyAll();
        }

        synchronized (this) {
            // let waiters know we have started
            this.notifyAll();
        }

        // send a notification if not running as a cache generation utility
        if (!m_generateCache) {
            Runnable notifier = new Runnable() {
                @Override
                public void run() {
                    m_agent.sendStartupNotification();
                }
            };
            m_taskScheduler.scheduleTask(notifier, false);
        }
    }

    private void loadConnectorServer(IAttributeSet containerAttrs) throws Exception {

        // setup the JMS connector server for the underlying comms
        m_connector = new JMSConnectorServer(this);

        // extract the connector details from the container configuration
        // - once we get to the particular connection factory details, each attribute
        // is a one for one map with the properties required to create a TopicConnectionFactory
        // using its Hashtable constructor
        IAttributeSet connectionAttrs = null;
        if (m_generateCache && !m_generateCacheUtil) {
            connectionAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.CENTRAL_CONNECTION_ATTR);
            if (connectionAttrs == null) {
                logMessage(null, "The cental connection URL is not configured; cannot generate the cache", Level.SEVERE);
                shutdown(IContainerExitCodes.COMMS_FAILURE_EXIT_CODE);
            }
        } else {
            connectionAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.CONNECTION_ATTR);
        }

        String managementNode = (String)connectionAttrs.getAttribute(IContainerConstants.MANAGEMENT_NODE_ATTR);
        if (managementNode != null && managementNode.length() > 0) {
            m_connector.setManagementNode(managementNode);
            m_managementNode = managementNode;

            if (m_containerIdentity.getNodeName() == null || m_containerIdentity.getNodeName().length() == 0) {

                logMessage(IAgentProxy.ID, "If the Management Node is specified as part of the container connection attributes, "
                    + "then this container name must include the node name in which this container has been deployed. "
                    + "The format of the container name, in that case, must be <container>@<nodeName>", Level.SEVERE);

                shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
            }
        }

        // REQUEST_TIMEOUT_ATTR is in seconds, setRequestTimeout is passed millis
        Integer requestTimeout = (Integer)connectionAttrs.getAttribute(IContainerConstants.REQUEST_TIMEOUT_ATTR);
        if (requestTimeout != null) {
            m_connector.setRequestTimeout(requestTimeout.intValue() * 1000);
        }

        // CONNECT_TIMEOUT_ATTR is in seconds, setConnectTimeout is passed millis
        Integer connectTimeout = (Integer)connectionAttrs.getAttribute(IContainerConstants.CONNECT_TIMEOUT_ATTR);
        if (connectTimeout != null) {
            m_connector.setConnectTimeout(connectTimeout.intValue() * 1000);
        }

        // SOCKET_CONNECT_TIMEOUT_ATTR is in seconds, passed to connect() in millis
        Integer socketConnectTimeout = (Integer)connectionAttrs.getAttribute(IContainerConstants.SOCKET_CONNECT_TIMEOUT_ATTR);
        if (socketConnectTimeout != null) {
            final int SOCKET_CONN_TIMEOUT_IN_MILLIS = socketConnectTimeout.intValue() * 1000;
            m_connector.setSocketConnectTimeout(SOCKET_CONN_TIMEOUT_IN_MILLIS);
        }

        // setup to listen for interframework requests (when the connector has established itself)
        m_connector.addRequestHandler(m_internalRequestHandler);

        // now establish the connections to the underlying transport (JMS)
        try {
            Map factoryAttrs = (Map)connectionAttrs.getAttributes().clone();
            factoryAttrs.remove(IContainerConstants.MANAGEMENT_NODE_ATTR);
            factoryAttrs.remove(IContainerConstants.REQUEST_TIMEOUT_ATTR);
            factoryAttrs.remove(IContainerConstants.CONNECT_TIMEOUT_ATTR);
            factoryAttrs.remove(IContainerConstants.SOCKET_CONNECT_TIMEOUT_ATTR);

            // deprecated feature
            factoryAttrs.remove("TRY_DS_AM_BACKUPS_ON_FAILURE");

            // force direct connection attributes if were generating the cache
            if (m_generateCache && m_generateCacheUtil) {
                factoryAttrs.put(IContainerConstants.CONNECTIONURLS_ATTR, m_directConnectionURL);
                factoryAttrs.put(IContainerConstants.DEFAULTUSER_ATTR, m_directConnectionUser);
                factoryAttrs.put(IContainerConstants.DEFAULTPASSWORD_ATTR, m_directConnectionPassword);
            }

            String connectionURLs = (String)factoryAttrs.get(IContainerConstants.CONNECTIONURLS_ATTR);
            if (connectionURLs == null) {
                factoryAttrs.put(IContainerConstants.CONNECTIONURLS_ATTR, DEFAULT_CONNECTION_URLS);
            }
            m_connector.connect(factoryAttrs, 0);
            validateConnectorNodeName(m_connector.getLocalRoutingNodeName());
        } catch (Exception e) {
            if (e instanceof MFRuntimeException) // on initial connect
            {
                Exception linkedException = ((MFRuntimeException)e).getLinkedException();
                if (linkedException instanceof MFProxyRuntimeException) {
                    if (((MFProxyRuntimeException)linkedException).getActualException() instanceof EUserAlreadyConnected) {
                        logMessage(null, '"' + m_containerIdentity.getCanonicalName() + "\" appears to be running elsewhere", Level.SEVERE);
                        shutdown(IContainerExitCodes.CONTAINER_ALREADY_RUNNING_EXIT_CODE);
                    }
                }
            }
            logMessage(IAgentProxy.ID, "Permanent communications failure, trace follows...", e, Level.SEVERE);
            shutdown(IContainerExitCodes.COMMS_FAILURE_EXIT_CODE);
        }
    }

    private void internalReloadComponent(String id, boolean isReloadRoot) {
        try {
            MBeanHolder holder = (MBeanHolder)m_mBeans.get(id);
            if (holder == null) {
                throw new MFException("Unknown ID: " + id);
            }

            AbstractMBean mBean = holder.mBean;
            if (mBean == null) {
                throw new MFException("Unknown ID: " + id);
            }

            if (!mBean.isOperationExported("reload", IEmptyArray.EMPTY_STRING_ARRAY)) {
                throw new MFException(id + " reloading is not supported");
            }

            if (isReloadRoot) {
                logMessage(null, "Reload ID=" + id + " initiated...", Level.INFO);
            }

            // special case if AGENT MANAGER is being reloaded...
            if (id.equals(IAgentManagerProxy.GLOBAL_ID)) {
                // as part of fix for issue reported in Sonic00010555
                logMessage(null, "Unloaded ID=" + id, Level.INFO); // log the unload locally
            }

            // Sonic00019445 - If the component being reloaded is the management broker the container
            // is connected to, we need to give some window in which the reply to the
            // reload can be sent
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
            }

            mBean = holder.mBean;
            holder.waitForRequestCompletion();

            IComponent component = mBean.getManagedComponent();

            // save the values for the load
            String configID = (String)mBean.getAttribute("ConfigID");
            short state = component.getState().shortValue();
            boolean start = (state == IComponentState.STATE_STARTING || state == IComponentState.STATE_ONLINE);
            int traceMask = component.getTraceMask().intValue();

            String[] dependentIDs = ClassLoaderFactory.getDependentComponents(m_containerIdentity.getCanonicalName(), id);

            // now unload and store the details required to load the component again
            unloadComponent(id);
            m_reloadingDetails.put(id, new Object[] { configID, new Boolean(start), new Integer(traceMask) });

            // if this component declared a shared library, we need to unload any of the components that use
            // that shared library (that are not already be unloaded)
            for (int i = 0; i < dependentIDs.length; i++) {
                String dependentID = dependentIDs[i];
                if (dependentID.indexOf(':') > 0) {
                    dependentID = dependentID.substring(dependentID.indexOf(':') + 1);
                }
                boolean reloadDependent = false;
                synchronized (m_reloadingIDs) {
                    if (!m_reloadingIDs.contains(dependentID)) {
                        m_reloadingIDs.add(dependentID);
                        reloadDependent = true;
                    }
                }
                if (reloadDependent) {
                    internalReloadComponent(dependentID, false);
                }
            }

            // if this was the initial component that was unloaded we can now iterate through the total list
            // of components that needs to be loaded
            if (isReloadRoot) {
                Iterator iterator = null;
                synchronized (m_reloadingIDs) {
                    iterator = ((ArrayList)m_reloadingIDs.clone()).iterator();
                }
                while (iterator.hasNext()) {
                    String reloadID = (String)iterator.next();
                    Object[] details = (Object[])m_reloadingDetails.get(reloadID);
                    configID = (String)details[0];
                    start = ((Boolean)details[1]).booleanValue();
                    traceMask = ((Integer)details[2]).intValue();
                    loadComponent(reloadID, configID, start, traceMask, false);
                }

                logMessage(null, "...reload ID=" + id + " complete", Level.INFO);
            }
        } catch (Throwable t) {
            if (isReloadRoot) {
                logMessage(null, "...reload ID=" + id + " failed, trace follows...", t, Level.SEVERE);
            }
        } finally {
            if (isReloadRoot) {
                synchronized (m_reloadingIDs) {
                    m_reloadingIDs.clear();
                    m_reloadingDetails.clear();
                    m_reloadingIDs.notifyAll();
                }
            }
        }
    }

    // validate that the configuration is consistent with the node we are connected to in theMF over DRA case
    private void validateConnectorNodeName(String localRoutingNode) {
        String containerNodeName = null;
        if (m_containerIdentity != null) {
            containerNodeName = m_containerIdentity.getNodeName();
        }

        if (!m_generateCache
            && // We don't do this check when generating cache
            containerNodeName != null && containerNodeName.length() > 0 && localRoutingNode != null
            && !localRoutingNode.equals(containerNodeName)) {
            String msg = "The container node name ["
                + containerNodeName + "] does not match the local management broker node name [" + localRoutingNode
                + "]. Check the container configuration reflects the URL(s) of the local management broker(s).";
            logMessage(null, msg, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        }

        if (m_generateCache
            && // We do this check when generating cache thru the utility
            m_generateCacheUtil && containerNodeName != null && containerNodeName.length() > 0 && localRoutingNode != null
            && !localRoutingNode.equals(m_managementNode)) {
            String msg = "A management node must be specified in the containers configuration. Modify and regenerate the container's XML boot or file (or edit the container INI file)";
            logMessage(null, msg, Level.SEVERE);
            shutdown(IContainerExitCodes.CONFIGURATION_FAILURE_EXIT_CODE);
        }

    }

    /**
     * Load the Directory Service component.
     */
    private void loadDirectoryService(IAttributeSet containerAttrs) throws Exception {
        // get the container's components list
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.COMPONENTS_ATTR);
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();

        // find the DS component configuration and load DS when found
        for (int i = 0; i < components.length; i++) {
            if (m_isClosing) {
                throw new ShutdownInProgressException();
            }
            Map.Entry componentEntry = (Map.Entry)components[i];
            String id = (String)componentEntry.getKey();

            if (id.equals(DSComponent.GLOBAL_ID)) {
                loadConfiguredComponent(id, (IAttributeSet)componentEntry.getValue(), false, true);
                break;
            }
        }
    }

    // Is the source of this throwable a timeout problem?
    private boolean containsTimeout(Throwable t) {
        while (true) {
            if (t == null) {
                return false;
            }

            if (t instanceof com.sonicsw.mf.comm.InvokeTimeoutException) {
                return true;
            }

            if (t instanceof MFException) {
                t = ((MFException)t).getLinkedException();
            } else if (t instanceof MFRuntimeException) {
                t = ((MFRuntimeException)t).getLinkedException();
            } else {
                return false;
            }
        }
    }

    // Cache a file if not already in cache
    void cacheFileIfNeeded(String dsAbsolutePath, boolean silentFailure, boolean reconcileCache) throws Exception {
        if (reconcileCache) {
            reconcileCache(); // Make sure the cache knows about any modified files before we refresh
        }

        if (!dsAbsolutePath.startsWith(IContainer.DS_CLASSPATH_PROTOCOL)) {
            if (!dsAbsolutePath.startsWith("/")) {
                throw new MFException("\""
                    + dsAbsolutePath + "\" is malformed - must be prefixed with \" " + IContainer.DS_CLASSPATH_PROTOCOL + "\" or with '/'");
            }
            dsAbsolutePath = IContainer.DS_CLASSPATH_PROTOCOL.substring(0, IContainer.DS_CLASSPATH_PROTOCOL.length() - 1) + dsAbsolutePath;
        }

        if (getLocalFile(dsAbsolutePath) == null) {
            if (!silentFailure) {
                throw new MFException("\"" + dsAbsolutePath + "\" was not found");
            }
        }

    }

    // Cache archives which are not already in cache
    void cacheAllArchivesIfNeeded() throws Exception {
        reconcileCache(); // Make sure the cache knows about any modified files before we refresh
        ArrayList archiveList = getAllArchiveNames();
        for (int i = 0; i < archiveList.size(); i++) {
            if (m_fileManager.getLocalFile(m_sonicArchiveSearchPath, (String)archiveList.get(i)) == null) {
                logMessage(null, "Could not download archive file \" " + archiveList.get(i) + "\"", Level.WARNING);
            }
        }
    }

    void downloadArchives(String dsArchivePath, String newVersion) throws Exception {
        reconcileCache(); // Make sure the cache knows about any modified files before we refresh

        ArrayList archiveList = getAllArchiveNames();

        // Replaces each archive path with a path where the old version is replaced by the new one
        for (int i = 0; i < archiveList.size(); i++) {
            archiveList.set(i, replaceVersion((String)archiveList.get(i), newVersion));
        }

        // Down load from the DS each file (if needed)
        for (int i = 0; i < archiveList.size(); i++) {
            cacheFileIfNeeded(dsArchivePath + archiveList.get(i), true, false);
        }
    }

    private static String replaceVersion(String dsArchivePath, String newVesion) {
        File path = new File(dsArchivePath);
        ArrayList pathItems = new ArrayList();
        boolean versionFound = false;
        while (path != null) {
            String name = path.getName();
            if (!versionFound && Character.isDigit(name.charAt(0))) {
                name = newVesion;
                versionFound = true;
            }
            pathItems.add(0, name);
            path = path.getParentFile();
        }

        String newPath = "";
        for (int i = 0; i < pathItems.size(); i++) {
            newPath += (String)pathItems.get(i);
            if (i + 1 < pathItems.size()) {
                newPath += "/";
            }
        }
        return newPath;
    }

    // Extract the names of all the archives - uses fresh configuration elements from the DS rather then the cached
    // ones, since this might be called
    // while notifications from the DS are turned off for upgrade.
    private ArrayList getAllArchiveNames() throws Exception {
        ArrayList archiveList = new ArrayList();
        IElement freshContainerConfig = getConfiguration(m_containerConfig.getIdentity().getName(), true);

        IAttributeSet containerAttrs = freshContainerConfig.getAttributes();
        archiveList.add(containerAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR));

        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.COMPONENTS_ATTR);
        if (componentsAttrs == null) {
            return archiveList;
        }

        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();

        for (int i = 0; i < components.length; i++) {
            Map.Entry componentEntry = (Map.Entry)components[i];
            IAttributeSet compSet = (IAttributeSet)componentEntry.getValue();
            String componentConfigID = ((Reference)compSet.getAttribute(IContainerConstants.CONFIG_REF_ATTR)).getElementName();
            IElement componentConfig = getConfiguration(componentConfigID, true);
            IAttributeSet componentAttrs = componentConfig.getAttributes();
            String archiveName = (String)componentAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR);

            if (archiveName != null) {
                // Would be null for a DIRECTORY SERVICE component
                archiveList.add(archiveName);
            }
        }

        return archiveList;
    }

    private final AbstractMBean internalLoadComponent(String id, String configID, int traceMask, boolean frameworkOnly) throws Exception {
        if (m_mBeans.containsKey(id)) {
            throw new MFException("Component ID already exists: " + id);
        }

        // get the configuration element
        IElement componentConfig = getConfiguration(configID);
        if (componentConfig == null) {
            throw new MFException("Configuration unavailable: " + configID);
        }

        // we have to start out with the assumption that it could be a framework component
        boolean isFrameworkComponent = true;

        // get the classname, archive and classpath from the configuration
        IAttributeSet componentAttrs = componentConfig.getAttributes();
        String classname = (String)componentAttrs.getAttribute(IContainerConstants.CLASSNAME_ATTR);
        Class componentClass = null;
        if (id.equals(IAgentProxy.ID) || id.equals(IDirectoryServiceProxy.GLOBAL_ID)) {
            ClassLoader loader = m_defaultClassLoader;
            componentClass = loader.loadClass(classname);
        } else {
            // create the shared libraries required by this component (if this component is being loaded
            // from the initial boot then the shared libaries will have already been created, however
            // this is not the case if a component is dynamically loaded)
            if (!createDeclaredSharedLibraries(id, componentAttrs)) {
                return null;
            }
            if (!createDependentSharedLibraries(id, componentAttrs)) {
                return null;
            }

            // get the archive for the component
            String archiveName = (String)componentAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR);
            File archiveFile = m_fileManager.getLocalFile(m_sonicArchiveSearchPath, archiveName);

            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveFile);

            // construct the aggregate private classpath for the component
            String classpath = (String)componentAttrs.getAttribute(IContainerConstants.CLASSPATH_ATTR);
            ArrayList classpathURLs = translateClasspath(id, classpath);
            URL[] urls = archive.getPrivateClasspath();
            for (int i = 0; i < urls.length; i++) {
                classpathURLs.add(urls[i]);
            }
            urls = (URL[])classpathURLs.toArray(ExpandedSonicArchive.EMPTY_URL_ARRAY);

            // create the class loader
            ClassLoader loader = createDelegatingLoader(id, urls, archive, componentConfig, true);
            componentClass = loader.loadClass(classname);

            // test if the component is a framework component
            isFrameworkComponent = ContainerUtil.isFrameworkComponent(componentClass);
            if (!isFrameworkComponent) {
                if (frameworkOnly) {
                    return null;
                }

                // else create a new class loader without the $MFcore shared library as a delegate
                loader = createDelegatingLoader(id, urls, archive, componentConfig, false);
                componentClass = loader.loadClass(classname);
            }
        }

        // create a component instance
        IComponent component = (IComponent)componentClass.newInstance();
        if (isFrameworkComponent) {
            if (component instanceof DSComponent) {
                ((DSComponent)component).setContainer(this);
            }

            if (component instanceof IGlobalFrameworkComponent) {
                id = ((IGlobalFrameworkComponent)component).getGlobalID();
            } else if (id.equals(IAgentProxy.ID)) {
                ((Agent)component).setContainer(this);
            }
            if (component instanceof IEnterpriseAware) {            	
                ((IEnterpriseAware)component).setEnterpriseStateAccess(new IEnterpriseStateAccess() {
					
					@Override
					public boolean isEnterprise() {
						JMSConnectorServer connector = m_connector;
						if (connector == null) {
							return false;
						} else {
							return connector.isConnectionEnterpriseEnabled();
						}
					}
				});
            }
        }

        // set the initial debug mask .. if this was a container extension, then the trace mask will be -1 and we have
        // to check
        // the extension component's config for the trace mask
        if (traceMask == -1) {
            Integer extensionTraceMask = (Integer)componentAttrs.getAttribute(IContainerConstants.TRACE_MASK_ATTR);
            traceMask = extensionTraceMask == null ? IContainerConstants.TRACE_MASK_DEFAULT : extensionTraceMask.intValue();
        }
        component.setTraceMask(new Integer(traceMask));

        // create a management mBean for the component and register it
        ComponentMBean mBean = isFrameworkComponent ? new FrameworkComponentMBean(this, component, id, configID)
                                                   : new ComponentMBean(this, component, id, configID);
        m_mbeanServer.registerMBean(mBean, mBean.getObjectName());
        m_mBeans.put(id, new MBeanHolder(mBean));

        // re-establish any notification subscriptions that were retrieved from the container's cache
        // note: this can be done right away because these only come from the cache
        restoreNotificationSubscriptionsFromCache(mBean);

        // log the load locally
        if (!m_generateCache) {
            logMessage(null, "Loaded ID=" + id, Level.INFO);
        }

        return mBean;
    }

    private ClassLoader createDelegatingLoader(String id, URL[] urls, ExpandedSonicArchive archive, IElement componentConfig,
                                               boolean delegateToMFcore) {
        // build the list of shared library names the component's private class laoder will delegate to ..
        ArrayList delegateLoaderNames = new ArrayList();

        // .. add the MF core shared library name if request
        if (delegateToMFcore) {
            delegateLoaderNames.add("$MFcore");
        }

        // .. add the component's own shared libraries (if any are declared)
        String[] sharedLibraryNames = archive.getSharedLibraryNames();
        for (int i = 0; i < sharedLibraryNames.length; i++) {
            delegateLoaderNames.add(sharedLibraryNames[i]);
        }

        // .. add the dependent shared libraries (if any are declared)
        String[] dependsOn = archive.getDependsOn();
        for (int i = 0; i < dependsOn.length; i++) {
            delegateLoaderNames.add(dependsOn[i]);
        }

        return ClassLoaderFactory.createDelegatingLoader(m_containerIdentity.getCanonicalName(), id, urls,
                                                         m_defaultClassLoader.getParent(),
                                                         (String[])delegateLoaderNames.toArray(IEmptyArray.EMPTY_STRING_ARRAY));
    }

    private Long getBackupTimestampFromDS() throws Exception {
        try {
            IElement dsInfoElement = m_directory.getElement(m_containerIdentity.getCanonicalName(), DirectoryService.DS_VERSION_INFO_PATH);

            // TO DO - remove this not needed any longer
            if (dsInfoElement == null) {
                throw new Error("The DS is old - use a DS from a recent build.");
            }

            IAttributeSet attributes = dsInfoElement.getAttributes();
            return (Long)attributes.getAttribute(IDirectoryMFService.BACKUP_VERSION_ATTR);
        } catch (Exception e) {
            if (!containsTimeout(e)) {
                throw e;
            }
            return null;
        }
    }

    private void startDSMonitoringThread(final long frequency, boolean initalDSAcessibility) {
        ServiceMaintenance dsMaintenance = new ServiceMaintenance() {
            // every 3rd call we will call reconcile if we have not recently reconcilled
            private int callsUntilReconcile = 3;

            private long lastTimeWeDidMaintenance;

            @Override
            public Exception doMaintenance() {
                callsUntilReconcile--;
                if (lastTimeWeDidMaintenance > 0 && ContainerImpl.this.m_lastTimeWeSubscribed > lastTimeWeDidMaintenance) {
                    if (callsUntilReconcile == 0) {
                        callsUntilReconcile = 2;
                    }
                }

                try {
                    // if the temp monitor is running then don't do anything
                    synchronized (m_dsTemporaryMonitorLock) {
                        if (ContainerImpl.this.m_dsTemporaryMonitor != null) {
                            callsUntilReconcile = 2;
                            return null;
                        }
                    }

                    // if we have cycled twice already we should be reconciling
                    if (callsUntilReconcile == 0) {
                        reconcileCache(); // this will do a subscribe
                        callsUntilReconcile = 3;
                        return null;
                    } else {
                        if (lastTimeWeDidMaintenance == 0 || ContainerImpl.this.m_lastTimeWeSubscribed > lastTimeWeDidMaintenance) {
                            // we could drop through to here if on startup we had failed to reconcile the cache, then a
                            // subsequent reconcile
                            // succeeds - in this case the timeSinceLastSubscribe will be recent, so no need to do
                            // anything this call round
                            return null;
                        } else {
                            return checkDSAccessibility(ContainerImpl.this.m_dsMonitor);
                        }
                    }
                } finally {
                    lastTimeWeDidMaintenance = System.currentTimeMillis();
                }
            }

            @Override
            public void onAccessibilityChange(boolean isAccessible) {
                if (isAccessible) {
                    reconcileCache();
                } else {
                    configuringFromCache();
                }
            }
        };

        m_dsMonitor = new ServiceMaintainer("Configuration Change Registrar", dsMaintenance, frequency, initalDSAcessibility);
    }

    private void startDSTemporaryMonitoringThread() {
        ServiceMaintenance dsMaintenance = new ServiceMaintenance() {
            @Override
            public Exception doMaintenance() {
                ServiceMaintainer dsTemporaryMonitor = null;

                synchronized (m_dsTemporaryMonitorLock) {
                    // we close the temporary maintainer down when we have successfully reconciled the cache
                    if (ContainerImpl.this.m_dsTemporaryMonitor != null && ContainerImpl.this.m_recentReconcileSucessful) {
                        ContainerImpl.this.m_dsTemporaryMonitor.close();
                        ContainerImpl.this.m_dsTemporaryMonitor = null;
                        return null;
                    } else {
                        dsTemporaryMonitor = m_dsTemporaryMonitor;
                    }
                }

                return checkDSAccessibility(dsTemporaryMonitor);
            }

            @Override
            public void onAccessibilityChange(boolean isAccessible) {
                if (isAccessible) {
                    reconcileCache();
                }
            }
        };

        long frequency = m_connector.getRequestTimeout() / 2;
        if (frequency > MAX_TEMP_DS_PING_FREQUENCY) {
            frequency = MAX_TEMP_DS_PING_FREQUENCY;
        }
        m_dsTemporaryMonitor = new ServiceMaintainer("Temporary DS Monitor", dsMaintenance, frequency, false);
    }

    private void configuringFromCache() {
        if (m_generateCache) {
            logMessage(null, "Directory Service unavailable, cannot generate cache", Level.SEVERE);
            shutdown(IContainerExitCodes.UNSPECIFIED_FAILURE_EXIT_CODE);
        } else {
            if ((m_dsMonitor == null || !m_dsMonitor.isAccessible()) && !m_useLocalCacheLogged) {
                m_useLocalCacheLogged = true;
                boolean configFromCacheRequest = Boolean.getBoolean(IContainer.CONFIGURE_FROM_CACHE_PROPERTY);
                String msg = configFromCacheRequest ? "Configuring from cache"
                                                   : "Directory Service unavailable, configuration from local cache only";
                logMessage(null, msg, configFromCacheRequest ? Level.INFO : Level.WARNING);
            }
        }
    }

    private boolean updateConfigElements(IDirElement[] updatedElements) throws VersionOutofSyncException, PersistentCacheException, CacheClosedException {
        Long newBackupVersion = null;
        boolean callAgain = false;

        ArrayList elementsToReport = new ArrayList();
        boolean[] reportToComponent = new boolean[updatedElements.length];
        boolean[] replacement = new boolean[updatedElements.length];

        for (int i = 0; i < updatedElements.length; i++) {
            reportToComponent[i] = true;
            replacement[i] = false;
            IDirElement currentElement = updatedElements[i];
            if (currentElement instanceof IEnvelope) {
                IEnvelope envelope = (IEnvelope)currentElement;
                reportToComponent[i] = envelope.getProperty(IEnvelope.DELETED_BUT_RECREATED_LABEL) == null ? true : false;
                if (!callAgain && envelope.getProperty(IEnvelope.RECONCILIATION_NOT_FINISHED_LABEL) != null) {
                    callAgain = true;
                }
                replacement[i] = envelope.getProperty(IEnvelope.REPLACEMENT_LABEL) == null ? false : true;
                currentElement = (IDirElement)envelope.getEnvelopedElement();
            }

            // The last element might be a new backup version
            if (i + 1 == updatedElements.length && currentElement.getIdentity().getName().equals(DirectoryService.DS_VERSION_INFO_PATH)) {
                IAttributeSet attributes = currentElement.getAttributes();
                newBackupVersion = (Long)attributes.getAttribute(IDirectoryMFService.BACKUP_VERSION_ATTR);
            } else {
                elementsToReport.add(currentElement);
            }
        }

        IElement[] reportList = new IElement[elementsToReport.size()];
        elementsToReport.toArray(reportList);
        cacheAndReportElements(reportList, reportToComponent, replacement);

        // We set the new backup version only when the updateConfigElements() process is over
        if (newBackupVersion != null && !callAgain) {
            m_configCache.setDSBackupVersion(newBackupVersion);
        }

        return m_isClosing ? false : callAgain;

    }

    private void reconcileCache() {
        // don't bother
        if (m_isClosing) {
            return;
        }

        // Cache is not ready yet...
        if (m_configCache == null) {
            return;
        }

        // Since we can only have one thread actively reconciling, we need to make the most current thread (most recent)
        // the active reconcilling thread since it will have been triggered by the latest event
        synchronized (m_reconcileLock) {
            m_designatedReconcileThread = Thread.currentThread();
        }

        if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0) {
            logMessage(null, "Reconcile local configuration cache with Directory Service...", Level.TRACE);
        }

        boolean success = false;
        m_recentReconcileSucessful = false;

        try {
            // The sonicsw.mf.configureFromCache property sets m_configureFromCache. sonicsw.mf.configureFromCache could
            // be true
            // for two reasons:
            // 1) Set by the user to allow for quick container startup when the DS is not available. After startup, the
            // container keep trying to connect to the DS and reconcile the cache with any DS modifications. That
            // feature was
            // implemenetd to resolve Sonic00025844
            // 2) If The automatic cache generation for DRA connections was used by configuring CENTRAL_CONNECTION; the
            // container
            // is restarted with sonicsw.mf.configureFromCache set to true for a quick startup
            if (!m_skippedDSReconciliation && m_configureFromCache) {
                m_skippedDSReconciliation = true;
                throw new com.sonicsw.mf.comm.InvokeTimeoutException(IContainer.CONFIGURE_FROM_CACHE_PROPERTY + " is set ");
            }

            // Sets an initial backup version
            if (m_configCacheView.getDSBackupVersion() == null) {
                m_configCache.setDSBackupVersion(getBackupTimestampFromDS());
            }

            // other than startup, wait a small amount to ensure the DS has established its subscription
            // (and will hence be able to handle the reconcile request) and that the lock will prevent
            // a reconcile from another thread duplicating the reconcile of this thread (e.g. can try
            // to reconcile due to both a reconnect of mgmt comms and having received a DS startup notification
            if (m_isBooted) {
                Thread.sleep(1500);
            }
            reconcileCacheWithDS();
            synchronized (m_reconcileLock) {
                if (m_designatedReconcileThread != Thread.currentThread()) {
                    return;
                }
            }
            // tell the DS that we're interested in changes to the container's logical name
            setupInterestInLogicalName();
            success = true;
            m_recentReconcileSucessful = true;
            m_lastTimeWeSubscribed = System.currentTimeMillis();
        } catch (VersionOutofSyncException e) // Should never happen since we don't set delta but rather a whole element
        {
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.DS_FAILURE_EXIT_CODE);
        } catch (PersistentCacheException e) {
            logMessage(null, e, Level.SEVERE);
            shutdown(IContainerExitCodes.DS_FAILURE_EXIT_CODE);
        } catch (CacheClosedException e) // This should not happen
        {
            if (m_isClosing) {
                return;
            }

            logMessage(null, e, Level.SEVERE);
            throw new Error(e.toString());
        } catch (Exception e) {
            if (m_isClosing) {
                return;
            }
            if (containsTimeout(e) || e instanceof MFServiceNotActiveException) {
                m_dsNotInitiallyAccessible = true;
                configuringFromCache();
                // backoff some reasonable amount; we got the condition because
                // either the system is heavily loaded (maybe during a failover cycle)
                // or the backup has not yet taken over
                long frequency = m_connector.getRequestTimeout();
                if (frequency > MAX_TEMP_DS_PING_FREQUENCY) {
                    frequency = MAX_TEMP_DS_PING_FREQUENCY;
                }
                if (m_random == null) {
                    m_random = new Random(m_containerIdentity.getContainerName().hashCode());
                }
                // by using a normal distribution, the majority of containers backing off
                // (those greater than -1 std deviations) will backoff a fairly similar
                // amount and a few (< -1 std deviations will retry more quickly) ... the
                // aim is to give a few (~15%) a better shot at completion
                double random = m_random.nextGaussian() + 1;
                if (random > 0) {
                    try {
                        Thread.sleep((long)(random * (frequency / 4)));
                    } catch (InterruptedException ie) {
                    }
                }
            } else // this should not happen
            {
                logMessage(null, e, Level.SEVERE);
                throw new Error(e.toString());
            }
        } finally {
            if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0) {
                if (success) {
                    logMessage(null, "...reconcile complete", Level.TRACE);
                } else {
                    logMessage(null, "...reconcile failed", Level.TRACE);
                }
            }
            // if we failed to reconcile and don't already have a frequent DS monitor - create
            // one
            if (success) {
                if (m_useLocalCacheLogged) {
                    m_useLocalCacheLogged = false;
                    logMessage(null, "Directory Service available, reconciled local cache", Level.INFO);
                }
            } else {
                // we failed to reconcile; cancel this monitor thread and start a new one
                ServiceMaintainer oldTemporaryMonitor = null;
                synchronized (m_dsTemporaryMonitorLock) {
                    if (m_dsTemporaryMonitor != null) {
                        oldTemporaryMonitor = m_dsTemporaryMonitor;
                        m_dsTemporaryMonitor = null;
                    }
                }

                // avoid holding m_dsTemporaryMonitorLock when calling close(), otherwise
                // we risk deadlock between m_dsTemporaryMonitorLock and the close() call
                // which locks the ServiceMaintainer that we're closing.
                // (if we've been called from ServiceMaintainer.setAccesssibility then
                // ServiceMaintainer will already be locked. Other threads must therefore
                // avoid locking ServiceMaintainer when m_dsTemporaryMonitorLock is held)
                if (oldTemporaryMonitor != null) {
                    oldTemporaryMonitor.close();
                }

                synchronized (m_dsTemporaryMonitorLock) {
                    if (m_dsTemporaryMonitor == null) {
                        startDSTemporaryMonitoringThread();
                    }
                }
            }
            synchronized (m_reconcileLock) {
                if (m_designatedReconcileThread == Thread.currentThread()) {
                    m_designatedReconcileThread = null;
                }
            }
        }

        return;
    }

    private void reconcileCacheWithDS() throws VersionOutofSyncException, PersistentCacheException, CacheClosedException {
        String container = m_containerIdentity.getCanonicalName();
        Long dsBackupVersion = m_configCacheView.getDSBackupVersion();

        // retry flag is used to print messages going around the loop until completely reconciled
        boolean retry = false;
        // start out wanting to reconcile everything in the cache, and new elements in the DS
        boolean reconcileExistingElements = true;
        boolean reconcileNewElements = true;
        boolean reconcileLogicalMap = true;
        ArrayList processedIds = new ArrayList();

        // keep calling until completely reconciled (the DS may not return everything
        // at once in order to keep the message size manageable)
        while (reconcileExistingElements || reconcileNewElements) {
            if (retry && (m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0) {
                logMessage(null, "Calling reconcileCache() again...", Level.TRACE);
            }

            IElementIdentity[] allIds = m_configCacheView.getAllIdentities(processedIds);

            // we don't want to reconcile any subscriptions notifications
            // or _MF_CI_CONFIG_ID_TYPE elements or NON_DSFILE == true elements
            // that may be in the container cache/runtime direction, so weed
            // those out
            ArrayList includeIds = new ArrayList();
            ArrayList nonDSFiles = new ArrayList();
            for (int i = 0; i < allIds.length; i++) {
                IElementIdentity id = allIds[i];
                IElement el = m_configCacheView.getElement(id.getName());
                if (m_fileManager.isNonDSFile(el)) {
                    nonDSFiles.add(id);
                    continue;
                }
                String[] nameComponents = allIds[i].getNameComponents();
                if (allIds[i].getType().equals(IContainer._MF_CI_CONFIG_ID_TYPE)) {
                    continue;
                } else if (nameComponents[0].equals(IMFDirectories.MF_RUNTIME_DIR)) {
                    if (nameComponents[nameComponents.length - 1].equals(EXTERNAL_NOTIFICATION_SUBSCRIPTIONS)
                        || nameComponents[nameComponents.length - 1].equals(INTERNAL_NOTIFICATION_SUBSCRIPTIONS)) {
                        continue;
                    }
                }
                includeIds.add(allIds[i]);
            }
            allIds = (IElementIdentity[])includeIds.toArray(new IElementIdentity[includeIds.size()]);

            // get the directories which will be reconciled
            String[] directories = m_configCacheView.getAllInterestDirs();

            // allAcceptedChanges is used in the place of the deletedElements argument to lower level calls
            HashMap allAcceptedChanges = null;
            if (reconcileExistingElements) {
                allAcceptedChanges = new HashMap();
            }

            if (!reconcileNewElements || directories.length == 0) {
                directories = null;
            }

            HashMap logicalMap = null;
            if (reconcileLogicalMap) {
                logicalMap = m_configCacheView.getStorageToLogicalMap();

                // remove non DS file IDs from the logicalMap
                for (int i = 0; i < nonDSFiles.size(); i++) {
                    IElementIdentity id = (IElementIdentity)nonDSFiles.get(i);
                    String elName = id.getName();
                    if (logicalMap.get(elName) != null) {
                        logicalMap.remove(elName);
                    }
                }
            }

            synchronized (m_reconcileLock) {
                if (m_designatedReconcileThread != Thread.currentThread()) {
                    return;
                }
            }

            if (m_isClosing) {
                return;
            }

            if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_VERBOSE) > 0) {
                logMessage(null, "Calling reconcileCache() with "
                    + (allIds == null ? "<null>" : Integer.toString(allIds.length)) + " identities, "
                    + (allAcceptedChanges == null ? "<null>" : Integer.toString(allAcceptedChanges.size())) + " deletedConfigurations, "
                    + (directories == null ? "<null>" : Integer.toString(directories.length)) + " directories, "
                    + (logicalMap == null ? "<null>" : Integer.toString(logicalMap.size())) + " map entries", Level.TRACE);
            }

            Object[] rtn = m_directory.reconcileCache(container, Version.VERSION_INFO, dsBackupVersion, allIds, allAcceptedChanges,
                                                      directories, logicalMap);

            if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_VERBOSE) > 0) {
                logMessage(null, "reconcileCache() returned "
                    + (rtn[0] == null ? "<null>" : Integer.toString(((Object[])rtn[0]).length)) + " modified elements, "
                    + (rtn[1] == null ? "<null>" : Integer.toString(((Object[])rtn[1]).length)) + " added elements, "
                    + (rtn[2] == null ? "<null>" : Integer.toString(((HashMap)rtn[2]).size())) + " map updates", Level.TRACE);
            }

            if (m_isClosing) {
                return;
            }

            // set retry flag so an additional trace message can be logged if we end up calling the
            // reconcileCache operation again - this flag does not control whether or not we do a retry
            retry = true;

            // if this reconcile thread is no longer the designated reconcile thread, then get out and let the newly
            // designated reconcile thread get on with its work
            synchronized (m_reconcileLock) {
                if (m_designatedReconcileThread != Thread.currentThread()) {
                    return;
                }

                // start by assuming that one call to the DS is enough and
                // we don't need to go around this loop again
                boolean callAgain = false;

                if (reconcileExistingElements) {
                    if (rtn[0] == null) {
                        reconcileExistingElements = false;
                    } else {
                        // start by assuming we don't need to go around this loop again
                        callAgain = false;
                        HashMap<String, ArrayList<IDirElement>> groups = com.sonicsw.mf.common.config.impl.Element.groupByParentDir((IDirElement[])rtn[0]);
                        Iterator<ArrayList<IDirElement>> iterator = groups.values().iterator();
                        while (iterator.hasNext()) {
                            ArrayList<IDirElement> group = (ArrayList<IDirElement>)iterator.next();
                            IDirElement[] elementGroup = new IDirElement[group.size()];
                            for (IDirElement el : group) {
                                processedIds.add(el.getIdentity().getName());
                            }
                            group.toArray(elementGroup);
                            // we'll have to go around the loop for more reconciliation if the DS
                            // returned an envelope element with the property RECONCILIATION_NOT_FINIS
                            if (updateConfigElements(elementGroup)) {
                                callAgain = true;
                            }
                        }
                        // if callAgain is true, there will be more existing elements to be reconciled
                        reconcileExistingElements = callAgain;
                    }
                }

                if (reconcileNewElements) {
                    if (rtn[1] == null) {
                        reconcileNewElements = false;
                    } else {
                        // there will be more to come if we get an empty array or one of the envelopes indicates there
                        // is more to come
                        if (((Object[])rtn[1]).length == 0) {
                            continue;
                        }

                        callAgain = false;
                        for (int i = 0; i < ((Object[])rtn[1]).length; i++) {
                            IDirElement currentElement = (IDirElement)((Object[])rtn[1])[i];
                            if (currentElement instanceof IEnvelope) {
                                IEnvelope envelope = (IEnvelope)currentElement;
                                if (envelope.getProperty(IEnvelope.RECONCILIATION_NOT_FINISHED_LABEL) != null) {
                                    // there will be more new elements to be reconciled
                                    callAgain = true;
                                }
                                currentElement = (IDirElement)envelope.getEnvelopedElement();
                            }
                            cacheAndReportElement(currentElement, true, false);
                            processedIds.add(currentElement.getIdentity().getName());

                        }
                        reconcileNewElements = callAgain;
                    }
                }

                if (reconcileLogicalMap) {
                    m_configCacheView.applyCorrections((HashMap)rtn[2]);
                    reconcileLogicalMap = false;
                }

            }

        }
    }

    /**
     * Load the list of components (extensions and regular) specified in the containers configuration.
     */
    private void loadAllConfiguredComponents(IAttributeSet containerAttrs) {
        HashSet componentsWithArchiveFailures = new HashSet();

        Object[] extensionComponents = null;
        Object[] regularComponents = null;

        // load any archives and libraries associated with configured container extensions
        IAttributeSet extensionComponentsAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.EXTENSIONS_ATTR);
        if (extensionComponentsAttrs != null) {
            extensionComponents = extensionComponentsAttrs.getAttributes().entrySet().toArray();
            loadComponentArchives(extensionComponents, true, componentsWithArchiveFailures);
        }

        // load any archives and libraries associated with regularly configured container components
        IAttributeSet regularComponentsAttrs = (IAttributeSet)containerAttrs.getAttribute(IContainerConstants.COMPONENTS_ATTR);
        if (regularComponentsAttrs != null) {
            regularComponents = regularComponentsAttrs.getAttributes().entrySet().toArray();
            loadComponentArchives(regularComponents, false, componentsWithArchiveFailures);
        }

        // first load container extension components that are framework components, then those that are application
        // components (in reality
        // they should all be framework components)
        if (extensionComponentsAttrs != null) {
            loadConfiguredComponents(extensionComponents, true, true, componentsWithArchiveFailures);
            loadConfiguredComponents(extensionComponents, true, false, componentsWithArchiveFailures);
        }

        // then load regular components that are framework components, then those that are application components
        if (regularComponentsAttrs != null) {
            loadConfiguredComponents(regularComponents, false, true, componentsWithArchiveFailures);
            loadConfiguredComponents(regularComponents, false, false, componentsWithArchiveFailures);
        }
    }

    /**
     * Load the archives associated with the given set of components
     */
    private void loadComponentArchives(Object[] components, boolean isExtensions, HashSet componentsWithArchiveFailures) {
        // ensure all the Sonic archives specified by the components are available in the cache
        // and create any shared libraries (explicitely specified or implied via the depends-on list)
        for (int i = 0; i < components.length; i++) {
            if (this.m_isClosing) {
                throw new ShutdownInProgressException();
            }
            Map.Entry componentEntry = (Map.Entry)components[i];
            String id = (String)componentEntry.getKey();

            if (m_mBeans.containsKey(id)) {
                continue; // its already been loaded as a special case (e.g. DS)
            }

            // get the component's configuration and create any required shared libraries that
            // have not yet been created
            IAttributeSet attrs = (IAttributeSet)componentEntry.getValue();
            String configID = ((Reference)attrs.getAttribute(isExtensions ? IContainerConstants.EXTENSION_CONFIG_REF_ATTR
                                                                         : IContainerConstants.CONFIG_REF_ATTR)).getElementName();
            IElement componentConfig = getConfiguration(configID);
            IAttributeSet componentAttrs = (IAttributeSet)componentConfig.getAttributes();
            if (!createDeclaredSharedLibraries(id, componentAttrs)) {
                componentsWithArchiveFailures.add(id);
            } else if (!createDependentSharedLibraries(id, componentAttrs)) {
                componentsWithArchiveFailures.add(id);
            }
        }
    }

    private boolean createDeclaredSharedLibraries(String id, IAttributeSet componentAttrs) {
        // get the component's archive name
        String archiveName = (String)componentAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR);
        // highly unlikely, but check for null.
        if (archiveName == null) {
            logMessage(null, "Failed to load ID=" + id + " - archive attribute is not set", Level.SEVERE);
            return false;
        }
        try {
            // get the expanded archive's root directory and create the shared libraries
            // declared by the archive (if not already created)
            File archiveDir = m_fileManager.getLocalFile(m_sonicArchiveSearchPath, archiveName);
            if (archiveDir == null) {
                logMessage(null, "Failed to load ID=" + id + " - archive not found: " + archiveName, Level.SEVERE);
                return false;
            }

            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
            createSharedLibraries(id, archive);
        } catch (Exception e) {
            if (e instanceof OutOfPersistentSpaceException) {
                logMessage(null, e.getMessage(), Level.SEVERE);
                shutdown(IContainerExitCodes.CACHE_FAILURE_EXIT_CODE);
            }

            logMessage(null, "Failed to load ID=" + id + " - error while loading archive " + archiveName + ", trace follows...", e,
                       Level.SEVERE);
            return false;
        }
        return true;
    }

    private boolean createDependentSharedLibraries(String id, IAttributeSet componentAttrs) {
        // get the component's archive name
        String archiveName = (String)componentAttrs.getAttribute(IContainerConstants.ARCHIVE_NAME_ATTR);
        String[] dependsOnSharedLibraries = null;

        try {
            // get the expanded archive's root directory and create the shared libraries
            // declared by the archive (if not already created
            File archiveDir = m_fileManager.getLocalFile(m_sonicArchiveSearchPath, archiveName);

            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
            dependsOnSharedLibraries = archive.getDependsOn();
        } catch (Exception e) {
            logMessage(null, "Failed to load ID=" + id + " - error while loading archive " + archiveName + ", trace follows...", e,
                       Level.SEVERE);
            return false;
        }

        // loop through any dependent archives, creating their declared shared libraries if not already
        // created
        for (int i = 0; i < dependsOnSharedLibraries.length; i++) {
            try {
                // shared libraries with names that start with '$' are for internal use and cannot be
                // resolved using the name
                if (dependsOnSharedLibraries[i].startsWith("$")) {
                    continue;
                }

                File archiveDir = m_fileManager.getLocalFile(m_sonicArchiveSearchPath, dependsOnSharedLibraries[i]);

                ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
                createSharedLibraries(null, archive);
            } catch (Exception e) {
                logMessage(null, "Failed to load ID="
                               + id + " - error while loading dependent archive " + dependsOnSharedLibraries[i] + ", trace follows...", e,
                           Level.SEVERE);
                return false;
            }
        }

        return true;
    }

    private void createSharedLibraries(String id, ExpandedSonicArchive archive) {
        String[] libraryNames = archive.getSharedLibraryNames();
        for (int i = 0; i < libraryNames.length; i++) {
            URL[] urls = archive.getSharedLibraryClasspath(libraryNames[i]);
            // if the shared library (delegate loader) name already exists, then it will not be recreated
            ClassLoaderFactory.createDelegateLoader(m_containerIdentity.getCanonicalName(), id, libraryNames[i], urls,
                                                    m_defaultClassLoader.getParent());
        }
    }

    /**
     * Load the list of components (extensions and regular) specified in the containers configuration.
     */
    private void loadConfiguredComponents(Object[] components, boolean isExtensions, boolean frameworkOnly,
                                          HashSet componentsWithArchiveFailures) {
        for (int i = 0; i < components.length; i++) {
            if (this.m_isClosing) {
                throw new ShutdownInProgressException();
            }
            Map.Entry componentEntry = (Map.Entry)components[i];

            // if this is an extension component and the extension is not active, then don't bother going any further
            // just skip this component
            if (isExtensions) {
                IAttributeSet extensionAttrs = (IAttributeSet)componentEntry.getValue();
                Boolean isActive = (Boolean)extensionAttrs.getAttribute(IContainerConstants.EXTENSION_ACTIVE_ATTR);
                if (isActive == null) {
                    isActive = new Boolean(IContainerConstants.EXTENSION_ACTIVE_DEFAULT);
                }
                if (!isActive.booleanValue()) {
                    continue;
                }
            }

            String id = (String)componentEntry.getKey();

            if (m_mBeans.containsKey(id)) {
                continue; // its already been loaded as a special case (e.g. DS)
            }

            // we can ignore any component we know we will have a problem with because there were issues
            // get the component's (or its dependent) archive(s)
            if (componentsWithArchiveFailures.contains(id)) {
                continue;
            }

            loadConfiguredComponent(id, (IAttributeSet)componentEntry.getValue(), isExtensions, frameworkOnly);
        }
    }

    private Exception checkDSAccessibility(ServiceMaintainer dsMonitor) {
        if (dsMonitor == null) {
            return null;
        }

        // if we're called from the ServiceMantainer thread (m_dsMonitor), then perform the check
        // otherwise wake up the thread which will then cause this method to be called on the correct thread
        if (Thread.currentThread() == dsMonitor) {
            try {
                String retValue = m_directory.ping("PONG");
                if (retValue == null || !retValue.equals("PONG")) {
                    return new Exception("The DS is not accessible.");
                }

                return null;
            } catch (Exception e) {
                return e;
            }
        } else {
            synchronized (dsMonitor.getLock()) {
                dsMonitor.getLock().notifyAll();
            }
            return null;
        }
    }

    /**
     * Translates tokens in the given ';' delimited classpath that are to sonicfs:/// (DS) based locations, to local
     * files stored in the cache.
     * 
     * @return The translated classpath as list of URLs.
     */
    private ArrayList translateClasspath(String id, String classpath) throws Exception {
        ArrayList urls = new ArrayList();
        LogicalFile file = null;

        if (classpath == null || classpath.length() == 0) {
            return urls;
        }

        // else we need to break the classpath into tokens and examine each token
        StringTokenizer st = new StringTokenizer(classpath, IContainer.DS_CLASSPATH_DELIMITER);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            file = m_fileManager.localFileFromLocation(null, path, false, null);
            if (file == null) {
                logMessage(null, "Unable to evaluate classpath element for ID=" + id + ": " + path, Level.WARNING);
                continue;
            }
            urls.add(file.getURL());
        }

        return urls;
    }

    void writeLibrary(String filename, InputStream inputStream) throws IOException {
        File library = new File(IContainer.LIBX_DIR, filename);

        byte[] bytes = new byte[512];
        try {
            FileOutputStream fos = new FileOutputStream(library);
            while (true) {
                int numBytes = inputStream.read(bytes);
                if (numBytes < 1) {
                    break;
                }
                fos.write(bytes, 0, numBytes);
            }
            inputStream.close();
            fos.flush();
            fos.getFD().sync();
            fos.close();
        } catch (FileNotFoundException e) {

            if (!IContainer.LIBX_DIR.exists()) {
                logMessage(null, "Native library directory \"" + IContainer.LIBX_DIR + "\" does not exist", Level.SEVERE);
                shutdown(IContainerExitCodes.LIBX_DIR_NOT_FOUND_EXIT_CODE);
            }
        }

        // on Unix need to set permissions
        if (System.getProperty("path.separator").equals(":")) {
            Process chmod = Runtime.getRuntime().exec("chmod u+x " + library.getPath());
            try {
                if (chmod.waitFor() != 0) {
                    logMessage(null, "Failed to set execute permissions for native library: " + library.getPath(), Level.WARNING);
                }
            } catch (InterruptedException e) {
            }
        }
    }

    /**
     * Given a set of sonicfs:/// locations to native libraries, retrieves them and attempts to store them in the libX
     * directory.
     */
    private void writeLibraries(AttributeSet libraries) throws Exception {
        Iterator iterator = libraries.getAttributes().values().iterator();
        while (iterator.hasNext()) {
            AttributeSet libraryAttrs = (AttributeSet)iterator.next();
            String nativeLibrary = (String)libraryAttrs.getAttribute(IContainerConstants.NATIVE_LIBRARY_PATH_ATTR);

            if (m_storedLibraries.contains(nativeLibrary)) {
                continue; // don't write the library out more than once during the current container run
            }
            m_storedLibraries.add(nativeLibrary);

            // get the library cached and into the native_library directory
            m_fileManager.localFileFromLocation(null, nativeLibrary, true, null);
        }
    }

    void sendDirectedNotification(String commsType, String destination, int listenerHash, Notification notification, Object handback) {
        m_connector.sendDirectedNotification(commsType, destination, listenerHash, notification, handback);
    }

    private String getParentName(String elementName) {
        try {
            return new EntityName(elementName).getParent();
        } catch (ConfigException e) {
            // Should not happen
            e.printStackTrace();
            logMessage(null, e, Level.SEVERE);
            throw new Error();
        }

    }

    private void reportElement(IBasicElement elementToReport, boolean replacement, String logicalName) throws CacheClosedException {

        String elementName = elementToReport.getIdentity().getName();

        Object[] entries = m_mBeans.entrySet().toArray();
        for (int i = 0; i < entries.length; i++) {
            Map.Entry entry = (Map.Entry)entries[i];
            MBeanHolder holder = (MBeanHolder)entry.getValue();

            // check to see if the component has been unloaded (possible if the AGENT got a container component
            // deletion config change before the actual component gets it)
            if (holder == null) {
                continue;
            }
            AbstractMBean mBean = holder.mBean;
            if (mBean == null) {
                continue;
            }

            try {
                if (mBean.acceptChanges(elementName, getParentName(elementName)).booleanValue()) {
                    if (mBean.isFileRequest(elementName)) {
                        mBean.handleFileChange(new FSElementChange(logicalName == null ? m_configCache.storageToLogical(elementName)
                                                                                      : logicalName, elementToReport, replacement));
                    } else if (mBean.isLogicalRequest(elementName)) {
                        mBean.handleElementChange(new FSElementChange(logicalName == null ? m_configCache.storageToLogical(elementName)
                                                                                         : logicalName, elementToReport, replacement));
                    } else {
                        mBean.handleElementChange(new ElementChange(elementToReport, replacement));
                    }
                }
            } catch (Throwable t) {
                // The component might have shutdown so the failure is not neccessarily a problem
                logMessage(null, "Failed to pass configuration change to component " + (String)entry.getKey() + ", trace follows... ", t,
                           Level.WARNING);
            }
        }
    }

    private void cacheAndReportElement(IBasicElement element, boolean reportToComponent, boolean replacement) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        // don't bother
        if (m_isClosing) {
            return;
        }

        // We are not yet ready to handle modifications
        if (m_configCache == null) {
            return;
        }

        if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
            logMessage(null, "Handling configuration change [" + element.getIdentity().getName() + "]", Level.TRACE);
        }

        // This is synchronized so that the operation of setting the cache and updating the
        // components is atomic - that guarantees that components get updates in the correct order
        // since that cache accept changes only in the correct order
        synchronized (m_reportingChangeLock) {
            // If the cache already knows about this modification it means the components know
            // about it - no need to do anything. Note that elementToReport can be diffrent from element.
            // For example, element might be a whole IDirElement returned by the DS from a cache reconciliation
            // process, while elementToReport is the delta between the old cache version of the element and
            // the new version.
            // keep the logical name before the element is deleted so we can put it in the FSElementChange
            // notification
            String logicalName = m_configCache.storageToLogical(element.getIdentity().getName());
            IBasicElement elementToReport = setElement(element);

            if (elementToReport == null || !reportToComponent) {
                return;
            }

            reportElement(elementToReport, replacement, logicalName);
        }
    }

    private IBasicElement[] setElements(IElement[] elements) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        try {
            return m_configCache.setElements(elements);
        } catch (VersionOutofSyncException e) {
            logMessage(null, "Cache reconciliation is required: ", Level.INFO);
            throw e;
        } catch (CacheClosedException e) {
            logMessage(null, "Failed to set in cache element: ", e, Level.SEVERE);
            throw e;
        } catch (PersistentCacheException e) {
            logMessage(null, "Failed to set in cache element: ", e, Level.SEVERE);
            throw e;
        } catch (Throwable t) {
            handleThrowable(t, "");
            return null;
        }

    }

    private IBasicElement setElement(IBasicElement element) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        String elementName = element.getIdentity().getName();

        try {
            return m_configCache.setElement(element);
        } catch (VersionOutofSyncException e) {
            // Sonic00040788 We can safely ignore this for runtime elements since we keep the up to date version in the
            // cache
            // and the DS version is only used if the cache gets blown away
            String rootDirectory = element.getIdentity().getNameComponents()[0];
            if (rootDirectory.startsWith("_") && rootDirectory.endsWith("Runtime")) {
                return null;
            }

            logMessage(null, "Cache reconciliation is required for element: " + elementName, Level.INFO);
            throw e;
        } catch (CacheClosedException e) {
            if (!this.m_isClosing) {
                logMessage(null, "Failed to set in cache element: " + elementName, e, Level.SEVERE);
            }
            throw e;
        } catch (PersistentCacheException e) {
            if (!this.m_isClosing) {
                logMessage(null, "Failed to set in cache element: " + elementName, e, Level.SEVERE);
            }
            throw e;
        } catch (Throwable t) {
            handleThrowable(t, elementName);
            return null;
        }

    }

    // Cache and report efficiently many new (and/or deleted) elements which reside under the same directory
    // Also see comments at cacheAndReportElement(IBasicElement, boolean, boolean)
    private void cacheAndReportElements(IElement[] elements, boolean[] reportToComponent, boolean[] replacement) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        // We are not yet ready to handle modifications
        if (m_configCache == null || elements.length == 0) {
            return;
        }

        if ((m_agent.m_traceMask & Agent.TRACE_CONFIGURATION_CACHE) > 0 && (m_agent.m_traceMask & Agent.TRACE_DETAIL) > 0) {
            logMessage(null, "Handling configuration changes in directory [" + getParentName(elements[0].getIdentity().getName()) + "]",
                       Level.TRACE);
        }

        synchronized (m_reportingChangeLock) {
            IBasicElement[] elementsToReport = setElements(elements);

            for (int i = 0; i < elementsToReport.length; i++) {
                if (elementsToReport[i] == null || !reportToComponent[i]) {
                    continue;
                }

                // we're not passing logical names for group updates at this time. Can revisit.
                reportElement(elementsToReport[i], replacement[i], null);
            }
        }
    }

    // Process an unhandled Throwable to make sure the problem is logged for further examination
    private void handleThrowable(Throwable t, String elementName) {
        logMessage(null, "Failed to set in cache element: " + elementName, t, Level.SEVERE);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        } else if (t instanceof Error) {
            throw (Error)t;
        } else {
            throw new Error(t.toString());
        }
    }

    // blocks if reload is in progress, otherwise increments in-progress request count against the
    // component
    private boolean blockReload(ICanonicalName target) {
        synchronized (m_reloadingIDs) {
            MBeanHolder holder = (MBeanHolder)m_mBeans.get(target.getComponentName());

            if (m_reloadingIDs.size() > 0 && m_reloadingIDs.contains(target.getComponentName())) {
                logMessage(target.getComponentName(), "Management request blocked during component reload...", Level.INFO);
                while (!m_reloadingIDs.isEmpty()) {
                    try {
                        m_reloadingIDs.wait(100);
                    } catch (InterruptedException e) {
                    }
                    if (m_isClosing) {
                        return false;
                    }
                }
                // re-get the holder as a reload has just completed and the holder will be
                // a different object
                holder = (MBeanHolder)m_mBeans.get(target.getComponentName());
                if (holder == null) {
                    return false;
                }
                logMessage(target.getComponentName(), "...request resumed after reload", Level.INFO);
            } else if (holder == null) {
                return false;
            }

            holder.incrementRequestCount();
            return true;
        }
    }

    // decrements request count against the component and notifies waiters
    private void unblockReload(ICanonicalName target) {
        MBeanHolder holder = (MBeanHolder)m_mBeans.get(target.getComponentName());
        if (holder == null) {
            return;
        }
        holder.decrementRequestCount();
    }

    ArrayList prepareCacheForActivatedContainer(String adName, String containerName, String containerID,
                                                String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword,
                                                HashMap activationProps) throws Exception {
        return com.sonicsw.mf.framework.agent.ci.LaunchContainer.prepareCacheForActivatedContainer(m_connector, m_directory.getLocalDS(),
                                                                                                   new ContainerLogger(adName),
                                                                                                   m_containerIdentity.getDomainName(),
                                                                                                   containerName, containerID,
                                                                                                   containerWorkDirDirectoryName,
                                                                                                   cacheHostDirectoryName, cachePassword,
                                                                                                   activationProps);
    }

    //
    // Inner classes
    //

    private final class ContainerLogger
        implements com.sonicsw.mf.common.ILogger {
        String m_componentName;

        ContainerLogger() {
            m_componentName = null;
        }

        ContainerLogger(String componentName) {
            m_componentName = componentName;
        }

        @Override
        public void logMessage(String message, int severityLevel) {
            ContainerImpl.this.logMessage(m_componentName, message, severityLevel);
        }

        @Override
        public void logMessage(String message, Throwable error, int severityLevel) {
            ContainerImpl.this.logMessage(m_componentName, message, error, severityLevel);
        }
    }

    private final class Delegate
        implements IContainer {
        @Override
        public boolean isBooted() {
            return m_container.isBooted();
        }

        @Override
        public boolean isClosing() {
            return m_container.isClosing();
        }

        @Override
        public boolean isHostingComponent(String id) {
            return m_container.isHostingComponent(id);
        }

        @Override
        public IContainerState getContainerState() {
            return m_container.getContainerState();
        }

        @Override
        public IContainerIdentity getContainerIdentity() {
            return m_container.getContainerIdentity();
        }

        @Override
        public ITaskScheduler getTaskScheduler() {
            return m_container.getTaskScheduler();
        }

        @Override
        public INotificationPublisher getNotificationPublisher() {
            return m_container.getNotificationPublisher();
        }

        @Override
        public void addGlobalComponentSupport(String globalID, String instanceID, IGlobalComponentListener globalComponentListener) throws Exception {
            m_container.addGlobalComponentSupport(globalID, instanceID, globalComponentListener);
        }

        @Override
        public void removeGlobalComponentSupport(String globalID, String instanceID) {
            m_container.removeGlobalComponentSupport(globalID, instanceID);
        }

        @Override
        public void setLocalDS(IFrameworkComponent ds) {
            m_container.setLocalDS(ds);
        }

        @Override
        public void shutdown(int exitCode) {
            m_container.shutdown(exitCode);
        }

        @Override
        public void shutdown(int exitCode, boolean cleanRestart) {
            m_container.shutdown(exitCode, cleanRestart);
        }

        @Override
        public void logMessage(String id, String message, int severityLevel) {
            m_container.logMessage(id, message, severityLevel);
        }

        @Override
        public void logMessage(String id, Throwable exception, int severityLevel) {
            m_container.logMessage(id, exception, severityLevel);
        }

        @Override
        public void logMessage(String id, String message, Throwable exception, int severityLevel) {
            m_container.logMessage(id, message, exception, severityLevel);
        }

        @Override
        public IConnectorServer getConnectorServer() {
            return m_container.getConnectorServer();
        }

        @Override
        public IElement getConfigurationFromDS(String configID) {
            return m_container.m_directory.getElement(m_container.m_containerIdentity.getCanonicalName(), configID);
        }

        @Override
        public ArrayList prepareCacheForActivatedContainer(String adName, String containerName, String containerID,
                                                           String containerWorkDirDirectoryName, String cacheHostDirectoryName,
                                                           String cachePassword, HashMap activationProps) throws Exception {
            return m_container.prepareCacheForActivatedContainer(adName, containerName, containerID, containerWorkDirDirectoryName,
                                                                 cacheHostDirectoryName, cachePassword, activationProps);
        }

        @Override
        public File getCacheDirectory() {
            return m_container.m_configCache.getCacheRootDirectory();
        }
    }

    private final class ShutdownInProgressException extends RuntimeException {
    }

    private final class MBeanHolder {
        AbstractMBean mBean;

        private int requestCount;

        private MBeanHolder(AbstractMBean mBean) {
            this.mBean = mBean;
        }

        // used by a reload component request to wait for other outstanding requests
        // requests to complete before reloading
        private synchronized void waitForRequestCompletion() {
            if (requestCount > 0) {
                String id = new CanonicalName(mBean.getObjectName().getCanonicalName()).getComponentName();
                ContainerImpl.this.logMessage(id, "Reload blocked awaiting request completion...", Level.INFO);
                while (requestCount > 0) {
                    try {
                        wait(100);
                        if (ContainerImpl.this.m_isClosing) {
                            return;
                        }
                    } catch (InterruptedException e) {
                        return;
                    }
                }
                ContainerImpl.this.logMessage(id, "...reload resumed after request completion", Level.INFO);
            }
        }

        private synchronized void incrementRequestCount() {
            this.requestCount++;
        }

        private synchronized void decrementRequestCount() {
            requestCount--;
            if (requestCount < 0 && !ContainerImpl.this.m_isClosing) {
                ICanonicalName name = new CanonicalName(this.mBean.getObjectName().getCanonicalName());
                Error e = new Error("Negative request count");
                ContainerImpl.this.logMessage(name.getComponentName(),
                                              "Request count error, please report the following trace to Sonic support...", e, Level.SEVERE);
                requestCount = 0;
            }
            if (requestCount == 0) {
                notifyAll();
            }
        }
    }

    private class ElementChange
        implements IElementChange, Serializable {
        IBasicElement m_element;

        boolean m_replacement;

        // For serialization
        public ElementChange() {
        }

        private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
            s.writeObject(m_element);
        }

        private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
            m_element = (IBasicElement)s.readObject();
        }

        ElementChange(IBasicElement element, boolean replacement) {
            m_element = element;
            m_replacement = replacement;
        }

        @Override
        public IBasicElement getElement() {
            return m_element;
        }

        @Override
        public short getChangeType() {
            if (m_element instanceof IDeltaElement) {
                return IElementChange.ELEMENT_UPDATED;
            }
            if (((IElement)m_element).isDeleted()) {
                return IElementChange.ELEMENT_DELETED;
            }
            if (m_replacement) {
                return IElementChange.ELEMENT_REPLACED;
            }
            return ELEMENT_ADDED;
        }
    }

    private final class FSElementChange extends ElementChange
        implements IFSElementChange, Serializable {
        private String m_logicalPath;

        // For serialization
        public FSElementChange() {
        }

        private void writeObject(java.io.ObjectOutputStream s) throws java.io.IOException {
            s.writeObject(m_element);
            s.writeObject(m_logicalPath);
        }

        private void readObject(java.io.ObjectInputStream s) throws java.io.IOException, ClassNotFoundException {
            m_element = (IBasicElement)s.readObject();
            m_logicalPath = (String)s.readObject();
        }

        FSElementChange(String logicalPath, IBasicElement element, boolean replacement) {
            m_logicalPath = logicalPath;
            m_element = element;
            m_replacement = replacement;
        }

        @Override
        public String getLogicalPath() {
            return m_logicalPath;
        }

    }

    abstract class RequestHandler {
        /**
         * Provides the communications type needed by the connector.
         * 
         * Communications types are those supported by MF (although not explicitly checked). At time of writing the
         * following types may be used:
         * 
         * - "mf" (intended for internal container-to-container use) - "jmx" (intended for JMX connector use)
         * 
         * @return The communications type.
         */
        abstract String getHandlerCommsType();

        /**
         * This method will be called on the handler when a request is received by the underlying connector.
         */
        abstract Object invoke(ObjectName target, String operationName, Object[] params, String[] signature) throws Exception;
    }

    private final class InternalRequestHandler extends RequestHandler {
        @Override
        public String getHandlerCommsType() {
            return IContainer.INTERNAL_COMMS_TYPE;
        }

        private Object internalInvoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
            // we only support internal invocations to MF components
            CanonicalName canonicalName = new CanonicalName(target.getCanonicalName());

            boolean isReloadRequest = operationName.equals("reload") || operationName.equals("reloadComponent");
            boolean requestCountIncremented = isReloadRequest ? false : blockReload(canonicalName);

            try {
                // get the component and its class
                MBeanHolder mbh = (MBeanHolder)m_mBeans.get(canonicalName.getComponentName());
                AbstractMBean mBean = null;
                if (mbh != null) {
                    mBean = mbh.mBean;
                }
                if (mBean == null) {
                    throw new MFException("Unknown component: " + target.getCanonicalName());
                }

                if (checkExported) {
                    boolean isExported = false;
                    isExported = mBean.isOperationExported(operationName, signature);
                    if (!isExported) {
                        String signatureString = "(";
                        for (int i = 0; i < signature.length; i++) {
                            signatureString += signature[i];
                            if (i + 1 < signature.length) {
                                signatureString += ",";
                            }
                        }
                        signatureString += ")";
                        throw new MFException('(' + target.getCanonicalName() + ") Unknown operation: " + operationName + signatureString);
                    }
                }

                if (TaskScheduler.isExecutionThread()) // internal invocations are treated as though executed by the
                                                       // super-user ID
                {
                    String currentUserID = TaskScheduler.getCurrentUserID();
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(IManagementPermission.SUPER_USER_NAME);
                    Object returnValue = mBean.internalInvoke(operationName, params, signature);
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(currentUserID);
                    return returnValue;
                } else {
                    return mBean.internalInvoke(operationName, params, signature);
                }
            } finally {
                if (requestCountIncremented) {
                    unblockReload(canonicalName);
                }
            }
        }

        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
            try {
                return internalInvoke(target, operationName, params, signature, checkExported);
            } catch (Exception e) {
                throw e;
            } catch (Throwable t) {
                String errorMessage = "Invocation error in " + target + "." + operationName + ": " + t.toString();
                throw new Exception(errorMessage);
            }
        }

        @Override
        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature) throws Exception {
            return internalInvoke(target, operationName, params, signature, false);
        }
    }

    private final class ExternalRequestHandler extends RequestHandler {
        @Override
        public String getHandlerCommsType() {
            return JMSConstants.JMX_COMMS_TYPE;
        }

        @Override
        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature) throws Exception {
            return invoke(target, operationName, params, signature, true);
        }

        private Object invoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean blockWhileReloading) throws Exception {
            return invoke(target, operationName, params, signature, blockWhileReloading, true);
        }

        private Object invoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean blockWhileReloading,
                              boolean checkPermissions) throws Exception {
            boolean isInvokeInvoke = operationName.equals("invoke");
            boolean isInvokeSetAttribute = operationName.startsWith("setAttribute");

            if (interceptNotificationRegistrationOperations(operationName, params)) {
                return null;
            }

            boolean isMFComponent = target != null && ObjectNameHelper.isMFComponentName(target);
            CanonicalName canonicalName = null;
            if (isMFComponent) {
                target = ObjectNameHelper.translateGlobalObjectName(target, ContainerImpl.this.m_containerIdentity.getContainerName());
                canonicalName = new CanonicalName(target.getCanonicalName());
            }

            MBeanInfo mBeanInfo = target == null ? null : ContainerImpl.this.m_mbeanServer.getMBeanInfo(target); // null
                                                                                                                 // if
                                                                                                                 // not
                                                                                                                 // a MF
                                                                                                                 // component
            String invokeOperationName = isInvokeInvoke ? (String)params[1] : operationName;

            if (checkPermissions) {
                // check the caller has permission for the requested operation
                IPermissionsManager permissionsManager = ContainerImpl.this.m_agent.getPermissionsManager();
                permissionsManager.managePermissionCheck(target, invokeOperationName, mBeanInfo);
            }

            // tweak the signature and params of an "addNotificationListener"
            // invocation, if necessary (i.e. the signature includes a notification subscription timeout)
            if ((operationName.equals(ADD_NOTIFICATION_LISTENER_METHOD_NAME)) && (params.length > 4)) {
                // the "interceptNotificationRegistrationOperations" method will
                // return "false" the *first* time that a given listener is added, and
                // if the "new" addNotificationListener method signature (which includes
                // a notification subscription timeout) was used, the mBean server will not
                // recognize the method and will throw an invocation exception.
                // So, we will "clean up" the signature here so that the listener
                // may be registered with the mBean server.
                String[] newSignature = new String[4];
                Object[] newParams = new Object[4];
                for (int i = 0; i < 4; i++) {
                    newSignature[i] = signature[i];
                    newParams[i] = params[i];
                }
                signature = newSignature;
                params = newParams;
            }

            Class[] parameterTypes = new Class[signature.length];
            for (int i = 0; i < signature.length; i++) {
                try {
                    parameterTypes[i] = Class.forName(signature[i]);
                } catch (ClassNotFoundException e) {
                    parameterTypes[i] = params[i].getClass();
                }
            }

            Object returnValue = null;

            try {
                Method method = m_mbeanServerClass.getMethod(operationName, parameterTypes);
                boolean isReloadRequest = isInvokeInvoke && (params[1].equals("reload") || params[1].equals("reloadComponent"));
                boolean requestCountIncremented = (isMFComponent && blockWhileReloading && !isReloadRequest) ? blockReload(canonicalName)
                                                                                                            : false;
                try {
                    returnValue = method.invoke(m_mbeanServer, params);
                    if (checkPermissions) {
                        // then we also need to audit the operation if auditing is enabled)
                        IAuditManager auditManager = ContainerImpl.this.m_agent.getAuditManager();
                        Object[] invokeParams = params;
                        if (isInvokeInvoke) {
                            invokeParams = (Object[])params[2];
                        }
                        if (isInvokeSetAttribute) {
                            invokeParams = new Object[] { params[1] };
                        }
                        auditManager.recordManageEvent(target, mBeanInfo, invokeOperationName, invokeParams, returnValue);
                    }
                } finally {
                    if (isMFComponent && requestCountIncremented) {
                        unblockReload(canonicalName);
                    }
                }
            } catch (Throwable e) {
                ExceptionMapper.throwMappedException(e);
            }

            return returnValue;
        }

        /**
         * @return Return true if the notification registration does not need to be executed on the MBean (that is the
         *         case for a notification subscription renewal).
         */
        private boolean interceptNotificationRegistrationOperations(String operationName, Object[] params) {
            boolean isAdd = operationName.equals(ADD_NOTIFICATION_LISTENER_METHOD_NAME);
            boolean isRemove = operationName.equals(REMOVE_NOTIFICATION_LISTENER_METHOD_NAME);
            boolean isRemoveFilterHandbackPair = isRemove && params.length == 4;

            if (!(isAdd || isRemove)) {
                return false;
            }

            ObjectName objectName = removeFTInstanceNameFromObjectName((ObjectName)params[0]);
            objectName = ObjectNameHelper.translateGlobalObjectName(objectName, ContainerImpl.this.m_containerIdentity.getContainerName());

            com.sonicsw.mf.jmx.client.NotificationListenerDelegate remoteListener = (com.sonicsw.mf.jmx.client.NotificationListenerDelegate)params[1];
            String remoteListenerKey = geRemoteListenerKey(objectName, remoteListener);

            NotificationListenerDelegate localListener = null;

            synchronized (ContainerImpl.this.m_notificationListeners) {
                // note: params[0] = object name
                // params[1] = remote listener
                // params[2] = filter (if specified)
                // params[3] = handback (if specified)
                // params[4] = notification subscription timeout (not present in < v6.1, but we no longer support that)

                localListener = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.get(remoteListenerKey);

                if (isAdd) {
                    if (localListener == null) {
                        localListener = new NotificationListenerDelegate(objectName, remoteListener);
                        ContainerImpl.this.m_notificationListeners.put(remoteListenerKey, localListener);
                        localListener.setHandbackFilterPair(params[3], (NotificationFilter)params[2]);
                        localListener.setNotificationSubscriptionTimeout(((Long)params[4]).longValue());
                        storeNotificationListenerSubscriptionsInCache(objectName, localListener);
                        // have to clean up params and signature here if the new signature was used...
                        params[2] = null;
                        params[3] = null;

                        // ContainerImpl.this.logMessage(null,
                        // "interceptNotificationRegistrationOperations() initial add: " + remoteListenerKey,
                        // Level.TRACE);
                    } else // existing delegate
                    {
                        // ContainerImpl.this.logMessage(null,
                        // "interceptNotificationRegistrationOperations() initial renew/update: " + remoteListenerKey,
                        // Level.TRACE);

                        // validate the objectName is still known (it could have been removed since the client first
                        // subscribed ..in which case just let the call fall through)
                        if (ContainerImpl.this.m_mbeanServer.isRegistered(objectName)) {
                            localListener.setHandbackFilterPair(params[3], (NotificationFilter)params[2]);
                            localListener.setNotificationSubscriptionTimeout(((Long)params[4]).longValue());
                            storeNotificationListenerSubscriptionsInCache(objectName, localListener);
                            return true;
                        } else // object name is NOT registered with the MBean server...
                        {
                            localListener.removeHandbackFilterPair(params[3], (NotificationFilter)params[2]);
                            deleteNotificationListenerSubscriptionsFromCache(localListener);
                            if (localListener.getHandbackFilterPairs().size() == 0) {
                                NotificationListenerDelegate delegate = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.remove(remoteListenerKey);
                                delegate.close();
                                params[2] = null;
                                params[3] = null;
                            } else {
                                return true;
                            }
                        }
                    }
                } else if (isRemoveFilterHandbackPair) {
                    // can only do something if the delegate exists
                    if (localListener != null) {
                        // ContainerImpl.this.logMessage(null,
                        // "interceptNotificationRegistrationOperations() remove pair: " + remoteListenerKey,
                        // Level.TRACE);

                        localListener.removeHandbackFilterPair(params[3], (NotificationFilter)params[2]);
                        deleteNotificationListenerSubscriptionsFromCache(localListener);
                        if (localListener.getHandbackFilterPairs().size() == 0) {
                            NotificationListenerDelegate delegate = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.remove(remoteListenerKey);
                            delegate.close();
                            params[2] = null;
                            params[3] = null;
                        } else {
                            return true;
                        }
                    }
                } else // isRemove
                {
                    // ContainerImpl.this.logMessage(null, "interceptNotificationRegistrationOperations() remove: " +
                    // remoteListenerKey, Level.TRACE);

                    NotificationListenerDelegate delegate = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.remove(remoteListenerKey);
                    delegate.close();
                    localListener.removeAllHandbackFilterPairs();
                    deleteNotificationListenerSubscriptionsFromCache(localListener);
                }
            }

            params[1] = localListener;

            return false;
        }

        private String geRemoteListenerKey(ObjectName name, com.sonicsw.mf.jmx.client.NotificationListenerDelegate remoteListener) {
            StringBuffer sb = new StringBuffer(remoteListener.m_destination);
            sb.append(':').append(remoteListener.m_listenerHash).append(':').append(name.getCanonicalName());

            return sb.toString();
        }

        /**
         * Removes the [PRIMARY] or [BACKUP] from the given object name, to create a new object name that maps to the
         * real name used in this container.
         */
        private ObjectName removeFTInstanceNameFromObjectName(ObjectName objectName) {
            StringBuffer sb = new StringBuffer(ContainerImpl.this.m_containerIdentity.getCanonicalName());
            if (!(objectName.getDomain().equals(sb.toString()))) // the JMX domain name should map to the container name
            {
                sb.append(':');
                sb.append(objectName.getCanonicalKeyPropertyListString()); // gets the "ID=<id>" string
                try {
                    return new ObjectName(sb.toString());
                } catch (MalformedObjectNameException e) {
                }
            }

            // else no change required
            return objectName;
        }
    }

    private final class NotificationListenerExpirer extends Thread {
        private Object lockObj = new Object();

        private NotificationListenerExpirer() {
            super("Notification Listener Expirer");
            super.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    synchronized (lockObj) {
                        // check expirations every default renewal interval (does not have to be accurate)
                        lockObj.wait(CommunicationConstants.NOTIFICATION_SUBSCRIPTION_RENEWAL_INTERVAL);
                    }
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    Object[] subscriptions = ContainerImpl.this.m_notificationListeners.values().toArray();
                    for (int i = 0; i < subscriptions.length; i++) {
                        NotificationListenerDelegate delegate = (NotificationListenerDelegate)subscriptions[i];
                        if (delegate.hasExpired()) {
                            ContainerImpl.this.expireSubscription(delegate);
                        }
                        if (ContainerImpl.this.m_isClosing) {
                            return;
                        }
                    }
                }
            } catch (InterruptedException e) {
            }
        }

        public Object getLockObj() {
            return lockObj;
        }
    }

    private final class Monitor extends Thread {
        private boolean closing = false;

        private Object monitorLockObj = new Object();

        private Monitor() {
            super("Container Monitor");
            super.setDaemon(true);
        }

        private void close() {
            synchronized (monitorLockObj) {
                this.closing = true;
                monitorLockObj.notifyAll();
            }
        }

        @Override
        public void run() {
            File abortFile = new File(ContainerImpl.this.m_containerIdentity.getCanonicalName() + ".abort");
            boolean abort = false;
            boolean lsd = Boolean.getBoolean(IContainer.MF_LSD_COLOCATE_PROPERTY);

            while (!this.closing) {
                if (abort) {
                    return;
                }

                if (abortFile.exists()) {
                    abort = true;
                    abortFile.deleteOnExit();
                    ContainerImpl.this.logMessage(null,
                                                  "** ABORT FILE DETECTED: CONTAINER WILL HALT IF NOT SHUT DOWN WITHIN "
                                                      + Integer.getInteger(IContainer.MF_QA_ABORT_PROPERTY, 0) + " SECONDS **", Level.TRACE);

                    synchronized (monitorLockObj) {
                        try {
                            if (this.closing) {
                                return;
                            }
                            monitorLockObj.wait(Integer.getInteger(IContainer.MF_QA_ABORT_PROPERTY, 0).intValue() * 1000);
                            if (this.closing) {
                                return;
                            }
                        } catch (Exception e) {
                        }
                    }

                    // if we haven't shutdown by the expiry time, then dump the threads and just halt
                    ContainerImpl.this.logMessage(null,
                                                  "** CONTAINER SHUTDOWN NOT EXECUTED OR TIMED OUT, DUMPING THREAD LIST AND HALTING **",
                                                  Level.TRACE);
                    File threadListingFile = new File(ContainerImpl.this.m_containerIdentity.getCanonicalName() + ".threads");
                    threadListingFile.delete();
                    try {
                        PrintWriter out = new PrintWriter(new FileWriter(threadListingFile));
                        ThreadGroup tg = Thread.currentThread().getThreadGroup();
                        while (tg.getParent() != null) {
                            tg = tg.getParent();
                        }
                        Thread[] threads = new Thread[tg.activeCount() + 1000];
                        tg.enumerate(threads, true);
                        for (int i = 0; i < threads.length; i++) {
                            if (threads[i] != null) {
                                out.println(threads[i]);
                            }
                        }
                        out.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (!this.closing && !lsd) // if it was closing then we would be in shutdown at a point where halt
                                               // was about to be called
                    {
                        new File(IContainer.START_TIMESTAMP_FILE).delete();
                        m_containerRunningLockFile.unlock();
                        Runtime.getRuntime().halt(-100);
                    }
                }

                synchronized (monitorLockObj) {
                    try {
                        if (this.closing) {
                            return;
                        }
                        monitorLockObj.wait(5000);
                        if (this.closing) {
                            return;
                        }
                    } catch (Exception e) {
                    }
                }
            }
        }
    }
}
