package com.sonicsw.mf.framework.agent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;

public class DsdataURLStreamHandler
extends URLStreamHandler
{
    private ContainerImpl m_container;

    DsdataURLStreamHandler(ContainerImpl container)
    {
        m_container = container;
    }

    @Override
    protected URLConnection openConnection(URL url)
    throws IOException
    {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection
    {
        private Connection(URL url)
        {
            super(url);
        }

        @Override
        public void connect() throws IOException { }

        @Override
        public InputStream getInputStream()
        throws IOException
        {
            String dsdataUrl = url.getFile();
            int lastIndex = dsdataUrl.lastIndexOf('/');
            if (lastIndex > 0)
            {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(dsdataUrl.substring(0, lastIndex + 1).toLowerCase());
                sbuf.append(dsdataUrl.substring(lastIndex + 1));
                dsdataUrl = sbuf.toString();
            }
            String delim = dsdataUrl.charAt(0) == '/' ? "" : "/";
            IElement element = DsdataURLStreamHandler.this.m_container.getConfiguration("/xqFiles" + delim + dsdataUrl);

            if (element == null)
            {
                throw new IOException(url.toExternalForm() + " does not exist");
            }

            IAttributeSet attrs = element.getAttributes();
            Object fileContents = attrs.getAttribute("file");

            if (fileContents == null)
            {
                throw new IOException(url.toExternalForm() + " has no contents");
            }

            if (fileContents instanceof String)
            {
                return new ByteArrayInputStream(((String)fileContents).getBytes());
            }
            if (fileContents instanceof byte[])
            {
                return new ByteArrayInputStream((byte[])fileContents);
            }

            throw new IOException(url.toExternalForm() + " contains invalid contents type: " + fileContents.getClass().getName());
        }
    }
}
