package com.sonicsw.mf.framework.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;

import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IHostManager;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;

public final class FrameworkComponentMBean
extends ComponentMBean
{
    private static final String[] RECEIVE_CHANGED_ELEMENT_SIGNATURE = new String[] { IBasicElement.class.getName() };
    private static final String[] RECEIVE_CHANGED_ELEMENTS_SIGNATURE1 = new String[] { IBasicElement[].class.getName() };
    private static final String[] RECEIVE_CHANGED_ELEMENTS_SIGNATURE2 = new String[] { IDirElement[].class.getName() };

    public FrameworkComponentMBean(ContainerImpl container, IComponent component, String id, String configID)
    throws Exception
    {
        super(container, component, id, configID);
    }

    @Override
    boolean isOperationExported(String operationName, String[] signature)
    {
        if (super.isOperationExported(operationName, signature))
        {
            return true;
        }
        if (this.m_componentName.getComponentName().equals(IAgentProxy.ID))
        {
            if (operationName.equals("receiveChangedElement") && signature.length == 1 && signature[0].equals(RECEIVE_CHANGED_ELEMENT_SIGNATURE[0]))
            {
                return true;
            }
            if (operationName.equals("receiveChangedElements") && signature.length == 1 && signature[0].equals(RECEIVE_CHANGED_ELEMENTS_SIGNATURE1[0]))
            {
                return true;
            }
            if (operationName.equals("receiveChangedElements") && signature.length == 1 && signature[0].equals(RECEIVE_CHANGED_ELEMENTS_SIGNATURE2[0]))
            {
                return true;
            }
        }

        return false;
    }

    @Override
    IComponentContext getContext() { return new ContextImpl(); }

    @Override
    void addSharedPath(URL url)
    throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException("Adding a URL to the framework shared class loader is not supported");
    }

    @Override
    void addSharedClassname( String classname )
    throws UnsupportedOperationException
    {
        super.m_container.addSharedClassname( classname ) ;
    }

    private void makeGlobalComponentUniquenessCall(String globalComponentID, String callID)
    throws Exception
    {
        super.m_container.makeGlobalComponentUniquenessCall(globalComponentID, callID);
    }

    private void makeGlobalComponentUniquenessCall(String globalComponentID, String callID, String instanceID)
    throws Exception
    {
        super.m_container.makeGlobalComponentUniquenessCall(globalComponentID, callID, instanceID);
    }

    private void writeLibrary(String filename, InputStream stream)
    throws IOException
    {
        if (filename.indexOf('/') > -1 || filename.indexOf('\\') > -1)
        {
            throw new IOException("Filename cannot include path specifications: " + filename);
        }

        super.m_container.writeLibrary(filename, stream);
    }

    private String storageToLogical(String storageName)
    {
        return super.m_container.storageToLogical(storageName);
    }

    private IPermissionsManager getPermissionsManager()
    {
        return super.m_container.m_agent.getPermissionsManager();
    }

    private IAuditManager getAuditManager()
    {
        return super.m_container.m_agent.getAuditManager();
    }

    private IHostManager getHostManager()
    {
        return super.m_container.m_agent.getHostManager();
    }

    public class ContextImpl
    extends ComponentMBean.ContextImpl
    implements IFrameworkComponentContext
    {
        @Override
        public INotification createNotification(short category, String subCategory, String eventName, int severityLevel)
        {
            return FrameworkComponentMBean.super.createNotification(category, subCategory, eventName, severityLevel);
        }

        @Override
        public IContainer getContainer() { return FrameworkComponentMBean.this.m_container.getContainer(); }

        @Override
        public void loadComponent(String id, String configID, boolean start, int traceMask)
        throws Exception
        {
            FrameworkComponentMBean.super.loadComponent(id, configID, start, traceMask);
        }

        @Override
        public void unloadComponent(String id)
        throws Exception
        {
            FrameworkComponentMBean.super.unloadComponent(id);
        }

        @Override
        public Object invoke(String target, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout)
        throws Exception
        {
            return FrameworkComponentMBean.super.invoke(target, operationName, params, signature, synchronous, timeout);
        }

        @Override
        public ICollectiveOpStatus invoke(String[] targets, String operationName, Object[] params, String[] signature, boolean synchronous, long timeout)
        throws Exception
        {
            return FrameworkComponentMBean.super.invoke(targets, operationName, params, signature, synchronous, timeout);
        }

        @Override
        public String[] setAttributes(String target, String[] attributeNames, Object[] attributeValues, boolean synchronous)
        throws Exception
        {
            return (String[])FrameworkComponentMBean.super.invoke(target, "setAttributes", new Object[] { attributeNames, attributeValues }, SET_ATTRIBUTES_SIGNATURE, synchronous, 0);
        }

        @Override
        public Object[] getAttributeValues(String source, String[] attributeNames)
        throws Exception
        {
            return (Object[])FrameworkComponentMBean.super.invoke(source, "getAttributeValues", new Object[] { attributeNames }, GET_ATTRIBUTE_VALUES_SIGNATURE, true, 0);
        }

        // the implementation of this method is very similar to that in the regular context,
        // however in this case we use a pooled thread
        @Override
        public void scheduleTask(Runnable task, Date startTime) { FrameworkComponentMBean.this.scheduleTask(task, startTime, true); }

        @Override
        public void setNotificationSubscriptionRenewalInterval(Long notificationSubscriptionRenewalInterval)
        {
            FrameworkComponentMBean.super.setNotificationSubscriptionRenewalInterval(notificationSubscriptionRenewalInterval);
        }

        @Override
        public Long getNotificationSubscriptionRenewalInterval()
        {
            return FrameworkComponentMBean.super.getNotificationSubscriptionRenewalInterval();
        }

        @Override
        public void addNotificationHandler(String notificationSource, INotificationHandler handler, String[] notificationTypes)
        {
            FrameworkComponentMBean.super.addNotificationHandler(notificationSource, handler, notificationTypes);
        }

        @Override
        public void removeNotificationHandler(String notificationSource, INotificationHandler handler)
        {
            FrameworkComponentMBean.super.removeNotificationHandler(notificationSource, handler);
        }

        @Override
        public void makeGlobalComponentUniquenessCall(String globalComponentID, String callID)
        throws Exception
        {
            FrameworkComponentMBean.this.makeGlobalComponentUniquenessCall(globalComponentID, callID);
        }

        @Override
        public void makeGlobalComponentUniquenessCall(String globalComponentID, String callID, String instanceID)
        throws Exception
        {
            FrameworkComponentMBean.this.makeGlobalComponentUniquenessCall(globalComponentID, callID, instanceID);
        }

        @Override
        public void addSharedClassname(String classname)
        {
            FrameworkComponentMBean.this.addSharedClassname(classname);
        }

        @Override
        public void writeLibrary(String filename, InputStream stream)
        throws IOException
        {
            FrameworkComponentMBean.this.writeLibrary(filename, stream);
        }

        @Override
        public String storageToLogical(String storageName)
        {
            // since this could be indirectly called by FGS from an external request thread we must ensure
            // we have full permission to execute
            String currentUserID = TaskScheduler.getCurrentUserID();
            if (TaskScheduler.isExecutionThread())
            {
                ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(IManagementPermission.SUPER_USER_NAME);
            }
            try
            {
                return FrameworkComponentMBean.this.storageToLogical(storageName);
            }
            finally
            {
                if (TaskScheduler.isExecutionThread())
                {
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(currentUserID);
                }
            }
        }

        @Override
        public IPermissionsManager getPermissionsManager()
        {
            return FrameworkComponentMBean.this.getPermissionsManager();
        }

        @Override
        public IAuditManager getAuditManager()
        {
            return FrameworkComponentMBean.this.getAuditManager();
        }

        @Override
        public IHostManager getHostManager()
        {
            return FrameworkComponentMBean.this.getHostManager();
        }
    }
}